/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.column;

import java.util.LinkedHashMap;
import java.util.Map;

import org.sql.exception.GeneratorException;
import org.sql.generator.SelectSql;
import org.sql.type.Types;


/**
 * JǗNX.
 *
 * @author S.Nagashiba
 */
public class SelectColumn extends AbstractSelectColumn {

	/** SQLIuWFNgƃp[^l̃}bv */
	private Map map = new LinkedHashMap();
	
    /**
     * RXgN^
     */
    public SelectColumn() {
        super();
    }
    
    /**
     * RXgN^
     * @param column J
     */
    public SelectColumn(String column) {
        append(column);
    }
    
    /**
     * RXgN^
     * @param columns Jz
     */
    public SelectColumn(String[] columns) {
        append(columns);
    }
    
	/**
	 * Jǉ
	 * @param arg ʂǗIuWFNg
	 * @param as  GCAX
	 */
	public void append(Types arg, String as) {
        super.append(arg.toTypeString(), as);
	}
	
	/**
	 * Jǉ
	 * @param column J
	 * @param as GCAX
	 */
	public void append(Number column, String as) {
        super.append(column.toString(), as);
	}
	
	/**
	 * Jǉ
	 * @param map JƃGCAX̃}bv
	 */
	public void append(Map map) {
	    Object[] key = map.keySet().toArray();
	    for (int i = 0; i < key.length; i++) {
	    	super.append(key[i].toString(), map.get(key[i]).toString());
	    }
	}
	
	/**
	 * Jǉ
	 * @param arg SQLJ
	 * @param as GCAX
	 * @throws GeneratorException SQLO
	 */
	public void append(SelectSql arg, String as) throws GeneratorException {
        super.append(arg, as);
        map.put(arg, arg.getParameter());
	}
	
	/**
	 * J}bv擾
	 * @return J}bv
	 */
	public Map getMap() {
	    return this.map;
	}
}
