/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.comparison;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.sql.exception.ComparisonException;
import org.sql.item.DefaultItem;
import org.sql.util.GeneratorUtil;

/**
 * oChrǗ钊ۃNX.
 *
 * @author S.Nagashiba
 */
public abstract class AbstractBindComparison extends AbstractComparison implements BindComparison {
	
	/**  */
	private DefaultItem comparison;
	
	/**
	 * oCh擾
	 * @return oCh
	 * @throws ComparisonException rO
	 */
	public final String toBindString() throws ComparisonException {
		return createBindComparison(this.comparison);
	}
	
	/**
	 * oChp[^擾
	 * @return oChp[^
	 */
	public Object[] getParameter() {
		List list = Arrays.asList(this.comparison.getValue());
		List result = new ArrayList();
		for (Iterator it = list.iterator(); it.hasNext();) {
			Object object = it.next();
			if (GeneratorUtil.isExclusion(object.toString())) continue;
			result.add(object);
		}
		return result.toArray();
	}
	
	/**
	 * ݒ肷
	 * @param comparison 
	 */
	protected final  void setComparison(DefaultItem comparison) {
		super.setComparison(comparison);
		this.comparison = comparison;
	}
	
	/**
	 * oChr쐬
	 * @param item ACe
	 * @return r
	 * @throws ComparisonException rO
	 */
	protected abstract String createBindComparison(DefaultItem item) throws ComparisonException;
}
