/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.generator;

import org.sql.column.RegistColumn;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.message.Message;
import org.sql.util.GeneratorUtil;


/**
 * XVSQLNX.
 * 
 * <P>
 * XVAe[uAݒ肵܂B<br>
 * <br>
 * ݒ肳ꂽeIuWFNgSQL\z܂B<br>
 * <br>
 * <b>Java\[XTv</b><br>
 * <table><tr><td class="SampleCode">
 *         j<font color="blue">UPDATE TABLE1 SET COLUMN1 = '', COLUMN2 = '' WHERE COLUMN3 = ''</font><br>
 *         <br>
 *         @RegistColumn column = new RegistColumn();<br>
 *         @column.append("COLUMN1", "");<br>
 *         @column.append("COLUMN2", "");<br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.eq("COLUMN3", ""));<br>
 *         @<br>
 *         @UpdateSql sql = new UpdateSql("TABLE1", column);<br>
 *         @sql.setCondition(condition);<br>
 * </td></tr></table>
 * <P>
 *
 * @author S.Nagashiba
 */
public class UpdateSql extends AbstractConditionSql {

	/**
	 * RXgN^
	 * @param table e[u
	 */
	public UpdateSql(String table) {
		super(table);
	}
	
	/**
	 * RXgN^
	 * @param table e[u
	 * @param column XVJ
	 */
	public UpdateSql(String table, RegistColumn column) {
		super(table);
		super.setColumn(column);
	}
	
	/**
	 * SQL쐬
	 * @param bind ߍ݌^SQL[true]AʏSQL[false]
	 * @return SQL
	 * @throws GeneratorException SQLO
	 */
	protected String createSql(boolean bind) throws GeneratorException {
		StringBuffer result = new StringBuffer();
		if (super.getCondition() == null) {
			super.setCondition(new Condition());
		}
		if (!GeneratorUtil.isNaming(getFrom())) {
		    throw new GeneratorException(Message.getInstance("SQL-001", getFrom()));
		}
		result.append("UPDATE ");
		result.append(getFrom());
		result.append(" SET ");
		if (bind) {
			result.append(getBindVariable());
			result.append(super.getCondition().getBindCondition());
		}
		else {
			result.append(super.getColumn().toColumnString());
			result.append(super.getCondition().getCondition());
		}
		return result.toString();
	}
	
	/**
	 * oChϐ擾
	 * @return oChϐ
	 */
	protected String getBindVariable() {
		StringBuffer result = new StringBuffer();
		Object[] key = super.getColumn().getMap().keySet().toArray();
		for (int i = 0; i < key.length; i++) {
			if (result.length() > 0) result.append(", ");
			Object value = super.getColumn().getMap().get(key[i]);
			if (GeneratorUtil.isExclusion(value.toString())) {
				result.append(key[i] + " = " + GeneratorUtil.getExclusion(value.toString()));
			}
			else {
				result.append(key[i] + " = ?");
			}
		}
		return result.toString();
	}
}
