/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.message;

import java.util.ResourceBundle;


/**
 * G[bZ[WǗNX.
 * 
 * @author S.Nagashiba
 */
public final class Message {

    /** bZ[Wt@C */
    private static final String PROPERTIES_DIR = "org.sql.properties.Messages";
    
    /** G[R[h */
    private String errorCode = null;
    /** G[bZ[W */
    private String errorMessage = null;
    
	/**
	 * RXgN^iÕCX^XȂj
	 */
	private Message() {}
	
	/**
	 * RXgN^
	 * @param errorCode G[R[h
	 */
	private Message(String errorCode) {
	    this.errorCode = errorCode;
        ResourceBundle bundle = ResourceBundle.getBundle(PROPERTIES_DIR);
        this.errorMessage = bundle.getString(this.errorCode);
	}
	
	/**
	 * RXgN^
	 * @param errorCode G[R[h
	 * @param object P
	 */
	private Message(String errorCode, Object object) {
	    this(errorCode, new Object[]{object});
	}
	
	/**
	 * RXgN^
	 * @param errorCode G[R[h
	 * @param objects Pz
	 */
	private Message(String errorCode, Object[] objects) {
	    this(errorCode);
	    StringBuffer message = new StringBuffer(this.errorMessage);
	    message.append("[");
	    for (int i = 0; i < objects.length; i++) {
	        if (i > 0) {
	            message.append(", ");
	        }
	        message.append(objects[i]);
	    }
	    message.append("]");
	    this.errorMessage = message.toString();
	}
	
	/**
	 * G[bZ[W擾
	 * @return G[bZ[W
	 */
	public String getMessage() {
	    return this.errorCode + "F" + this.errorMessage;
	}

	/**
	 * G[bZ[WǗIuWFNg擾
	 * @param errorCode G[R[h
	 * @return bZ[WIuWFNg
	 */
    public static Message getInstance(String errorCode) {
        return new Message(errorCode);
    }
    
	/**
	 * G[bZ[WǗIuWFNg擾
	 * @param errorCode G[R[h
	 * @param object P
	 * @return bZ[WIuWFNg
	 */
    public static Message getInstance(String errorCode, Object object) {
        return new Message(errorCode, object);
    }
    
	/**
	 * G[bZ[WǗIuWFNg擾
	 * @param errorCode G[R[h
	 * @param objects Pz
	 * @return bZ[WIuWFNg
	 */
    public static Message getInstance(String errorCode, Object[] objects) {
        return new Message(errorCode, objects);
    }
}
