/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.table;

import java.util.Map;


/**
 * e[uǗNX.
 *
 * @author S.Nagashiba
 */
public class JoinTable extends AbstractTable {

    /** \ */
    private JoinTableInfo[] infos;
	
    /**
     * RXgN^
     * @param info \
     */
    public JoinTable(JoinTableInfo info) {
        this(new JoinTableInfo[] {info});
    }
    
    /**
     * RXgN^
     * @param infos \z
     */
    public JoinTable(JoinTableInfo[] infos) {
        super();
        this.infos = infos;
        for (int i = 0; i < infos.length; i++) {
            super.createTableMap(infos[i].getTable1());
            super.createTableMap(infos[i].getTable2());
        }
    }
    
	/**
	 * e[u擾
	 * @return e[u
	 */
    public String toTableString() {
        StringBuffer result = new StringBuffer();
        Map map = super.getTableMap();
        for (int i = 0; i < this.infos.length; i++) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(infos[i].getTable1());
            result.append(" ");
            result.append(map.get(infos[i].getTable1()));
            result.append(infos[i].getJoin().toTypeString());
            result.append(infos[i].getTable2());
            result.append(" ");
            result.append(map.get(infos[i].getTable2()));
            result.append(" ON ");
            result.append(map.get(infos[i].getTable1()) + "." + infos[i].getColumn1());
            result.append(" = ");
            result.append(map.get(infos[i].getTable2()) + "." + infos[i].getColumn2());
        }
        return result.toString();
    }
    
	/**
	 * e[uNA
	 */
    public void clear() {
    	super.clear();
        this.infos = null;
    }
}
