using System;
using System.Data;

using SQLiteCSLib.Inner;

namespace SQLiteCSLib
{
	/// <summary>
	/// SQLiteO
	/// </summary>
	public class SQLiteException : DataException
	{
		/// <summary>
		/// ߒl
		/// </summary>
		protected ResultEnum m_errcode = ResultEnum.ERROR;

		/// <summary>
		/// RXgN^
		/// </summary>
		public SQLiteException( SQLiteConnection connect ) : base( (connect != null ) ? connect.OSQLiteDB.getLastErrMsg():"Fail!!" )
		{
			if( connect != null )
			{
				m_errcode = (ResultEnum)connect.OSQLiteDB.getLastErr();
			}
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		public SQLiteException( OSQLiteStmtWrap stmt ) : base( (stmt != null ) ? stmt.DbWrap().getLastErrMsg():"Fail!!" )
		{
			if( stmt != null )
			{
				m_errcode = (ResultEnum)stmt.DbWrap().getLastErr();
			}
		}

	}
}
