using System;
using System.IO;
using System.Runtime.InteropServices;


namespace SQLiteCSLib.Inner
{
	/// <summary>
	/// SQLite3 [U`֐
	/// </summary>
	public class OSQLiteFunc : IDisposable
	{
		/// <summary>
		/// R[obN|C^
		/// </summary>
		GCHandle m_funcpoint ;
		GCHandle m_steppoint ;
		GCHandle m_finalpoint ;

		/// <summary>
		/// f[^x[X
		/// </summary>
		protected OSQLiteDBWrap m_db;

		/// <summary>
		/// R[obNC^[tF[X
		/// </summary>
		protected ICallUserFunction m_callinterface;

		/// <summary>
		/// R[obN^(}l[W)
		/// </summary>
		unsafe protected delegate void CallFuncDelegate( IntPtr context,int argc, void** inparams );
		unsafe protected delegate void CallStepDelegate( IntPtr context,int argc, void** inparams );
		unsafe protected delegate void CallFinalDelegate( IntPtr context );

#if MOBILEPC

		/// <summary>
		/// |[OtO
		/// </summary>
		protected IntPtr m_disposeevent = IntPtr.Zero;

		/// <summary>
		/// CLRpR[obNCxg
		/// </summary>
		protected IntPtr m_clrevent;

		/// <summary>
		/// osqlite3collation|C^
		/// </summary>
		protected IntPtr m_nativepoint ;
#endif

		/// <summary>
		/// RXgN^
		/// </summary>
		public OSQLiteFunc( OSQLiteDBWrap db, ICallUserFunction iCallinterface )
		{
			m_db = db;
			m_callinterface = iCallinterface;

			unsafe
			{
				m_funcpoint = GCHandle.Alloc( new CallFuncDelegate( CallFunc ) );
				m_steppoint = GCHandle.Alloc( new CallStepDelegate( CallStep ) );
				m_finalpoint = GCHandle.Alloc( new CallFinalDelegate( CallFinal ) );
			}

#if MOBILEPC
			m_disposeevent = CreateEvent( IntPtr.Zero , true, false, IntPtr.Zero );
#endif
		}

		/// <summary>
		/// fXgN^
		/// </summary>
		~OSQLiteFunc()
		{
			Dispose();
		}

		/// <summary>
		/// j
		/// </summary>
		public void Dispose()
		{
#if MOBILEPC
			EventModify( m_disposeevent, 3 );
			CloseHandle( m_disposeevent );
			CloseHandle( m_clrevent );
#endif

			if( m_db != null )
			{
				m_funcpoint.Free();
				m_steppoint.Free();
				m_finalpoint.Free();
				m_db = null;
				m_callinterface = null;
			}
		}

		/*
		*** ֐쐬
		*/
		public ResultEnum CreateFunction( string funcname, int inArg )
		{
#if MOBILEPC
			m_clrevent = CreateEvent( IntPtr.Zero , false, false, IntPtr.Zero );

			//|[OJn
			System.Threading.Thread thread = new System.Threading.Thread( new System.Threading.ThreadStart(OnCallBackThread) );
			thread.Start();

			if( m_callinterface is IScalarCallUserFunction )
			{
				//XJ[֐p
				return (ResultEnum)osqlite3_createfunction( m_db.internaldb(), funcname, inArg, (int)CAPI3REF.UTF16,
					m_clrevent, ref m_nativepoint, true, false, false );
			}
			else
			if( m_callinterface is IAggregateCallUserFunction )
			{
				//W֐p
				return (ResultEnum)osqlite3_createfunction( m_db.internaldb(), funcname, inArg, (int)CAPI3REF.UTF16,
					m_clrevent, ref m_nativepoint, false, true, true );
			}

			return ResultEnum.ERROR;
#else
			if( m_callinterface is IScalarCallUserFunction )
			{
				//XJ[֐p
				unsafe
				{
					return (ResultEnum)osqlite3_createfunction( m_db.internaldb(), funcname, inArg, (int)CAPI3REF.UTF16,
						m_funcpoint.Target as CallFuncDelegate,
						null,null );
				}
			}
			else
			if( m_callinterface is IAggregateCallUserFunction )
			{
				//W֐p
				unsafe
				{
					return (ResultEnum)osqlite3_createfunction( m_db.internaldb(), funcname, inArg, (int)CAPI3REF.UTF16,
						null,
						m_steppoint.Target as CallStepDelegate,
						m_finalpoint.Target as CallFinalDelegate );
				}
			}

			return ResultEnum.ERROR;
#endif
		}

#if MOBILEPC

		/// <summary>
		/// R[obNҋ@Xbh
		/// </summary>
		protected void OnCallBackThread()
		{
			//Cxg҂(0..|[O 1..R[obNCxg)
			IntPtr[] handles = new IntPtr[2]{m_disposeevent,m_clrevent};
		
			while( true )
			{
				int multiWaitRes = WaitForMultipleObjects( 2, handles, false, 3600000 );
				if( multiWaitRes == 0 )
					break;
				if( multiWaitRes == 1 )
				{
					IntPtr context = IntPtr.Zero;
					int argc = 0;

					unsafe
					{
						//擾
						int iKind = osqlite3func_GetCallBackParam( m_nativepoint, ref argc );

						switch( iKind )
						{
							case 1:
							{
								//XJ[֐R[obN
								CallFunc( context, argc, null );
							}
								break;
							case 2:
							{
								//W֐XebvR[obN
								CallStep( context, argc, null );
							}
								break;
							case 3:
								//W֐ŏIR[obN
								CallFinal( context );
								break;
						}

						//R[obN
						osqlite3func_FinishCallBackParam( m_nativepoint );
					}
				}
			}
		}
#endif

		/// <summary>
		/// XJ[֐R[obN
		/// </summary>
		/// <param name="context">ReLXg</param>
		/// <param name="argc"></param>
		/// <param name="inparams">Xg</param>
		unsafe protected virtual void CallFunc( IntPtr context,int argc, void** inparams )
		{
			IScalarCallUserFunction iScalar = m_callinterface as IScalarCallUserFunction;
			if( iScalar != null  )
			{
				object returnval = iScalar.CallFunc( CreateParams(argc,inparams) );
				if( returnval != null )
				{
					SetResultValue( context, returnval );
				}
			}
		}

		/// <summary>
		/// W֐XebvR[obN
		/// </summary>
		/// <param name="context">ReLXg</param>
		/// <param name="argc"></param>
		/// <param name="inparams">Xg</param>
		unsafe protected virtual void CallStep( IntPtr context,int argc, void** inparams )
		{
			IAggregateCallUserFunction iAggregate = m_callinterface as IAggregateCallUserFunction;
			if( iAggregate != null  )
			{
				iAggregate.CallStep( CreateParams(argc,inparams) );
			}
		}

		/// <summary>
		/// W֐ŏIR[obN
		/// </summary>
		/// <param name="context">ReLXg</param>
		unsafe protected virtual void CallFinal( IntPtr context )
		{
			IAggregateCallUserFunction iAggregate = m_callinterface as IAggregateCallUserFunction;
			if( iAggregate != null  )
			{
				object returnval = iAggregate.CallFinal();
				if( returnval != null )
				{
					SetResultValue( context, returnval );
				}
			}
		}

#if MOBILEPC
		/// <summary>
		/// [U`֐p[^쐬
		/// </summary>
		/// <param name="argc"></param>
		/// <param name="inparams">Xg(gp)</param>
		/// <returns>}l[WXg</returns>
		unsafe protected object[] CreateParams( int argc , void** inparams )
		{
			object[] argslist = new object[argc];

			for( int iIdx=0; iIdx<argc; iIdx++ )
			{
				DATATYPE iType = (DATATYPE)osqlite3func_GetParamType( m_nativepoint, iIdx );
				switch( iType )
				{
					case DATATYPE.INTEGER:
						argslist[ iIdx ] = osqlite3func_GetParamInt( m_nativepoint, iIdx );
						break;
					case DATATYPE.FLOAT:
					{
						double dVal = 0.0;
						osqlite3func_GetParamDouble( m_nativepoint, iIdx, ref dVal );
						argslist[ iIdx ] = dVal;
					}
						break;
					case DATATYPE.BLOB:
					{
						int valsize = 0;
						IntPtr pBin = osqlite3func_GetParamBlob( m_nativepoint, iIdx, ref valsize );

						byte[] managememory = new byte[valsize];
						Marshal.Copy( pBin, managememory, 0, valsize );

						argslist[ iIdx ] = managememory;
					}
						break;
					case DATATYPE.DBNULL:
						argslist[ iIdx ] = null;
						break;
					case DATATYPE.TEXT:
						argslist[ iIdx ] = StringFromC.String( osqlite3func_GetParamText( m_nativepoint, iIdx ) );
						break;
				}
			}

			return argslist;
		}
#else
		/// <summary>
		/// [U`֐p[^쐬
		/// </summary>
		/// <param name="argc"></param>
		/// <param name="inparams">Xg</param>
		/// <returns>}l[WXg</returns>
		unsafe protected object[] CreateParams( int argc , void** inparams )
		{
			object[] argslist = new object[argc];

			for( int iIdx=0; iIdx<argc; iIdx++ )
			{
				void* val = inparams[ iIdx ];

				if( val != null )
				{
					IntPtr context = new IntPtr(val);

					DATATYPE iType = (DATATYPE)__sqlite3_value_type( context );

					switch( iType )
					{
					case DATATYPE.INTEGER:
						argslist[ iIdx ] = __sqlite3_value_int64( context );
						break;
					case DATATYPE.FLOAT:
						argslist[ iIdx ] = __sqlite3_value_double( context ) ;
						break;
					case DATATYPE.BLOB:
						{
							IntPtr pBin = __sqlite3_value_blob( context );
							int valsize = __sqlite3_value_bytes( context );

							byte[] managememory = new byte[valsize];
							Marshal.Copy( pBin, managememory, 0, valsize );

							argslist[ iIdx ] = managememory;
						}

						break;
					case DATATYPE.DBNULL:
						argslist[ iIdx ] = null;
						break;
					case DATATYPE.TEXT:
						argslist[ iIdx ] = __sqlite3_value_text16( context );
						break;
					}
				}
			}

			return argslist;
		}
#endif

#if MOBILEPC
		/*
		*** ֐߂lZbg
		*/
		void SetResultValue( IntPtr context, object returnval )
		{
			if( returnval is Int32 )
			{
				osqlite3func_SetResultInt( m_nativepoint, (Int32)returnval );
				return;
			}
			else
				if( returnval is Int64 )
			{
				osqlite3func_SetResultInt( m_nativepoint, (Int32)returnval );
				return;
			}
			else
				if( returnval is double )
			{
				double val = (double)returnval;
				osqlite3func_SetResultDouble( m_nativepoint, ref val );
				return;
			}
			else
				if( returnval is string )
			{
				string sRetStr = (string)returnval;

				System.Text.Encoder enc = System.Text.Encoding.Unicode.GetEncoder();
				int iLen = enc.GetByteCount( sRetStr.ToCharArray(), 0, sRetStr.Length, true );
				osqlite3func_SetResultText( m_nativepoint, sRetStr, iLen );
				return;
			}
			else
				if( returnval is byte[] )
			{
				byte[] bBin = returnval as byte[];
				int iValLen = (int)bBin.Length;

				//oCiA}l[WփRs[
				IntPtr pBin = IntPtr.Zero;
				try
				{
					//A}l[Wm
					pBin = AllocHGlobal( iValLen );

					//}l[WA}l[WփRs[
					Marshal.Copy( bBin, 0, pBin, iValLen );

					osqlite3func_SetResultBlob( m_nativepoint, pBin, iValLen );
				}
				finally
				{
					if( pBin != IntPtr.Zero )
					{
						FreeHGlobal(pBin);
					}
				}

				return;
			}
		}
#else
		/*
		*** ֐߂lZbg
		*/
		void SetResultValue( IntPtr context, object returnval )
		{
			if( returnval is Int32 )
			{
				__sqlite3_result_int( context, (Int32)returnval );
				return;
			}
			else
			if( returnval is Int64 )
			{
				__sqlite3_result_int64( context, (Int64)returnval );
				return;
			}
			else
			if( returnval is double )
			{
				__sqlite3_result_double( context, (double)returnval );
				return;
			}
			else
			if( returnval is string )
			{
				string sRetStr = (string)returnval;

				System.Text.Encoder enc = System.Text.Encoding.Unicode.GetEncoder();
				int iLen = enc.GetByteCount( sRetStr.ToCharArray(), 0, sRetStr.Length, true );
				__sqlite3_result_text16( context, sRetStr, iLen );
				return;
			}
			else
			if( returnval is byte[] )
			{
				byte[] bBin = returnval as byte[];
				int iValLen = (int)bBin.Length;

				//oCiA}l[WփRs[
				IntPtr pBin = IntPtr.Zero;
				try
				{
					//A}l[Wm
					pBin = Marshal.AllocHGlobal( iValLen );

					//}l[WA}l[WփRs[
					Marshal.Copy( bBin, 0, pBin, iValLen );

					__sqlite3_result_blob( context, pBin, iValLen );
				}
				finally
				{
					if( pBin != IntPtr.Zero )
					{
						Marshal.FreeHGlobal(pBin);
					}
				}

				return;
			}
		}
#endif

		#region A}l[W`

#if MOBILEPC
		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static int osqlite3_createfunction( IntPtr instance, string funcname,
			int iarg, int eTextRep, IntPtr clrevent, ref IntPtr nativepoint, bool xFunc, bool xStep, bool xFinal );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static int osqlite3func_GetCallBackParam( IntPtr instance, ref int pargc );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static int osqlite3func_GetParamType( IntPtr instance, int iNo );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static int osqlite3func_GetParamInt( IntPtr instance, int iNo );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void osqlite3func_GetParamDouble( IntPtr instance, int iNo, ref double pResult );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static IntPtr osqlite3func_GetParamText( IntPtr instance, int iNo );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static IntPtr osqlite3func_GetParamBlob( IntPtr instance, int iNo, ref int iLen );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void osqlite3func_FinishCallBackParam( IntPtr instance );

		[DllImport("coredll.dll", SetLastError=true)]
		static extern IntPtr CreateEvent(IntPtr lpsa, bool fManualReset, bool fInitialState, IntPtr lpszEventName );

		[DllImport("coredll.dll", SetLastError=true)]
		static extern bool CloseHandle(IntPtr handle );

		[DllImport("coredll.dll", SetLastError=true)]
		static extern bool EventModify(IntPtr handle, int dEvent );

		[DllImport("coredll.dll", SetLastError=true)]
		static extern int WaitForSingleObject(IntPtr hHandle, int dwMilliseconds);

		[DllImport("coredll.dll", SetLastError=true)]
		static extern int WaitForMultipleObjects( int nCount, IntPtr[] hHandles, bool fWaitAll, int dwMilliseconds);

/*
DWORD nCount,             // z̃nh̐
  CONST HANDLE *lpHandles,  // IuWFNgnhȂz
  BOOL fWaitAll,            // ҋ@IvV
  DWORD dwMilliseconds      // ^CAEg
*/

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static IntPtr AllocHGlobal( int isize );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void FreeHGlobal( IntPtr pMem );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void osqlite3func_SetResultInt(IntPtr instance, int val );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void osqlite3func_SetResultDouble(IntPtr instance, ref double val );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void osqlite3func_SetResultText(IntPtr instance, string val, int iLen );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void osqlite3func_SetResultBlob(IntPtr instance, IntPtr val, int iLen );

#else
		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static int osqlite3_createfunction( IntPtr instance, string funcname,
			int iarg, int eTextRep,
			CallFuncDelegate xFunc,
			CallStepDelegate xStep,
			CallFinalDelegate xFinal );
#endif
		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static int __sqlite3_value_type( IntPtr inparam );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static long __sqlite3_value_int64( IntPtr inparam );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static double __sqlite3_value_double( IntPtr inparam );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static int __sqlite3_value_bytes( IntPtr inparam );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static IntPtr __sqlite3_value_blob( IntPtr inparam );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static string __sqlite3_value_text16( IntPtr inparam );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void __sqlite3_result_int( IntPtr inparam, int val );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void __sqlite3_result_int64( IntPtr inparam, long val );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void __sqlite3_result_double( IntPtr inparam, double val );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void __sqlite3_result_text16( IntPtr inparam, string val, int ilen );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void __sqlite3_result_blob( IntPtr inparam, IntPtr val, int ilen );
		
		#endregion
	}
}
