/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import java.text.MessageFormat;
import org.sqlite.Database;
import org.sqlite.Driver;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SQLite3Constants;

/**
 *
 * @author calico
 */
public class JdbcDatabaseMetaData implements DatabaseMetaData {

    private final Database db;
    private final Connection conn;
    
    JdbcDatabaseMetaData(Database db, Connection conn) {
        this.db = db;
        this.conn = conn;
    }
    
    // START implements
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public String getURL() throws SQLException {
        return db.getURL();
    }

    public String getUserName() throws SQLException {
        return null;
    }

    public boolean isReadOnly() throws SQLException {
        return conn.isReadOnly();
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return "SQLite";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return SQLite3.getSqlite3_version();
    }

    public String getDriverName() throws SQLException {
        return Driver.getDriverName();
    }

    public String getDriverVersion() throws SQLException {
        return Driver.getDriverVersion();
    }

    public int getDriverMajorVersion() {
        return Driver.getDriverMajorVersion();
    }

    public int getDriverMinorVersion() {
        return Driver.getDriverMinorVersion();
    }

    public boolean usesLocalFiles() throws SQLException {
        return true;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public String getIdentifierQuoteString() throws SQLException {
        // TODO 要調査！
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        // TODO 要調査！
        return "";
//        return
//            "ALTER TABLE,"
//            + "ANALYZE,"
//            + "ATTACH DATABASE,"
//            + "BEGIN TRANSACTION,"
//            + "comment,"
//            + "COMMIT TRANSACTION,"
//            + "CREATE INDEX,"
//            + "CREATE TABLE,"
//            + "CREATE TRIGGER,"
//            + "CREATE VIEW,"
//            + "CREATE VIRTUAL TABLE,"
//            + "DELETE,"
//            + "DETACH DATABASE,"
//            + "DROP INDEX,"
//            + "DROP TABLE,"
//            + "DROP TRIGGER,"
//            + "DROP VIEW,"
//            + "END TRANSACTION,"
//            + "EXPLAIN,"
//            + "expression,"
//            + "INSERT,"
//            + "ON CONFLICT clause,"
//            + "PRAGMA,"
//            + "REINDEX,"
//            + "REPLACE,"
//            + "ROLLBACK TRANSACTION,"
//            + "SELECT,"
//            + "UPDATE,"
//            + "VACUUM";
    }

    public String getNumericFunctions() throws SQLException {
        return "";
    }

    public String getStringFunctions() throws SQLException {
        return "";
    }

    public String getSystemFunctions() throws SQLException {
        return "";
    }

    /***
     * 
     * @see http://www.sqlite.org/cvstrac/wiki?p=DateAndTimeFunctions
     * @return
     * @throws java.sql.SQLException
     */
    public String getTimeDateFunctions() throws SQLException {
        return
            "date,"
            + "time,"
            + "datetime,"
            + "julianday,"
            + "strftime";
    }

    /**
     * Escape charactor is NOTHING.
     * @return  null
     * @throws java.sql.SQLException
     */
    public String getSearchStringEscape() throws SQLException {
        return null;
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    /**
     * Supported by SQLite 3.0.0 or later.
     * @return
     * @throws java.sql.SQLException
     */
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
//        return (SQLite3Constants.SQLITE_VERSION_NUMBER > 3000000);
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        // TODO JavaDoc の説明文が意味不明...
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    /***
     *
     * @see org.sqlite.jdbc.Statement#getMoreResults();
     * @return
     * @throws java.sql.SQLException
     */
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    /**
     * 
     * @see http://www.sqlite.org/cvstrac/wiki?p=UnsupportedSql
     * @return
     * @throws java.sql.SQLException
     */
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    /**
     * 
     * @see http://www.sqlite.org/cvstrac/wiki?p=UnsupportedSql
     * @return
     * @throws java.sql.SQLException
     */
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    /**
     * 
     * @see http://www.sqlite.org/cvstrac/wiki?p=UnsupportedSql
     * @return
     * @throws java.sql.SQLException
     */
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        // TODO 要調査！
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        // TODO 要調査！
        return "schema";
    }

    /**
     * Procedure is not supported yet.
     * @return  null
     * @throws java.sql.SQLException
     */
    public String getProcedureTerm() throws SQLException {
        return null;
    }

    /**
     * Catalog is not supported yet.
     * @return  null
     * @throws java.sql.SQLException
     */
    public String getCatalogTerm() throws SQLException {
        return null;
    }

    /**
     * Catalog is not supported yet.
     * @return  false
     * @throws java.sql.SQLException
     */
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    /**
     * Catalog is not supported yet.
     * @return  null
     * @throws java.sql.SQLException
     */
    public String getCatalogSeparator() throws SQLException {
        return null;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        // TODO ROWID or OID or _ROWID_ で削除できるということ？
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        // TODO ROWID or OID or _ROWID_ で更新できるということ？
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        // TODO 要調査！
        return false;
    }

    /**
     * 
     * @see http://www.3rd-impact.net/Document/SQLite/Translation/Current/datatype3.html#collation
     * @return
     * @throws java.sql.SQLException
     */
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        // TODO 要調査！
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    /**
     * Cursor is not supported yet.
     * @return
     * @throws java.sql.SQLException
     */
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        // schema name is not supported.
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        // procedure name is not supported.
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        // catalog name is not supported.
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        // user name is not supported.
        return 0;
    }

    /**
     * 
     * @see http://www.sqlite.org/pragma.html#pragma_read_uncommitted
     * @return  java.sql.Connection.TRANSACTION_SERIALIZABLE
     * @throws java.sql.SQLException
     */
    public int getDefaultTransactionIsolation() throws SQLException {
        return Connection.TRANSACTION_SERIALIZABLE;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    /**
     * 
     * @see http://www.sqlite.org/pragma.html#pragma_read_uncommitted
     * @param level
     * @return  true if level is java.sql.Connection.TRANSACTION_SERIALIZABLE.
     * @throws java.sql.SQLException
     */
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return (level == Connection.TRANSACTION_SERIALIZABLE);
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    /**
     * procedure is NOT suppoted yet.
     * @param catalog
     * @param schemaPattern
     * @param procedureNamePattern
     * @return
     * @throws java.sql.SQLException
     */
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        final String sql
                = "SELECT "
                    + "  NULL AS PROCEDURE_CAT"
                    + ", NULL AS PROCEDURE_SCHEM"
                    + ", NULL AS PROCEDURE_NAME"
                    + ", NULL AS RESERVED_4"
                    + ", NULL AS RESERVED_5"
                    + ", NULL AS RESERVED_6"
                    + ", NULL AS REMARKS"
                    + ", NULL AS SPECIFIC_NAME"
                + " LIMIT 0";
        return produceDetachedResultSet(sql);
    }

    /**
     * procedure is NOT suppoted.
     * @param catalog
     * @param schemaPattern
     * @param procedureNamePattern
     * @return
     * @throws java.sql.SQLException
     */
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        final String sql
                = "SELECT "
                    + "  NULL AS PROCEDURE_CAT"
                    + ", NULL AS PROCEDURE_SCHEM"
                    + ", NULL AS PROCEDURE_NAME"
                    + ", NULL AS COLUMN_NAME"
                    + ", NULL AS COLUMN_TYPE"
                    + ", NULL AS DATA_TYPE"
                    + ", NULL AS TYPE_NAME"
                    + ", NULL AS PRECISION"
                    + ", NULL AS LENGTH"
                    + ", NULL AS SCALE"
                    + ", NULL AS RADIX"
                    + ", NULL AS NULLABLE"
                    + ", NULL AS REMARKS"
                    + ", NULL AS COLUMN_DEF"
                    + ", NULL AS SQL_DATA_TYPE"
                    + ", NULL AS SQL_DATETIME_SUB"
                    + ", NULL AS CHAR_OCTET_LENGTH"
                    + ", NULL AS ORDINAL_POSITION"
                    + ", NULL AS IS_NULLABLE"
                    + ", NULL AS SPECIFIC_NAME"
                + " LIMIT 0";
        return produceDetachedResultSet(sql);
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        final String sqlTemplate
                = "SELECT"
                    + "  NULL AS TABLE_CAT"
                    + ", NULL AS TABLE_SCHEM"
                    + ", name AS TABLE_NAME"
                    + ", type AS TABLE_TYPE"
                    + ", NULL AS REMARKS"
                    + ", NULL AS TYPE_CAT"
                    + ", NULL AS TYPE_SCHEM"
                    + ", NULL AS TYPE_NAME"
                    + ", NULL AS SELF_REFERENCING_COL_NAME"
                    + ", NULL AS REF_GENERATION"
                    + ", sql AS SQL"
                + " FROM sqlite_master"
                + " WHERE (?1 IS NULL OR name LIKE ?1)"
                    + " AND (type IN ({0}))"
                + " ORDER BY TABLE_TYPE, TABLE_NAME";

        if (types == null || types.length == 0) {
            types = new String[] { "table", "view" };
        }
        final int typesSize = types.length;
        final StringBuilder paramTypes = new StringBuilder();
        for (int i = 0; i < typesSize; ++i) {
            paramTypes.append("?").append(i + 2).append(",");
        }
        final int last = paramTypes.length();
        paramTypes.delete(last - 1, last);
        
        final Object[] arguments = new Object[] { paramTypes.toString() };
        final String sql = new MessageFormat(sqlTemplate).format(arguments);
        PreparedStatement pstmt = conn.prepareStatement(sql);
        int parameterIndex = 1;
        pstmt.setString(parameterIndex++, tableNamePattern);
        for (final String type : types) {
            pstmt.setString(parameterIndex++, type);
        }
        ResultSet rs = pstmt.executeQuery();
        ((JdbcPreparedStatement) pstmt).detachAndClose(rs);
        return rs;
    }

    public ResultSet getSchemas() throws SQLException {
        final String sql
                = "SELECT NULL AS TABLE_SCHEM, NULL AS TABLE_CATALOG LIMIT 0";
        return produceDetachedResultSet(sql);
    }

    public ResultSet getCatalogs() throws SQLException {
        final String sql = "SELECT NULL AS TABLE_CAT LIMIT 0";
        return produceDetachedResultSet(sql);
    }

    public ResultSet getTableTypes() throws SQLException {
        final String sql
                = "SELECT 'TABLE' AS TABLE_TYPE "
                + "UNION ALL "
                + "SELECT 'VIEW' AS TABLE_TYPE";
        return produceDetachedResultSet(sql);
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        // TODO do implements! by sqlite3_table_column_metadata or PRAGMA table_info()
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        final String sql
                = "SELECT "
                    + "  NULL AS TABLE_CAT"
                    + ", NULL AS TABLE_SCHEM"
                    + ", NULL AS TABLE_NAME"
                    + ", NULL AS COLUMN_NAME"
                    + ", NULL AS GRANTOR"
                    + ", NULL AS GRANTEE"
                    + ", NULL AS PRIVILEGE"
                    + ", NULL AS IS_GRANTABLE"
                + " LIMIT 0";
        return produceDetachedResultSet(sql);
    }

    public ResultSet getTablePrivileges(String arg0, String arg1, String arg2) throws SQLException {
        final String sql
                = "SELECT "
                    + "  NULL AS TABLE_CAT"
                    + ", NULL AS TABLE_SCHEM"
                    + ", NULL AS TABLE_NAME"
                    + ", NULL AS GRANTOR"
                    + ", NULL AS GRANTEE"
                    + ", NULL AS PRIVILEGE"
                    + ", NULL AS IS_GRANTABLE"
                + " LIMIT 0";
        return produceDetachedResultSet(sql);
    }

    public ResultSet getBestRowIdentifier(String arg0, String arg1, String arg2, int arg3, boolean arg4) throws SQLException {
        // TODO do implements! by PRAGMA index_list() and table_info()
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        // TODO TRIGGER で更新される列情報を取得する！
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public ResultSet getPrimaryKeys(String arg0, String arg1, String arg2) throws SQLException {
        // TODO do implements! by sqlite3_table_column_metadata or PRAGMA table_info()
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public ResultSet getImportedKeys(String arg0, String arg1, String arg2) throws SQLException {
        // TODO do implements! by PRAGMA foreign_key_list()
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public ResultSet getExportedKeys(String arg0, String arg1, String arg2) throws SQLException {
        final String sql
                = "SELECT "
                    + "  NULL AS PKTABLE_CAT"
                    + ", NULL AS PKTABLE_SCHEM"
                    + ", NULL AS PKTABLE_NAME"
                    + ", NULL AS PKCOLUMN_NAME"
                    + ", NULL AS FKTABLE_CAT"
                    + ", NULL AS FKTABLE_SCHEM"
                    + ", NULL AS FKTABLE_NAME"
                    + ", NULL AS FKCOLUMN_NAME"
                    + ", NULL AS KEY_SEQ"
                    + ", NULL AS UPDATE_RULE"
                    + ", NULL AS DELETE_RULE"
                    + ", NULL AS FK_NAME"
                    + ", NULL AS PK_NAME"
                    + ", NULL AS DEFERRABILITY"
                + " LIMIT 0";
        return produceDetachedResultSet(sql);
    }

    public ResultSet getCrossReference(String arg0, String arg1, String arg2, String arg3, String arg4, String arg5) throws SQLException {
        // TODO do implements! by PRAGMA foreign_key_list()
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public ResultSet getTypeInfo() throws SQLException {
        // TODO NUMERIC型に関しても情報を返すべきか？
        final String sql
                = "SELECT "
                    + "  TYPE_NAME"
                    + ", DATA_TYPE"
                    + ", PRECISION"
                    + ", LITERAL_PREFIX"
                    + ", LITERAL_SUFFIX"
                    + ", NULL AS CREATE_PARAMS"
                    + ", " + typeNullable + " AS NULLABLE"
                    + ", CASE_SENSITIVE"
                    + ", " + typeSearchable + " AS SEARCHABLE"
                    + ", UNSIGNED_ATTRIBUTE"
                    + ", 0 AS FIXED_PREC_SCALE"
                    + ", AUTO_INCREMENT"
                    + ", TYPE_NAME AS LOCAL_TYPE_NAME"
                    + ", 0 AS MINIMUM_SCALE"
                    + ", 0 AS MAXIMUM_SCALE"
                    + ", NULL AS SQL_DATA_TYPE"
                    + ", NULL AS SQL_DATETIME_SUB"
                    + ", NUM_PREC_RADIX"
                + " FROM ("
                        + "SELECT"
                            + "  'NULL' AS TYPE_NAME"
                            + ", " + Types.NULL + " AS DATA_TYPE"
                            + ", NULL AS PRECISION"
                            + ", NULL AS LITERAL_PREFIX"
                            + ", NULL AS LITERAL_SUFFIX"
                            + ", 0 AS CASE_SENSITIVE"
                            + ", 0 AS UNSIGNED_ATTRIBUTE"
                            + ", 0 AS AUTO_INCREMENT"
                            + ", NULL AS NUM_PREC_RADIX"
                        + " UNION ALL "
                        + "SELECT"
                            + "  'INTEGER' AS TYPE_NAME"
                            + ", " + Types.INTEGER + " AS DATA_TYPE"
                            + ", 10 AS PRECISION"
                            + ", NULL AS LITERAL_PREFIX"
                            + ", NULL AS LITERAL_SUFFIX"
                            + ", 0 AS CASE_SENSITIVE"
                            + ", 1 AS UNSIGNED_ATTRIBUTE"
                            + ", 1 AS AUTO_INCREMENT"
                            + ", 10 AS NUM_PREC_RADIX"
                        + " UNION ALL "
                        + "SELECT"
                            + "  'REAL' AS TYPE_NAME"
                            + ", " + Types.REAL + " AS DATA_TYPE"
                            + ", 16 AS PRECISION"    // 倍精度
                            + ", NULL AS LITERAL_PREFIX"
                            + ", NULL AS LITERAL_SUFFIX"
                            + ", 0 AS CASE_SENSITIVE"
                            + ", 1 AS UNSIGNED_ATTRIBUTE"
                            + ", 0 AS AUTO_INCREMENT"
                            + ", 10 AS NUM_PREC_RADIX"
                        + " UNION ALL "
                        + "SELECT"
                            + "  'TEXT' AS TYPE_NAME"
                            + ", " + Types.VARCHAR + " AS DATA_TYPE"
                            + ", " + Integer.MAX_VALUE + " AS PRECISION"
                            + ", '''' AS LITERAL_PREFIX"
                            + ", '''' AS LITERAL_SUFFIX"
                            + ", 1 AS CASE_SENSITIVE"
                            + ", 0 AS UNSIGNED_ATTRIBUTE"
                            + ", 0 AS AUTO_INCREMENT"
                            + ", NULL AS NUM_PREC_RADIX"
                        + " UNION ALL "
                        + "SELECT"
                            + "  'BLOB' AS TYPE_NAME"
                            + ", " + Types.BLOB + " AS DATA_TYPE"
                            + ", " + Integer.MAX_VALUE + " AS PRECISION"
                            + ", 'X''' AS LITERAL_PREFIX"
                            + ", '''' AS LITERAL_SUFFIX"
                            + ", 0 AS CASE_SENSITIVE"
                            + ", 0 AS UNSIGNED_ATTRIBUTE"
                            + ", 0 AS AUTO_INCREMENT"
                            + ", NULL AS NUM_PREC_RADIX"
                    + ") AS TYPE_INFO"
                + " ORDER BY TYPE_NAME";
        return produceDetachedResultSet(sql);
    }

    public ResultSet getIndexInfo(String arg0, String arg1, String arg2, boolean arg3, boolean arg4) throws SQLException {
        // TODO do implements! PRAGMA index_list()
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    /**
     * Supported type is ResultSet.TYPE_FORWARD_ONLY only.
     * @param type
     * @return
     * @throws java.sql.SQLException
     */
    public boolean supportsResultSetType(int type) throws SQLException {
        return (type == ResultSet.TYPE_FORWARD_ONLY);
    }

    /**
     * Supported type is ResultSet.TYPE_FORWARD_ONLY and concurrency is ResultSet.CONCUR_READ_ONLY only.
     * @param type
     * @param concurrency
     * @return
     * @throws java.sql.SQLException
     */
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return (type == ResultSet.TYPE_FORWARD_ONLY
                && concurrency == ResultSet.CONCUR_READ_ONLY);
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int arg0) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int arg0) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int arg0) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    /**
     * UDT is not supported yet.
     * @param catalog
     * @param schemaPattern
     * @param typeNamePattern
     * @param types
     * @return
     * @throws java.sql.SQLException
     */
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        final String sql
                = "SELECT "
                    + "  NULL AS TYPE_CAT"
                    + ", NULL AS TYPE_SCHEM"
                    + ", NULL AS TYPE_NAME"
                    + ", NULL AS CLASS_NAME"
                    + ", NULL AS DATA_TYPE"
                    + ", NULL AS REMARKS"
                    + ", NULL AS BASE_TYPE"
                + " LIMIT 0";
        return produceDetachedResultSet(sql);
    }

    public Connection getConnection() throws SQLException {
        return conn;
    }

    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    /**
     * Supported by sqlite3_last_insert_rowid() function.
     * @see http://sqlite.org/c3ref/last_insert_rowid.html
     * @return
     * @throws java.sql.SQLException
     */
    public boolean supportsGetGeneratedKeys() throws SQLException {
        // case of SQLite 3.3.5 or later
        return true;
    }

    public ResultSet getSuperTypes(String arg0, String arg1, String arg2) throws SQLException {
        final String sql
                = "SELECT "
                    + "  NULL AS TYPE_CAT"
                    + ", NULL AS TYPE_SCHEM"
                    + ", NULL AS TYPE_NAME"
                    + ", NULL AS SUPERTYPE_CAT"
                    + ", NULL AS SUPERTYPE_SCHEM"
                    + ", NULL AS SUPERTYPE_NAME"
                + " LIMIT 0";
        return produceDetachedResultSet(sql);
    }

    public ResultSet getSuperTables(String arg0, String arg1, String arg2) throws SQLException {
        final String sql
                = "SELECT "
                    + "  NULL AS TABLE_CAT"
                    + ", NULL AS TABLE_SCHEM"
                    + ", NULL AS TABLE_NAME"
                    + ", NULL AS SUPERTABLE_NAME"
                + " LIMIT 0";
        return produceDetachedResultSet(sql);
    }

    public ResultSet getAttributes(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        final String sql
                = "SELECT "
                    + "  NULL AS TYPE_CAT"
                    + ", NULL AS TYPE_SCHEM"
                    + ", NULL AS ATTR_NAME"
                    + ", NULL AS DATA_TYPE"
                    + ", NULL AS ATTR_TYPE_NAME"
                    + ", NULL AS ATTR_SIZE"
                    + ", NULL AS DECIMAL_DIGITS"
                    + ", NULL AS NUM_PREC_RADIX"
                    + ", NULL AS NULLABLE"
                    + ", NULL AS REMARKS"
                    + ", NULL AS ATTR_DEF"
                    + ", NULL AS SQL_DATA_TYPE"
                    + ", NULL AS SQL_DATETIME_SUB"
                    + ", NULL AS CHAR_OCTET_LENGTH"
                    + ", NULL AS ORDINAL_POSITION"
                    + ", NULL AS IS_NULLABLE"
                    + ", NULL AS SCOPE_CATALOG"
                    + ", NULL AS SCOPE_SCHEMA"
                    + ", NULL AS SCOPE_TABLE"
                    + ", NULL AS SOURCE_DATA_TYPE"
                + " LIMIT 0";
        return produceDetachedResultSet(sql);
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    /**
     * 
     * @see org.sqlite.jdbc.Statement#getResultSetHoldability();
     * @return
     * @throws java.sql.SQLException
     */
    public int getResultSetHoldability() throws SQLException {
        return ResultSet.CLOSE_CURSORS_AT_COMMIT;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return (SQLite3Constants.SQLITE_VERSION_NUMBER / 1000000);
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return ((SQLite3Constants.SQLITE_VERSION_NUMBER % 1000000) / 1000);
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    /**
     * java.sql.SQLException#getSQLState() is NULL only.
     * @return
     * @throws java.sql.SQLException
     */
    public int getSQLStateType() throws SQLException {
        // TODO java.sql.SQLException#getSQLState() is NULL only.
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }
    // END implements

    private ResultSet produceDetachedResultSet(String sql) throws SQLException {
        final Statement stmt = conn.createStatement();
        final ResultSet rs = stmt.executeQuery(sql);
        ((JdbcStatement) stmt).detach(rs);
        stmt.close();
        return rs;
    }
}
