/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.sqlite.Statement;
import org.sqlite.TransactionType;
import org.sqlite.jdbc.JdbcSQLException;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SQLite3JNI;
import org.sqlite.swig.SWIGTYPE_p_p_sqlite3;
import org.sqlite.swig.SWIGTYPE_p_sqlite3;
import org.sqlite.types.SQLite3Handle;
import org.sqlite.types.SQLite3Ptr;
import org.sqlite.types.SQLite3StmtPtrPtr;

public class Database {
    private final String url;
    private final SQLite3Handle handle = new SQLite3Handle();
    private Map<Long, Statement> statements;
    private int timeout;

    public Database(String scheme, String filename) throws SQLException {
        this.open(filename);
        this.url = scheme + filename;
    }

    public String getURL() {
        return this.url;
    }

    private void open(String filename) throws SQLException {
        SWIGTYPE_p_p_sqlite3 ppDb = this.handle.getSQLite3PtrPtr();
        int ret = SQLite3.sqlite3_open(filename, ppDb);
        if (ret != 0) {
            SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
            JdbcSQLException ex = new JdbcSQLException(db);
            this.handle.delete();
            throw ex;
        }
    }

    public boolean isClosed() {
        return this.handle.isDeleted();
    }

    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.closeStatements();
            SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
            int ret = SQLite3.sqlite3_close(db);
            if (ret != 0) {
                throw new JdbcSQLException(db);
            }
            this.handle.delete();
        }
    }

    public boolean getAutoCommit() {
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        return SQLite3.sqlite3_get_autocommit(db) != 0;
    }

    public int setBusyTimeout(int ms) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        int ret = SQLite3.sqlite3_busy_timeout(db, ms);
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
        this.timeout = ms < 1 ? 0 : ms;
        return ret;
    }

    public int getBusyTimeout() {
        return this.timeout;
    }

    public int execute(String sql) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        long sqlite3 = SQLite3Ptr.addressOf(db);
        int ret = 0;
        if (this.timeout == 0) {
            while ((ret = SQLite3JNI.sqlite3_exec(sqlite3, sql, 0L, 0L, 0L)) == 5) {
            }
        } else {
            ret = SQLite3JNI.sqlite3_exec(sqlite3, sql, 0L, 0L, 0L);
            if (ret == 5) {
                throw new SQLException("Timeout expired.");
            }
        }
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
        return ret;
    }

    public void pragma(String[] commands) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        long sqlite3 = SQLite3Ptr.addressOf(db);
        for (String cmd : commands) {
            int ret = SQLite3JNI.sqlite3_exec(sqlite3, "PRAGMA " + cmd, 0L, 0L, 0L);
            if (ret == 0) continue;
            throw new JdbcSQLException(db);
        }
    }

    public void beginTransaction(TransactionType type) throws SQLException {
        this.closeStatements();
        this.execute("BEGIN " + (type != null ? type : ""));
    }

    public void commitTransaction() throws SQLException {
        this.closeStatements();
        this.execute("COMMIT");
    }

    public void rollbackTransaction() throws SQLException {
        this.closeStatements();
        this.execute("ROLLBACK");
    }

    public Statement prepare(String sql, SQLite3StmtPtrPtr ppStmt) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        int ret = SQLite3.sqlite3_prepare(db, sql, -1, ppStmt, null);
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
        return new Statement(this, ppStmt.getSQLite3StmtPtr());
    }

    public Statement prepare(String sql) throws SQLException {
        SQLite3StmtPtrPtr ppStmt;
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        int ret = SQLite3.sqlite3_prepare(db, sql, -1, ppStmt = new SQLite3StmtPtrPtr(), null);
        if (ret != 0) {
            ppStmt.delete();
            throw new JdbcSQLException(db);
        }
        return new Statement(this, ppStmt);
    }

    public void interrupt() {
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        SQLite3.sqlite3_interrupt(db);
    }

    public int changes() {
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        return SQLite3.sqlite3_changes(db);
    }

    public int totalChanges() {
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        return SQLite3.sqlite3_total_changes(db);
    }

    public void addStatement(Statement stmt) throws SQLException {
        long key;
        if (this.statements == null) {
            this.statements = new HashMap<Long, Statement>();
        }
        if (this.statements.containsKey(key = stmt.getHandle())) {
            throw new SQLException("Duplicate sqlite3_stmt handle error.");
        }
        this.statements.put(key, stmt);
    }

    public void removeStatement(Statement stmt) throws SQLException {
        long key = stmt.getHandle();
        if (this.statements == null || this.statements.remove(key) == null) {
            throw new SQLException("Unmanaged sqlite3_stmt handle error.");
        }
    }

    private void closeStatements() throws SQLException {
        if (this.statements != null) {
            for (Statement stmt : this.statements.values()) {
                stmt.closeForced();
            }
            this.statements = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

