/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import org.sqlite.jdbc.JdbcConnection;
import org.sqlite.jdbc.Scheme;

public class Driver
implements java.sql.Driver {
    public static String getDriverName() {
        return "SQLite JDBC Driver";
    }

    public static String getDriverVersion() {
        return Driver.getDriverMajorVersion() + "." + Driver.getDriverMinorVersion() + "." + Driver.getDriverReleaseVersion();
    }

    public static int getDriverMajorVersion() {
        return 0;
    }

    public static int getDriverMinorVersion() {
        return 0;
    }

    public static int getDriverReleaseVersion() {
        return 1;
    }

    public boolean acceptsURL(String url) {
        for (Scheme scheme : Scheme.values()) {
            if (!scheme.matches(url)) continue;
            return true;
        }
        return false;
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        for (Scheme scheme : Scheme.values()) {
            String filename = scheme.getFilename(url);
            if (filename == null) continue;
            String schm = scheme.toString();
            return new JdbcConnection(schm, filename);
        }
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public int getMajorVersion() {
        return Driver.getDriverMajorVersion();
    }

    public int getMinorVersion() {
        return Driver.getDriverMinorVersion();
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[]{new DriverPropertyInfo("encoding", "UTF-8"), new DriverPropertyInfo("lastUpdateCount", "true"), new DriverPropertyInfo("busyTimeout", "0"), new DriverPropertyInfo("cacheSize", "2000"), new DriverPropertyInfo("defaultCacheSize", "2000"), new DriverPropertyInfo("pageSize", "1024"), new DriverPropertyInfo("maxPageCount", "1073741823")};
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            System.loadLibrary("sqlite3jni");
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException ex) {
            Logger.getLogger(Driver.class.getName()).throwing(Driver.class.getName(), "<clinit>", ex);
            throw new Error(ex.fillInStackTrace());
        }
    }
}

