/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.SQLException;
import java.util.logging.Logger;
import org.sqlite.Database;
import org.sqlite.jdbc.JdbcSQLException;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_stmt;
import org.sqlite.swig.SWIGTYPE_p_void;
import org.sqlite.types.SQLite3StmtPtr;
import org.sqlite.types.SQLite3StmtPtrPtr;
import org.sqlite.types.SQLiteTransient;

public class Statement {
    private final Database db;
    private final SWIGTYPE_p_sqlite3_stmt stmt;
    private final SQLite3StmtPtrPtr ppStmt;
    private boolean isClosed;
    private static final SQLiteTransient SQLITE_TRANSIENT = new SQLiteTransient();

    Statement(Database db, SWIGTYPE_p_sqlite3_stmt stmt) throws SQLException {
        this(db, stmt, null);
    }

    Statement(Database db, SQLite3StmtPtrPtr ppStmt) throws SQLException {
        this(db, ppStmt.getSQLite3StmtPtr(), ppStmt);
    }

    private Statement(Database db, SWIGTYPE_p_sqlite3_stmt stmt, SQLite3StmtPtrPtr ppStmt) throws SQLException {
        this.db = db;
        this.stmt = stmt;
        this.ppStmt = ppStmt;
        db.addStatement(this);
    }

    public int getParameterCount() {
        return SQLite3.sqlite3_bind_parameter_count(this.stmt);
    }

    public int getParameterIndex(String parameterName) {
        return SQLite3.sqlite3_bind_parameter_index(this.stmt, parameterName);
    }

    public String getParameterName(int parameterIndex) {
        return SQLite3.sqlite3_bind_parameter_name(this.stmt, parameterIndex);
    }

    public int getColumnCount() {
        return SQLite3.sqlite3_column_count(this.stmt);
    }

    public int getDataCount() {
        return SQLite3.sqlite3_data_count(this.stmt);
    }

    public String getColumnLabel(int columnIndex) {
        return SQLite3.sqlite3_column_name(this.stmt, columnIndex - 1);
    }

    public String getColumnName(int columnIndex) {
        return SQLite3.sqlite3_column_origin_name(this.stmt, columnIndex - 1);
    }

    public int getColumnType(int columnIndex) {
        return SQLite3.sqlite3_column_type(this.stmt, columnIndex - 1);
    }

    public String getColumnTableName(int columnIndex) {
        return SQLite3.sqlite3_column_table_name(this.stmt, columnIndex - 1);
    }

    public String getColumnTypeName(int columnIndex) {
        return SQLite3.sqlite3_column_decltype(this.stmt, columnIndex - 1);
    }

    public String getString(int columnIndex) {
        return SQLite3.sqlite3_column_text(this.stmt, columnIndex - 1);
    }

    public int getInt(int columnIndex) {
        return SQLite3.sqlite3_column_int(this.stmt, columnIndex - 1);
    }

    public long getLong(int columnIndex) {
        return SQLite3.sqlite3_column_int64(this.stmt, columnIndex - 1);
    }

    public double getDouble(int columnIndex) {
        return SQLite3.sqlite3_column_double(this.stmt, columnIndex - 1);
    }

    public byte[] getBytes(int columnIndex) {
        return SQLite3.sqlite3_column_blob_by_bytes(this.stmt, columnIndex - 1);
    }

    public SWIGTYPE_p_void getBlob(int columnIndex) {
        return SQLite3.sqlite3_column_blob(this.stmt, columnIndex - 1);
    }

    public long getByteLength(int columnIndex) {
        return SQLite3.sqlite3_column_bytes(this.stmt, columnIndex - 1);
    }

    public void bindNull(int parameterIndex) throws SQLException {
        int ret = SQLite3.sqlite3_bind_null(this.stmt, parameterIndex);
        if (ret != 0) {
            throw new JdbcSQLException(SQLite3.sqlite3_db_handle(this.stmt));
        }
    }

    public void bindInt(int parameterIndex, int val) throws SQLException {
        int ret = SQLite3.sqlite3_bind_int(this.stmt, parameterIndex, val);
        if (ret != 0) {
            throw new JdbcSQLException(SQLite3.sqlite3_db_handle(this.stmt));
        }
    }

    public void bindLong(int parameterIndex, long val) throws SQLException {
        int ret = SQLite3.sqlite3_bind_int64(this.stmt, parameterIndex, val);
        if (ret != 0) {
            throw new JdbcSQLException(SQLite3.sqlite3_db_handle(this.stmt));
        }
    }

    public void bindDouble(int parameterIndex, double val) throws SQLException {
        int ret = SQLite3.sqlite3_bind_double(this.stmt, parameterIndex, val);
        if (ret != 0) {
            throw new JdbcSQLException(SQLite3.sqlite3_db_handle(this.stmt));
        }
    }

    public void bindText(int parameterIndex, String val) throws SQLException {
        int ret = SQLite3.sqlite3_bind_text(this.stmt, parameterIndex, val, -1, SQLITE_TRANSIENT);
        if (ret != 0) {
            throw new JdbcSQLException(SQLite3.sqlite3_db_handle(this.stmt));
        }
    }

    public void bindBytes(int parameterIndex, byte[] val) throws SQLException {
        this.bindBytes(parameterIndex, val, val.length);
    }

    public void bindBytes(int parameterIndex, byte[] val, int bytes) throws SQLException {
        int ret = SQLite3.sqlite3_bind_blob_by_bytes(this.stmt, parameterIndex, val, bytes);
        if (ret != 0) {
            throw new JdbcSQLException(SQLite3.sqlite3_db_handle(this.stmt));
        }
    }

    public void clearBinding() throws SQLException {
        int max = this.getParameterCount() + 1;
        for (int i = 1; i < max; ++i) {
            this.bindNull(i);
        }
    }

    public int reset() throws SQLException {
        int ret = SQLite3.sqlite3_reset(this.stmt);
        if (ret != 0) {
            throw new JdbcSQLException(SQLite3.sqlite3_db_handle(this.stmt));
        }
        return ret;
    }

    public int step() throws SQLException {
        int ret = 0;
        if (this.db.getBusyTimeout() == 0) {
            while ((ret = SQLite3.sqlite3_step(this.stmt)) == 5) {
            }
        } else {
            ret = SQLite3.sqlite3_step(this.stmt);
            if (ret == 5) {
                throw new SQLException("Timeout expired.");
            }
        }
        if (ret != 101 && ret != 100) {
            throw new JdbcSQLException(SQLite3.sqlite3_db_handle(this.stmt));
        }
        return ret;
    }

    public int execute() throws SQLException {
        int ret = this.step();
        if (ret != 101) {
            throw new JdbcSQLException(SQLite3.sqlite3_db_handle(this.stmt));
        }
        return ret;
    }

    public boolean isExpired() {
        return SQLite3.sqlite3_expired(this.stmt) != 0;
    }

    public boolean producedResultSet() {
        return this.getColumnCount() != 0;
    }

    long getHandle() {
        return SQLite3StmtPtr.addressOf(this.stmt);
    }

    public boolean isClosed() {
        return this.db.isClosed() || this.isClosed;
    }

    public void close() throws SQLException {
        this.close(false);
    }

    void closeForced() throws SQLException {
        this.close(true);
    }

    private void close(boolean isForced) throws SQLException {
        if (!this.isClosed) {
            int ret = SQLite3.sqlite3_finalize(this.stmt);
            if (ret == 4) {
                Logger.getLogger(Statement.class.getName()).warning("Transaction aborted.");
            } else if (ret != 0) {
                throw new JdbcSQLException(SQLite3.sqlite3_db_handle(this.stmt));
            }
            this.isClosed = true;
            if (!isForced) {
                this.db.removeStatement(this);
            }
            if (this.ppStmt != null) {
                this.ppStmt.delete();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

