/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.util.Map;
import org.sqlite.Database;
import org.sqlite.TransactionType;
import org.sqlite.jdbc.JdbcDatabaseMetaData;
import org.sqlite.jdbc.JdbcPreparedStatement;
import org.sqlite.jdbc.JdbcResultSet;
import org.sqlite.jdbc.JdbcStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcConnection
implements Connection {
    private Database db;
    private TransactionType type;

    public JdbcConnection(String scheme, String filename) throws SQLException {
        this.db = new Database(scheme, filename);
        this.db.pragma(new String[]{"encoding = \"UTF-8\"", "count_changes = off", "case_sensitive_like = on", "short_column_names = on", "empty_result_callbacks = off"});
    }

    @Override
    public JdbcStatement createStatement() throws SQLException {
        this.validateConnectionOpen();
        return new JdbcStatement(this.db, this);
    }

    @Override
    public JdbcPreparedStatement prepareStatement(String sql) throws SQLException {
        this.validateConnectionOpen();
        return new JdbcPreparedStatement(this.db, this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.validateConnectionOpen();
        if (!this.db.getAutoCommit()) {
            this.rollback();
        }
        if (!autoCommit && this.db.getAutoCommit()) {
            this.db.beginTransaction(this.type);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.validateConnectionOpen();
        return this.db.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.validateConnectionOpen();
        if (this.db.getAutoCommit()) {
            throw new SQLException("Connection is auto commit mode.");
        }
        this.db.commitTransaction();
    }

    @Override
    public void rollback() throws SQLException {
        this.validateConnectionOpen();
        if (this.db.getAutoCommit()) {
            throw new SQLException("Connection is auto commit mode.");
        }
        this.db.rollbackTransaction();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            if (!this.db.getAutoCommit()) {
                this.rollback();
            }
            this.db.close();
            this.db = null;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.db == null || this.db.isClosed();
    }

    @Override
    public JdbcDatabaseMetaData getMetaData() throws SQLException {
        return new JdbcDatabaseMetaData(this.db, this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.validateConnectionOpen();
        if (!this.db.getAutoCommit()) {
            throw new SQLException("Connection is transaction mode.");
        }
        if (readOnly) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.validateConnectionOpen();
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.validateConnectionOpen();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.validateConnectionOpen();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.validateConnectionOpen();
        if (level != 8) {
            throw new SQLException("Not supported isolation level.");
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.validateConnectionOpen();
        return 8;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.validateConnectionOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.validateConnectionOpen();
    }

    @Override
    public JdbcStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        JdbcResultSet.validateResultSetType(resultSetType);
        JdbcResultSet.validateResultSetConcurrency(resultSetConcurrency);
        this.validateConnectionOpen();
        return new JdbcStatement(this.db, this);
    }

    @Override
    public JdbcPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        JdbcResultSet.validateResultSetType(resultSetType);
        JdbcResultSet.validateResultSetConcurrency(resultSetConcurrency);
        this.validateConnectionOpen();
        return new JdbcPreparedStatement(this.db, this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.validateConnectionOpen();
        if (holdability != 1) {
            throw new SQLException("Not supported holdability.");
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.validateConnectionOpen();
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public JdbcStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JdbcResultSet.validateResultSetType(resultSetType);
        JdbcResultSet.validateResultSetConcurrency(resultSetConcurrency);
        JdbcResultSet.validateResultSetHoldability(resultSetHoldability);
        this.validateConnectionOpen();
        return new JdbcStatement(this.db, this);
    }

    @Override
    public JdbcPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JdbcResultSet.validateResultSetType(resultSetType);
        JdbcResultSet.validateResultSetConcurrency(resultSetConcurrency);
        JdbcResultSet.validateResultSetHoldability(resultSetHoldability);
        this.validateConnectionOpen();
        return new JdbcPreparedStatement(this.db, this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public JdbcPreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        JdbcStatement.validateAutoGeneretedKeys(autoGeneratedKeys);
        this.validateConnectionOpen();
        return new JdbcPreparedStatement(this.db, this, sql);
    }

    @Override
    public JdbcPreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public JdbcPreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void validateConnectionOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is already closed.");
        }
    }

    public void setTransactionType(TransactionType type) {
        this.type = type;
    }
}

