/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc;

import java.sql.Blob;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.sqlite.Statement;

public class JdbcResultSetMetaData
implements ResultSetMetaData {
    private final Statement stmt;

    public JdbcResultSetMetaData(Statement stmt) {
        this.stmt = stmt;
    }

    public int getColumnCount() throws SQLException {
        return this.stmt.getColumnCount();
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return false;
    }

    public boolean isSearchable(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return true;
    }

    public boolean isCurrency(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return false;
    }

    public int isNullable(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public boolean isSigned(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        switch (this.stmt.getColumnType(column)) {
            case 1: 
            case 2: {
                return true;
            }
            case 3: 
            case 4: 
            case 5: {
                return false;
            }
        }
        throw new SQLException("Not supported column type.");
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        switch (this.stmt.getColumnType(column)) {
            case 1: {
                return 11;
            }
            case 2: {
                return 23;
            }
            case 3: 
            case 4: {
                return Integer.MAX_VALUE;
            }
            case 5: {
                return 0;
            }
        }
        throw new SQLException("Not supported column type.");
    }

    public String getColumnLabel(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return this.stmt.getColumnLabel(column);
    }

    public String getColumnName(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return this.stmt.getColumnName(column);
    }

    public String getSchemaName(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return "";
    }

    public int getPrecision(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        switch (this.stmt.getColumnType(column)) {
            case 1: {
                return 10;
            }
            case 2: {
                return 16;
            }
            case 3: 
            case 4: 
            case 5: {
                return 0;
            }
        }
        throw new SQLException("Not supported column type.");
    }

    public int getScale(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        switch (this.stmt.getColumnType(column)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 0;
            }
        }
        throw new SQLException("Not supported column type.");
    }

    public String getTableName(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return this.stmt.getColumnTableName(column);
    }

    public String getCatalogName(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return "";
    }

    public int getColumnType(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        switch (this.stmt.getColumnType(column)) {
            case 1: {
                return 4;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 2004;
            }
            case 5: {
                return 0;
            }
        }
        throw new SQLException("Not supported column type.");
    }

    public String getColumnTypeName(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return this.stmt.getColumnTypeName(column);
    }

    public boolean isReadOnly(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return true;
    }

    public boolean isWritable(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return false;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return false;
    }

    public String getColumnClassName(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        switch (this.stmt.getColumnType(column)) {
            case 1: {
                return Integer.class.getName();
            }
            case 2: {
                return Double.class.getName();
            }
            case 3: {
                return String.class.getName();
            }
            case 4: {
                return Blob.class.getName();
            }
            case 5: {
                return Object.class.getName();
            }
        }
        throw new SQLException("Not supported column type.");
    }

    protected void validateColumnIndexRange(int columnIndex) throws SQLException {
        if (columnIndex > this.getColumnCount() || columnIndex < 1) {
            throw new SQLException("Column index out of range.");
        }
    }
}

