/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import org.sqlite.Database;
import org.sqlite.Statement;
import org.sqlite.jdbc.JdbcResultSet;

public class JdbcStatement
implements java.sql.Statement {
    protected Database db;
    private final Connection owner;
    protected ResultSet rs;
    protected int cntUpdate = -1;
    protected List<String> batch;

    public JdbcStatement(Database db, Connection owner) {
        this.db = db;
        this.owner = owner;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.validateStatementOpen();
        Statement stmt = this.db.prepare(sql);
        this.validateStaticSQL(stmt);
        if (!stmt.producedResultSet()) {
            stmt.close();
            throw new SQLException("No ResultSet was produced.");
        }
        this.rs = new JdbcResultSet(this, stmt);
        this.cntUpdate = -1;
        return this.rs;
    }

    public int executeUpdate(String sql) throws SQLException {
        this.validateStatementOpen();
        Statement stmt = this.db.prepare(sql);
        this.validateStaticSQL(stmt);
        if (stmt.producedResultSet()) {
            stmt.close();
            throw new SQLException("ResultSet was produced.");
        }
        stmt.step();
        this.cntUpdate = this.db.changes();
        this.rs = null;
        return this.cntUpdate;
    }

    public void close() throws SQLException {
        if (this.db != null) {
            this.db = null;
            if (this.rs != null) {
                this.rs.close();
                this.rs = null;
            }
            this.cntUpdate = -1;
            this.batch = null;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        this.validateStatementOpen();
        return 0;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getMaxRows() throws SQLException {
        this.validateStatementOpen();
        return 0;
    }

    public void setMaxRows(int max) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getQueryTimeout() throws SQLException {
        this.validateStatementOpen();
        return this.db.getBusyTimeout() / 1000;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.validateStatementOpen();
        this.db.setBusyTimeout(seconds * 1000);
    }

    public void cancel() throws SQLException {
        this.validateStatementOpen();
        this.db.interrupt();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.validateStatementOpen();
        return null;
    }

    public void clearWarnings() throws SQLException {
        this.validateStatementOpen();
    }

    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean execute(String sql) throws SQLException {
        this.validateStatementOpen();
        return this.executeQuery(sql) != null;
    }

    public ResultSet getResultSet() throws SQLException {
        this.validateStatementOpen();
        return this.rs;
    }

    public int getUpdateCount() throws SQLException {
        this.validateStatementOpen();
        return this.cntUpdate;
    }

    public boolean getMoreResults() throws SQLException {
        this.validateStatementOpen();
        if (this.rs != null) {
            this.rs.close();
            this.rs = null;
        }
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getFetchDirection() throws SQLException {
        this.validateStatementOpen();
        return 1002;
    }

    public void setFetchSize(int rows) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getFetchSize() throws SQLException {
        this.validateStatementOpen();
        return 0;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.validateStatementOpen();
        return 1007;
    }

    public int getResultSetType() throws SQLException {
        this.validateStatementOpen();
        return 1004;
    }

    public void addBatch(String sql) throws SQLException {
        this.validateStatementOpen();
        if (this.batch == null) {
            this.batch = new ArrayList<String>();
        }
        this.batch.add(sql);
    }

    public void clearBatch() throws SQLException {
        this.validateStatementOpen();
        this.batch = null;
    }

    public int[] executeBatch() throws SQLException {
        this.validateStatementOpen();
        if (this.batch == null) {
            return new int[0];
        }
        int[] ret = new int[this.batch.size()];
        BatchUpdateException ex = null;
        for (int i = 0; i < ret.length; ++i) {
            try {
                ret[i] = this.executeUpdate(this.batch.get(i));
                continue;
            }
            catch (SQLException ex2) {
                if (ex == null) {
                    ex = new BatchUpdateException(ex2.getMessage(), ex2.getSQLState(), ex2.getErrorCode(), ret);
                }
                ret[i] = -3;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return ret;
    }

    public Connection getConnection() throws SQLException {
        this.validateStatementOpen();
        return this.owner;
    }

    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        JdbcStatement.validateAutoGeneretedKeys(autoGeneratedKeys);
        this.validateStatementOpen();
        return this.executeUpdate(sql);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        JdbcStatement.validateAutoGeneretedKeys(autoGeneratedKeys);
        this.validateStatementOpen();
        return this.execute(sql);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getResultSetHoldability() throws SQLException {
        this.validateStatementOpen();
        return 2;
    }

    public boolean isClosed() throws SQLException {
        return this.db == null || this.db.isClosed();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected void validateStatementOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is already closed.");
        }
    }

    protected void validateStaticSQL(Statement stmt) throws SQLException {
        if (stmt.getParameterCount() != 0) {
            stmt.close();
            throw new SQLException("Not static SQL.");
        }
    }

    public static void validateAutoGeneretedKeys(int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 2) {
            throw new SQLException("Not supported auto generated keys.");
        }
    }

    public void detach(ResultSet drs) throws SQLException {
        this.validateStatementOpen();
        if (this.rs != null && this.rs == drs) {
            this.rs = null;
        }
    }
}

