/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.sqlite.Statement;

/**
 *
 * @author calico
 */
public class JdbcParameterMetaData implements ParameterMetaData {
    private final Statement stmt;
    
    public JdbcParameterMetaData(Statement stmt) {
        this.stmt = stmt;
    }
    
    // START implements
    public int getParameterCount() throws SQLException {
        return stmt.getParameterCount();
    }

    /**
     * CallableStatement is not supported yet.
     * It always returns parameterNullable.
     * @param param
     * @return java.sql.ParameterMetaData.parameterNullable
     * @throws java.sql.SQLException
     */
    public int isNullable(int param) throws SQLException {
        return parameterNullable;
    }

    // TODO do implements. If you're so inclined.

    /**
     * Not supporetd yet.
     * @throws java.sql.SQLException
     */
    public boolean isSigned(int param) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * Not supporetd yet.
     * @throws java.sql.SQLException
     */
    public int getPrecision(int param) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * Not supporetd yet.
     * @throws java.sql.SQLException
     */
    public int getScale(int param) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * Not supporetd yet.
     * @throws java.sql.SQLException
     */
    public int getParameterType(int param) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * Not supporetd yet.
     * @throws java.sql.SQLException
     */
    public String getParameterTypeName(int param) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * Not supporetd yet.
     * @throws java.sql.SQLException
     */
    public String getParameterClassName(int param) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * CallableStatement is not supported yet.
     * It always returns parameterModeIn.
     * @param param
     * @return java.sql.ParameterMetaData.parameterModeIn
     * @throws java.sql.SQLException
     */
    public int getParameterMode(int param) throws SQLException {
        return parameterModeIn;
    }
    // END implements
}
