/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.io;

import java.io.IOException;
import java.io.InputStream;
import org.sqlite.jdbc.JdbcBlob;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SWIGTYPE_p_void;

public class BlobInputStream
extends InputStream {
    private final JdbcBlob owner;
    private final SWIGTYPE_p_void blob;
    private final long last;
    private long pos;
    private long mark;
    private boolean isClosed = false;

    public BlobInputStream(JdbcBlob owner, SWIGTYPE_p_void blob, long len) {
        this.owner = owner;
        this.blob = blob;
        this.last = len - 1L;
    }

    public int available() throws IOException {
        this.validateStreamOpen();
        return this.pos > this.last ? 0 : (int)(this.last - this.pos);
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    public synchronized void mark(int readlimit) {
        this.mark = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        return this.read(b, 0, 1) != -1 ? b[0] : -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.validateStreamOpen();
        if (this.pos > this.last) {
            return -1;
        }
        if (this.pos + (long)len > this.last) {
            len = (int)((long)len - (this.pos + (long)len - (this.last + 1L)));
        }
        if (len == 0) {
            return 0;
        }
        SQLite3.read_blob(this.blob, this.pos, b, off, len);
        this.pos += (long)len;
        return this.pos > this.last ? -1 : len;
    }

    public synchronized void reset() throws IOException {
        this.validateStreamOpen();
        this.pos = this.mark;
    }

    public long skip(long n) throws IOException {
        this.validateStreamOpen();
        if (this.pos > this.last) {
            return 0L;
        }
        this.pos += n;
        return this.pos > this.last ? n - (this.pos - this.last) : n;
    }

    private void validateStreamOpen() throws IOException {
        if (this.isClosed || this.owner.isClosed()) {
            throw new IOException("Stream is already closed.");
        }
    }
}

