/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SWIGTYPE_p_Mem;
import org.sqlite.swig.SWIGTYPE_p_p_Mem;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_context;
import org.sqlite.swig.SWIGTYPE_p_void;
import static org.sqlite.swig.SQLite3.get_p_sqlite3_value;
import static org.sqlite.swig.SQLite3.sqlite3_result_blob;
import static org.sqlite.swig.SQLite3.sqlite3_result_double;
import static org.sqlite.swig.SQLite3.sqlite3_result_error;
import static org.sqlite.swig.SQLite3.sqlite3_result_int;
import static org.sqlite.swig.SQLite3.sqlite3_result_int64;
import static org.sqlite.swig.SQLite3.sqlite3_result_null;
import static org.sqlite.swig.SQLite3.sqlite3_result_text;
import static org.sqlite.swig.SQLite3.sqlite3_result_value;
import static org.sqlite.swig.SQLite3.sqlite3_value_blob;
import static org.sqlite.swig.SQLite3.sqlite3_value_blob_by_bytes;
import static org.sqlite.swig.SQLite3.sqlite3_value_bytes;
import static org.sqlite.swig.SQLite3.sqlite3_value_double;
import static org.sqlite.swig.SQLite3.sqlite3_value_int;
import static org.sqlite.swig.SQLite3.sqlite3_value_int64;
import static org.sqlite.swig.SQLite3.sqlite3_value_text;
import static org.sqlite.swig.SQLite3.sqlite3_value_type;
import static org.sqlite.swig.SQLite3.sqlite3_value_numeric_type;

/**
 * sqlite3_context and sqlite3_value wrapper class.<br/>
 * NOTE: SQLite 3.3.5 based.
 * @author calico
 */
public class Context {
    private static class SQLite3Context extends SWIGTYPE_p_sqlite3_context {
        private SQLite3Context(long p) {
            super(p, false);
        }
    }

    private static class SQLite3ValuePtrPtr extends SWIGTYPE_p_p_Mem {
        private SQLite3ValuePtrPtr(long p) {
            super(p, false);
        }
    }
    
    private final SWIGTYPE_p_sqlite3_context ctx;
    private final int argc;
    private final SWIGTYPE_p_p_Mem value;
    
    public Context(long ctx) {
        this(ctx, 0, 0);
    }
    
    public Context(long ctx, int argc, long value) {
        this(new SQLite3Context(ctx), argc, (value != 0 ? new SQLite3ValuePtrPtr(value) : null));
    }
    
    public Context(SWIGTYPE_p_sqlite3_context ctx, int argc, SWIGTYPE_p_p_Mem value) {
        this.ctx = ctx;
        this.argc = argc;
        this.value = value;
    }
    
    public int getArgumentCount() {
        return argc;
    }

    public boolean hasValues() {
        return (argc > 0 && value != null);
    }
    
    /**
     * invoke sqlite3_result_blob() function.
     * @param x
     * @param bytes
     * @see <a href="http://sqlite.org/c3ref/result_blob.html">Setting The Result Of An SQL Function</a>
     */
    public void result(SWIGTYPE_p_void x, int bytes) {
        sqlite3_result_blob(ctx, x, bytes);
    }

    /**
     * invoke sqlite3_result_blob() function.
     * @param x
     * @see <a href="http://sqlite.org/c3ref/result_blob.html">Setting The Result Of An SQL Function</a>
     */
    public void result(byte[] x) {
        result(x, x.length);
    }

    /**
     * invoke sqlite3_result_blob() function.
     * @param x
     * @param len
     * @see <a href="http://sqlite.org/c3ref/result_blob.html">Setting The Result Of An SQL Function</a>
     */
    public void result(byte[] x, int len) {
        sqlite3_result_blob(ctx, x, len);
    }
    
    /**
     * invoke sqlite3_result_double() function.
     * @param x
     * @see <a href="http://sqlite.org/c3ref/result_blob.html">Setting The Result Of An SQL Function</a>
     */
    public void result(double x) {
        sqlite3_result_double(ctx, x);
    }
    
    /**
     * invoke sqlite3_result_int() function.
     * @param x
     * @see <a href="http://sqlite.org/c3ref/result_blob.html">Setting The Result Of An SQL Function</a>
     */
    public void result(int x) {
        sqlite3_result_int(ctx, x);
    }
    
    /**
     * invoke sqlite3_result_int64() function.
     * @param x
     * @see <a href="http://sqlite.org/c3ref/result_blob.html">Setting The Result Of An SQL Function</a>
     */
    public void result(long x) {
        sqlite3_result_int64(ctx, x);
    }
    
    /**
     * invoke sqlite3_result_text() function.
     * @param x
     * @see <a href="http://sqlite.org/c3ref/result_blob.html">Setting The Result Of An SQL Function</a>
     */
    public void result(String x) {
        sqlite3_result_text(ctx, x);
    }
    
    /**
     * invoke sqlite3_result_value() function.
     * @param x
     * @see <a href="http://sqlite.org/c3ref/result_blob.html">Setting The Result Of An SQL Function</a>
     */
    public void result(SWIGTYPE_p_Mem x) {
        sqlite3_result_value(ctx, x);
    }
    
    /**
     * invoke sqlite3_result_text() function.
     * @param x
     * @see <a href="http://sqlite.org/c3ref/result_blob.html">Setting The Result Of An SQL Function</a>
     */
    public void result(Date x) {
        sqlite3_result_text(ctx, SQLite3.format(x));
    }
    
    /**
     * invoke sqlite3_result_text() function.
     * @param x
     * @see <a href="http://sqlite.org/c3ref/result_blob.html">Setting The Result Of An SQL Function</a>
     */
    public void result(Time x) {
        sqlite3_result_text(ctx, SQLite3.format(x));
    }
    
    /**
     * invoke sqlite3_result_text() function.
     * @param x
     * @see <a href="http://sqlite.org/c3ref/result_blob.html">Setting The Result Of An SQL Function</a>
     */
    public void result(Timestamp x) {
        sqlite3_result_text(ctx, SQLite3.format(x));
    }
    
    /**
     * invoke sqlite3_result_error() function.
     * @param x
     * @see <a href="http://sqlite.org/c3ref/result_blob.html">Setting The Result Of An SQL Function</a>
     */
    public void resultError(String x) {
        sqlite3_result_error(ctx, x);
    }
    
    /**
     * invoke sqlite3_result_null() function.
     * @see <a href="http://sqlite.org/c3ref/result_blob.html">Setting The Result Of An SQL Function</a>
     */
    public void resultNull() {
        sqlite3_result_null(ctx);
    }
    
    /**
     * invoke sqlite3_value_blob() function.
     * @param parameterIndex
     * @return
     * @throws java.sql.SQLException
     * @see <a href="http://sqlite.org/c3ref/value_blob.html">Obtaining SQL Function Parameter Values</a>
     */
    public SWIGTYPE_p_void getBlob(int parameterIndex) throws SQLException {
        return sqlite3_value_blob(getSQLite3ValuePtr(parameterIndex));
    }
    
    /**
     * invoke sqlite3_value_bytes() function.
     * @param parameterIndex
     * @return
     * @throws java.sql.SQLException
     * @see <a href="http://sqlite.org/c3ref/value_blob.html">Obtaining SQL Function Parameter Values</a>
     */
    public int getByteLength(int parameterIndex) throws SQLException {
        return sqlite3_value_bytes(getSQLite3ValuePtr(parameterIndex));
    }
    
    /**
     * invoke sqlite3_value_blob() function.
     * @param parameterIndex
     * @return
     * @throws java.sql.SQLException
     * @see <a href="http://sqlite.org/c3ref/value_blob.html">Obtaining SQL Function Parameter Values</a>
     */
    public byte[] getBytes(int parameterIndex) throws SQLException {
        return sqlite3_value_blob_by_bytes(getSQLite3ValuePtr(parameterIndex));
    }
    
    /**
     * invoke sqlite3_value_double() function.
     * @param parameterIndex
     * @return
     * @throws java.sql.SQLException
     * @see <a href="http://sqlite.org/c3ref/value_blob.html">Obtaining SQL Function Parameter Values</a>
     */
    public double getDouble(int parameterIndex) throws SQLException {
        return sqlite3_value_double(getSQLite3ValuePtr(parameterIndex));
    }
    
    /**
     * invoke sqlite3_value_int() function.
     * @param parameterIndex
     * @return
     * @throws java.sql.SQLException
     * @see <a href="http://sqlite.org/c3ref/value_blob.html">Obtaining SQL Function Parameter Values</a>
     */
    public int getInt(int parameterIndex) throws SQLException {
        return sqlite3_value_int(getSQLite3ValuePtr(parameterIndex));
    }
    
    /**
     * invoke sqlite3_value_int64() function.
     * @param parameterIndex
     * @return
     * @throws java.sql.SQLException
     * @see <a href="http://sqlite.org/c3ref/value_blob.html">Obtaining SQL Function Parameter Values</a>
     */
    public long getLong(int parameterIndex) throws SQLException {
        return sqlite3_value_int64(getSQLite3ValuePtr(parameterIndex));
    }
    
    /**
     * invoke sqlite3_value_text() function.
     * @param parameterIndex
     * @return
     * @throws java.sql.SQLException
     * @see <a href="http://sqlite.org/c3ref/value_blob.html">Obtaining SQL Function Parameter Values</a>
     */
    public String getString(int parameterIndex) throws SQLException {
        return sqlite3_value_text(getSQLite3ValuePtr(parameterIndex));
    }
    
    /**
     * invoke sqlite3_value_text() function.
     * @param parameterIndex
     * @return
     * @throws java.sql.SQLException
     * @see <a href="http://sqlite.org/c3ref/value_blob.html">Obtaining SQL Function Parameter Values</a>
     */
    public Date getDate(int parameterIndex) throws SQLException {
        final String val = sqlite3_value_text(getSQLite3ValuePtr(parameterIndex));
        Date ret = null;
        if (val != null) {
            ret = new Date(SQLite3.parseDate(val));
        }
        return ret;
    }
    
    /**
     * invoke sqlite3_value_text() function.
     * @param parameterIndex
     * @return
     * @throws java.sql.SQLException
     * @see <a href="http://sqlite.org/c3ref/value_blob.html">Obtaining SQL Function Parameter Values</a>
     */
    public Time getTime(int parameterIndex) throws SQLException {
        final String val = sqlite3_value_text(getSQLite3ValuePtr(parameterIndex));
        Time ret = null;
        if (val != null) {
            ret = new Time(SQLite3.parseTime(val));
        }
        return ret;
    }
    
    /**
     * invoke sqlite3_value_text() function.
     * @param parameterIndex
     * @return
     * @throws java.sql.SQLException
     * @see <a href="http://sqlite.org/c3ref/value_blob.html">Obtaining SQL Function Parameter Values</a>
     */
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        final String val = sqlite3_value_text(getSQLite3ValuePtr(parameterIndex));
        Timestamp ret = null;
        if (val != null) {
            ret = new Timestamp(SQLite3.parseTimestamp(val));
        }
        return ret;
    }
    
    /**
     * invoke sqlite3_value_type() function.
     * @param parameterIndex
     * @return
     * @throws java.sql.SQLException
     */
    public int getValueType(int parameterIndex) throws SQLException {
        return sqlite3_value_type(getSQLite3ValuePtr(parameterIndex));        
    }
    
    /**
     * invoke sqlite3_value_numeric_type() function.
     * @param parameterIndex
     * @return
     * @throws java.sql.SQLException
     */
    public int getValueNumericType(int parameterIndex) throws SQLException {
        return sqlite3_value_numeric_type(getSQLite3ValuePtr(parameterIndex));        
    }
    
    /**
     * 
     * @param parameterIndex
     * @throws java.sql.SQLException
     */
    protected void validateParamaeterIndexRange(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > argc) {
            throw new SQLException("Parameter index out of range.", "90J01");
        }
    }

    public SWIGTYPE_p_Mem getSQLite3ValuePtr(int parameterIndex) throws SQLException {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        validateParamaeterIndexRange(parameterIndex);
        return get_p_sqlite3_value(value, parameterIndex - 1);
    }
}
