/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.auth;

import org.sqlite.callback.Callback;

/**
 * Compile-Time Authorization class.
 * @author calico
 * @see <a href="http://sqlite.org/c3ref/set_authorizer.html">Compile-Time Authorization Callbacks</a>
 * @see org.sqlite.jdbc.JdbcConnection#setAuthorizer(Authorizer)
 * @see org.sqlite.jdbc.JdbcConnection#clearAuthorizer()
 */
public abstract class Authorizer extends Callback {

    /**
     * Called from the sqlite3_prepare()/sqlite3_prepare_v2() function.
     * @param action action code
     * @param str1
     * @param str2
     * @param database
     * @param triggerOrView
     * @return SQLITE_OK or SQLITE_DENY or SQLITE_IGNORE
     * @see <a href="http://sqlite.org/c3ref/set_authorizer.html">Compile-Time Authorization Callbacks</a>
     * @see <a href="http://sqlite.org/c3ref/c_alter_table.html">Authorizer Action Codes</a>
     * @see <a href="http://sqlite.org/c3ref/c_deny.html">Authorizer Return Codes</a>
     */
    protected abstract int xAuth(int action, String str1, String str2, String database, String triggerOrView);
}
