/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.callback;

/**
 * SQLite Named Callback function class.
 * @author calico
 * @see <a href="http://sqlite.org/c3ref/create_function.html">Create Or Redefine SQL Functions</a>
 * @see <a href="http://sqlite.org/c3ref/create_collation.html">Define New Collating Sequences</a>
 */
public abstract class NamedCallback extends Callback {
    private final String name;

    public NamedCallback(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
    }
    
    public String getName() {
        return name;
    }
}
