/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.text;

import java.util.Comparator;
import org.sqlite.callback.NamedCallback;

/**
 * User-Defined Collating Sequence class.
 * @author calico
 * @see <a href="http://sqlite.org/c3ref/create_collation.html">Define New Collating Sequences</a>
 * @see org.sqlite.jdbc.JdbcConnection#createCollation(Collator)
 * @see org.sqlite.jdbc.JdbcConnection#dropCollation(Collator)
 */
public abstract class Collator extends NamedCallback implements Comparator<String> {

    public Collator(String name) {
        super(name);
    }

    /**
     * Called from the sqlite3_step() function.
     * @param str1 the first string to be compared.
     * @param str2 the second string to be compared.
     * @return a negative integer, zero, or a positive integer as the first argument is less than, equal to, or greater than the second.
     * @see java.util.Comparator#compare(Object, Object)
     */
    protected final int xCompare(String str1, String str2) {
        // TODO Mysaifu JVMのBug#11980が解決したらアクセス修飾子をprivateに変更すること！
        // @see http://sourceforge.jp/tracker/index.php?func=detail&aid=11980&group_id=1890&atid=7027
        return compare(str1, str2);
    }
    
}
