/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.sqlite.Statement;
import org.sqlite.io.BlobInputStream;
import org.sqlite.swig.SWIGTYPE_p_void;

public class JdbcBlob
implements Blob {
    private final Statement stmt;
    private final SWIGTYPE_p_void blob;
    private final long length;
    private boolean isClosed = false;

    public JdbcBlob(Statement stmt, int columnIndex) throws SQLException {
        this.stmt = stmt;
        this.blob = stmt.getBlob(columnIndex);
        this.length = stmt.getByteLength(columnIndex);
    }

    public long length() throws SQLException {
        return this.length;
    }

    public byte[] getBytes(long pos, int len) throws SQLException {
        if (pos < 1L) {
            throw new SQLException("Should pos is greater than or equal to 1.", "90J08");
        }
        if (len < 0) {
            throw new SQLException("Should len is greater than or equal to 0.", "90J08");
        }
        if (len == 0) {
            return new byte[0];
        }
        if (pos + (long)len > this.length) {
            len = (int)((long)len - (pos + (long)len - this.length - 1L));
        }
        byte[] b = new byte[len];
        InputStream in = this.getBinaryStream();
        try {
            in.skip(pos - 1L);
            in.read(b, 0, len);
            return b;
        }
        catch (IOException ex) {
            Logger.getLogger(JdbcBlob.class.getName()).throwing(JdbcBlob.class.getName(), "getBytes(long, int)", ex);
            throw new SQLException(ex.getMessage());
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        return new BlobInputStream(this, this.blob, this.length);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        int ret = JdbcBlob.BM(pattern, this.getBytes(start, (int)this.length));
        return ret > 0 ? ret + 1 : -1;
    }

    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void close() {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed || this.stmt.isClosed();
    }

    private static int[] preBmBc(byte[] x) {
        int i;
        int ASIZE = 256;
        int[] bmBc = new int[256];
        int m = x.length;
        for (i = 0; i < 256; ++i) {
            bmBc[i] = m;
        }
        for (i = 0; i < m - 1; ++i) {
            bmBc[x[i] < 0 ? 127 - x[i] : x[i]] = m - i - 1;
        }
        return bmBc;
    }

    private static int[] suffixes(byte[] x) {
        int m = x.length;
        int[] suff = new int[m];
        suff[m - 1] = m;
        int g = m - 1;
        int f = 0;
        for (int i = m - 2; i >= 0; --i) {
            if (i > g && suff[i + m - 1 - f] < i - g) {
                suff[i] = suff[i + m - 1 - f];
                continue;
            }
            if (i < g) {
                g = i;
            }
            f = i;
            while (g >= 0 && x[g] == x[g + m - 1 - f]) {
                --g;
            }
            suff[i] = f - g;
        }
        return suff;
    }

    private static int[] preBmGs(byte[] x) {
        int i;
        int[] suff = JdbcBlob.suffixes(x);
        int m = x.length;
        int[] bmGs = new int[m];
        for (int i2 = 0; i2 < m; ++i2) {
            bmGs[i2] = m;
        }
        int j = 0;
        for (i = m - 1; i >= 0; --i) {
            if (suff[i] != i + 1) continue;
            while (j < m - 1 - i) {
                if (bmGs[j] == m) {
                    bmGs[j] = m - 1 - i;
                }
                ++j;
            }
        }
        for (i = 0; i <= m - 2; ++i) {
            bmGs[m - 1 - suff[i]] = m - 1 - i;
        }
        return bmGs;
    }

    private static int BM(byte[] x, byte[] y) {
        int b;
        int i;
        int[] bmGs = JdbcBlob.preBmGs(x);
        int[] bmBc = JdbcBlob.preBmBc(x);
        int m = x.length;
        int n = y.length;
        int end = n - m + 1;
        for (int j = 0; j < end; j += Math.max(bmGs[i], bmBc[b < 0 ? 127 - b : b] - m + 1 + i)) {
            i = 0;
            for (i = m - 1; i >= 0 && x[i] == y[i + j]; --i) {
            }
            if (i < 0) {
                return j;
            }
            b = y[i + j];
        }
        return -1;
    }
}

