/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.sqlite.Database;
import org.sqlite.Statement;
import org.sqlite.jdbc.JdbcResultSet;

public class JdbcStatement
implements java.sql.Statement {
    protected Database db;
    private final Connection owner;
    protected List<Object> results;
    protected int currentRet = -1;
    protected ResultSet rs;
    protected int cntUpdate = -1;
    private List<String> batch;

    public JdbcStatement(Database db, Connection owner) {
        this.db = db;
        this.owner = owner;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.validateStatementOpen();
        this.closeResultSets();
        if (!this.execute(this.db.prepare(sql))) {
            throw new SQLException("No ResultSet was produced.", "02000");
        }
        return this.rs;
    }

    public int executeUpdate(String sql) throws SQLException {
        this.validateStatementOpen();
        this.closeResultSets();
        if (this.execute(this.db.prepare(sql))) {
            throw new SQLException("ResultSet was produced.", "02001");
        }
        return this.cntUpdate;
    }

    public void close() throws SQLException {
        if (this.db != null) {
            this.db = null;
            if (this.rs != null) {
                this.rs.close();
                this.rs = null;
            }
            this.cntUpdate = -1;
            this.batch = null;
            this.closeResultSets();
        }
    }

    public int getMaxFieldSize() throws SQLException {
        this.validateStatementOpen();
        return 0;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getMaxRows() throws SQLException {
        this.validateStatementOpen();
        return 0;
    }

    public void setMaxRows(int max) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getQueryTimeout() throws SQLException {
        this.validateStatementOpen();
        return this.db.getBusyTimeout() / 1000;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.validateStatementOpen();
        this.db.setBusyTimeout(seconds * 1000);
    }

    public void cancel() throws SQLException {
        this.validateStatementOpen();
        this.db.interrupt();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.validateStatementOpen();
        return null;
    }

    public void clearWarnings() throws SQLException {
        this.validateStatementOpen();
    }

    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql) throws SQLException {
        this.validateStatementOpen();
        this.closeResultSets();
        List<Statement> list = this.db.prepareMultiple(sql);
        if (list.size() == 1) {
            return this.execute(list.get(0));
        }
        try {
            ArrayList<Object> tmp = new ArrayList<Object>(list.size());
            for (Statement stmt : list) {
                tmp.add(this.execute(stmt) ? this.rs : Integer.valueOf(this.cntUpdate));
            }
            list = null;
            this.currentRet = 0;
            this.results = tmp;
            Object result = this.results.get(0);
            if (result instanceof JdbcResultSet) {
                this.rs = (JdbcResultSet)result;
                this.cntUpdate = -1;
            } else {
                this.cntUpdate = (Integer)result;
                this.rs = null;
            }
        }
        finally {
            if (list != null) {
                for (Statement stmt : list) {
                    stmt.close();
                }
            }
        }
        return this.rs != null;
    }

    public ResultSet getResultSet() throws SQLException {
        this.validateStatementOpen();
        return this.rs;
    }

    public int getUpdateCount() throws SQLException {
        this.validateStatementOpen();
        return this.cntUpdate;
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    public void setFetchDirection(int direction) throws SQLException {
        JdbcResultSet.validateResultSetFetchDirection(direction);
        this.validateStatementOpen();
        if (direction != 1000) {
            throw new SQLException("Not supported fetch direction.", "90J23");
        }
    }

    public int getFetchDirection() throws SQLException {
        this.validateStatementOpen();
        return 1000;
    }

    public void setFetchSize(int rows) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getFetchSize() throws SQLException {
        this.validateStatementOpen();
        return 0;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.validateStatementOpen();
        return 1007;
    }

    public int getResultSetType() throws SQLException {
        this.validateStatementOpen();
        return 1004;
    }

    public void addBatch(String sql) throws SQLException {
        this.validateStatementOpen();
        if (this.batch == null) {
            this.batch = new ArrayList<String>();
        }
        this.batch.add(sql);
    }

    public void clearBatch() throws SQLException {
        this.validateStatementOpen();
        this.batch = null;
    }

    public int[] executeBatch() throws SQLException {
        this.validateStatementOpen();
        if (this.batch == null) {
            return new int[0];
        }
        int size = this.batch.size();
        int[] ret = new int[size];
        BatchUpdateException ex = null;
        for (int i = 0; i < size; ++i) {
            try {
                ret[i] = this.executeUpdate(this.batch.get(i));
                continue;
            }
            catch (SQLException ex2) {
                if (ex == null) {
                    ex = new BatchUpdateException(ex2.getMessage(), ex2.getSQLState(), ex2.getErrorCode(), ret);
                }
                ret[i] = -3;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return ret;
    }

    public Connection getConnection() throws SQLException {
        this.validateStatementOpen();
        return this.owner;
    }

    public boolean getMoreResults(int current) throws SQLException {
        JdbcStatement.validateCurrentResult(current);
        this.validateStatementOpen();
        if (current != 2) {
            if (this.results != null && this.currentRet != -1 && this.currentRet < this.results.size()) {
                int start;
                for (int i = start = current == 3 ? 0 : this.currentRet; i <= this.currentRet; ++i) {
                    Object result = this.results.get(i);
                    if (!(result instanceof JdbcResultSet)) continue;
                    ((JdbcResultSet)result).close();
                }
            }
            if (this.rs != null) {
                this.rs.close();
                this.rs = null;
            }
        }
        if (this.results != null && this.currentRet + 1 < this.results.size()) {
            Object result;
            if ((result = this.results.get(++this.currentRet)) instanceof JdbcResultSet) {
                this.rs = (JdbcResultSet)result;
                this.cntUpdate = -1;
            } else {
                this.cntUpdate = (Integer)result;
                this.rs = null;
            }
        } else {
            this.results = null;
            this.rs = null;
            this.cntUpdate = -1;
        }
        return this.rs != null;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.executeQuery("SELECT last_insert_rowid()");
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        JdbcStatement.validateAutoGeneretedKeys(autoGeneratedKeys);
        this.validateStatementOpen();
        return this.executeUpdate(sql);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        JdbcStatement.validateAutoGeneretedKeys(autoGeneratedKeys);
        this.validateStatementOpen();
        return this.execute(sql);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getResultSetHoldability() throws SQLException {
        this.validateStatementOpen();
        return 2;
    }

    public boolean isClosed() throws SQLException {
        return this.db == null || this.db.isClosed();
    }

    protected void finalize() throws Throwable {
        if (this.db != null) {
            Logger.getLogger(JdbcStatement.class.getName()).info("Statement is not closed.");
        }
        this.close();
        super.finalize();
    }

    protected void validateStatementOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is already closed.", "90007");
        }
    }

    protected void validateStaticSQL(Statement stmt) throws SQLException {
        if (stmt.getParameterCount() != 0) {
            stmt.close();
            throw new SQLException("Not static SQL.", "42000");
        }
    }

    public static void validateAutoGeneretedKeys(int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 2 && autoGeneratedKeys != 1) {
            throw new SQLException("Not supported auto generated keys.", "90J26");
        }
    }

    public static void validateCurrentResult(int current) throws SQLException {
        if (current != 1 && current != 2 && current != 3) {
            throw new SQLException("Not supported current result.", "90J26");
        }
    }

    public void detach(ResultSet drs) throws SQLException {
        this.validateStatementOpen();
        if (this.rs != null && this.rs == drs) {
            this.rs = null;
        }
        if (this.results != null) {
            int pos = this.results.indexOf(drs);
            if (pos != -1 && pos <= this.currentRet) {
                --this.currentRet;
            }
            this.results.remove(drs);
        }
    }

    public void close(ResultSet drs) throws SQLException {
        this.detach(drs);
        this.close();
    }

    public long getLastInsertRowId() throws SQLException {
        this.validateStatementOpen();
        return this.db.lastInsertRowId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean execute(Statement stmt) throws SQLException {
        try {
            this.rs = null;
            this.validateStaticSQL(stmt);
            if (stmt.producedResultSet()) {
                this.rs = new JdbcResultSet(this, stmt);
                this.cntUpdate = -1;
            } else {
                stmt.execute();
                this.cntUpdate = this.db.changes();
            }
            boolean bl = this.rs != null;
            return bl;
        }
        finally {
            if (this.rs == null) {
                stmt.close();
            }
        }
    }

    protected void closeResultSets() throws SQLException {
        if (this.results != null) {
            List<Object> list = this.results;
            this.results = null;
            this.currentRet = -1;
            for (Object result : list) {
                if (!(result instanceof JdbcResultSet)) continue;
                ((JdbcResultSet)result).close();
            }
        }
    }
}

