import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.sqlite.auth.Authorizer;
import org.sqlite.jdbc.JdbcConnection;
import static org.sqlite.swig.SQLite3Constants.*;

public class AuthorizerExample {

    @org.junit.Test(expected = java.sql.SQLException.class)
    public void example() throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.Driver");
        final String url = "jdbc:sqlite:mem:";
        final JdbcConnection conn = (JdbcConnection) DriverManager.getConnection(url);
        try {
            // new authorizer
            final Authorizer authDenyDropAction
                    = new Authorizer() {
                            @Override
                            protected int xAuth(int action, String str1, String str2, String database, String triggerOrView) {
                                switch (action) {
                                    case SQLITE_DROP_INDEX:
                                    case SQLITE_DROP_TABLE:
                                    case SQLITE_DROP_TEMP_INDEX:
                                    case SQLITE_DROP_TEMP_TABLE:
                                    case SQLITE_DROP_TEMP_TRIGGER:
                                    case SQLITE_DROP_TEMP_VIEW:
                                    case SQLITE_DROP_TRIGGER:
                                    case SQLITE_DROP_VIEW:
                                        return SQLITE_DENY;
                                }
                                return SQLITE_OK;
                            }
                        };

            // set authorizer
            conn.setAuthorizer(authDenyDropAction);

            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS temp_tbl_1("
                        + "  ID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", VALUE TEXT"
                    + ")";
            stmt.executeUpdate(sql);

            sql = "INSERT INTO temp_tbl_1 VALUES(1, 'One')";
            stmt.executeUpdate(sql);

            sql = "SELECT * FROM temp_tbl_1";
            for (final ResultSet rs = stmt.executeQuery(sql); rs.next(); ) {
                System.out.println(rs.getString(1));
            }
            
            sql = "DROP TABLE temp_tbl_1";
            stmt.executeUpdate(sql);
            
            stmt.close();

            // clear authorizer
            conn.clearAuthorizer();

        } finally {
            conn.close();
        }
    }

    public static void main(String[] args) throws Exception {
        new AuthorizerExample().example();
    }
}
