package org.sqlite.event;

import org.sqlite.callback.Callback;

/**
 * ROLLBACK TRANSACTION hook class.
 * @author calico
 * @see <a href="http://sqlite.org/c3ref/commit_hook.html">Commit And Rollback Notification Callbacks</a>
 * @see org.sqlite.jdbc.JdbcConnection#setRollbackHook(RollbackHook)
 * @see org.sqlite.jdbc.JdbcConnection#clearRollbackHook()
 */
public abstract class RollbackHook extends Callback {

    /**
     * invoked whenever a transaction is rollbacked.
     */
    protected abstract void xRollback();
}
