/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.jdbc;

import java.util.Properties;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sqlite.swig.SQLite3;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class SchemeTest {

    public SchemeTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void matches() {
        String url = null;

        url = "jdbc:sqlite:file:\\My Documents\\sqlite\\database;OPEN_MODE=READONLY";
        assertTrue(Scheme.JDBC_SQLITE_FILE.matches(url));
        assertFalse(Scheme.JDBC_SQLITE_MEMORY.matches(url));
        assertTrue(Scheme.JDBC_SQLITE.matches(url));

        url = "jdbc:sqlite:mem:";
        assertFalse(Scheme.JDBC_SQLITE_FILE.matches(url));
        assertTrue(Scheme.JDBC_SQLITE_MEMORY.matches(url));
        assertTrue(Scheme.JDBC_SQLITE.matches(url));

        url = "jdbc:sqlite:mem:\\My Documents\\sqlite\\database;OPEN_MODE=READONLY";
        assertFalse(Scheme.JDBC_SQLITE_FILE.matches(url));
        assertTrue(Scheme.JDBC_SQLITE_MEMORY.matches(url));
        assertTrue(Scheme.JDBC_SQLITE.matches(url));

    }
    
    private static final String FILENAME_KEY = ";filename;";
    
    @Test
    public void parse() {
        String url = null;
        Properties prop = null;
        
        url = "jdbc:sqlite:file:\\My Documents\\sqlite\\database;TEMP_DIR=C:\\temp;OPEN_MODE=READONLY";
        prop = Scheme.JDBC_SQLITE_FILE.parse(url);
        assertNotNull(prop);
        assertEquals("\\My Documents\\sqlite\\database", prop.getProperty(FILENAME_KEY));
        assertEquals("READONLY", prop.getProperty("OPEN_MODE"));
        assertEquals("C:\\temp", prop.getProperty("TEMP_DIR"));
        
        prop = Scheme.JDBC_SQLITE_MEMORY.parse(url);
        assertNull(prop);
        
        url = "jdbc:sqlite:mem:\\My Documents\\sqlite\\database;TEMP_DIR=C:\\temp;OPEN_READONLY";
        prop = Scheme.JDBC_SQLITE_MEMORY.parse(url);
        assertNotNull(prop);
        assertEquals(SQLite3.getInMemoryFileName(), prop.getProperty(FILENAME_KEY));
        assertNotNull(prop.getProperty("OPEN_READONLY"));
        assertEquals("C:\\temp", prop.getProperty("TEMP_DIR"));
        
        prop = Scheme.JDBC_SQLITE.parse(url);
        assertNotNull(prop);
        
    }
    
    @Test
    public void toStringTest() {
        assertEquals("jdbc:sqlite:file:", Scheme.JDBC_SQLITE_FILE.toString());
        assertEquals("jdbc:sqlite:mem:", Scheme.JDBC_SQLITE_MEMORY.toString());
        assertEquals("jdbc:sqlite:", Scheme.JDBC_SQLITE.toString());
    }
    
}