/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.auth;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sqlite.Database;
import org.sqlite.jdbc.JdbcConnection;
import org.sqlite.swig.SQLite3Constants;
import static org.sqlite.swig.SQLite3Constants.*;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class AuthorizerTest {

    public AuthorizerTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }


    private static final String DRIVER_CLASS = "org.sqlite.Driver";
    private static final String DATABASE = System.getProperty("user.dir") + "/test/unittest.db";

    private static Database newDatabase() throws ClassNotFoundException, SQLException {
        Class.forName(DRIVER_CLASS);
        return new Database(DATABASE, null);
    }
    
    private static Connection newConnection(Database db) throws ClassNotFoundException, SQLException {
        return new JdbcConnection(db, null);
    }

    @Test(expected = java.sql.SQLException.class)
    public void setAuthorizer() throws SQLException, ClassNotFoundException {
        final Database db = newDatabase();
        try {
            final Authorizer myAuth
                    = new Authorizer() {
                            @Override
                            protected int xAuth(int action, String str1, String str2, String database, String triggerOrView) {
                                System.out.printf("action = %d / str1 = %s / str2 = %s / database = %s / triggerOrView = %s\n", action, str1, str2, database, triggerOrView);
                                switch (action) {
                                    case SQLITE_DROP_TEMP_TABLE:
                                        return SQLITE_DENY;
                                }
                                return SQLITE_OK;
                            }
                        };
            assertFalse(myAuth.isRegistered());
            db.setAuthorizer(myAuth);
            assertTrue(myAuth.isRegistered());
            
            final Connection conn = newConnection(db);
            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS temp_tbl_1("
                        + "  ROWID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", ID INTEGER NOT NULL"
                        + ", tVALUE TEXT DEFAULT '_blank'"
                        + ", rVALUE REAL"
                        + ", bVALUE BLOB"
                        + ", nVALUE NULL"
                        + ", tVALUE2 text DEFAULT ''"
                        + ", tVALUE3 VarChar DEFAULT NULL"
                    + ")";
            stmt.executeUpdate(sql);

            sql = "SELECT * FROM temp_tbl_1";
            ResultSet rs = stmt.executeQuery(sql);
            assertFalse(rs.next());
            rs.close();
            
            db.clearAuthorizer();
            assertFalse(myAuth.isRegistered());
            
            db.setAuthorizer(myAuth);
            assertTrue(myAuth.isRegistered());
            
            sql = "DROP TABLE temp_tbl_1";
            stmt.executeUpdate(sql);
            
            stmt.close();
            conn.close();
        } catch (SQLException ex) {
            assertEquals(SQLite3Constants.SQLITE_AUTH, ex.getErrorCode());
            throw ex;
            
        } finally {
            db.close();
        }                
    }

    @Test
    public void clearAuthorizer() throws SQLException, ClassNotFoundException {
        final Database db = newDatabase();
        try {
            final Authorizer myAuth
                    = new Authorizer() {
                            @Override
                            protected int xAuth(int action, String str1, String str2, String database, String triggerOrView) {
                                System.out.printf("action = %d / str1 = %s / str2 = %s / database = %s / triggerOrView = %s\n", action, str1, str2, database, triggerOrView);
                                switch (action) {
                                    case SQLITE_DROP_TEMP_TABLE:
                                        return SQLITE_DENY;
                                }
                                return SQLITE_OK;
                            }
                        };
            assertFalse(myAuth.isRegistered());
            db.setAuthorizer(myAuth);
            assertTrue(myAuth.isRegistered());
            db.clearAuthorizer();
            assertFalse(myAuth.isRegistered());

        } finally {
            db.close();
        }                
    }
}