/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.event;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sqlite.Database;
import org.sqlite.jdbc.JdbcConnection;
import org.sqlite.swig.SQLite3Constants;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class BusyHandlerTest {

    public BusyHandlerTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }


    private static final String DRIVER_CLASS = "org.sqlite.Driver";
    private static final String DATABASE = System.getProperty("user.dir") + "/test/unittest.db";

    private static Database newDatabase() throws ClassNotFoundException, SQLException {
        Class.forName(DRIVER_CLASS);
        return new Database(DATABASE, null);
    }
    
    private static Connection newConnection(Database db) throws ClassNotFoundException, SQLException {
        return new JdbcConnection(db, null);
    }

    @Test(expected = java.sql.SQLException.class)
    public void setBusyHandler() throws ClassNotFoundException, SQLException, InterruptedException {
        final Database db = newDatabase();
        final BusyHandler busyHandler
                = new BusyHandler() {
                        @Override
                        protected int xBusy(int count) {
                            System.out.printf("Called xBusy(%d)\n", count);
                            return (count < 10 ? -1 : 0);
                        }
                    };
        assertFalse(busyHandler.isRegistered());
        try {
            db.setBusyHandler(busyHandler);
            assertTrue(busyHandler.isRegistered());
            
            final Connection conn = newConnection(db);
            final Statement stmt = conn.createStatement();
            try {
                String sql
                        = "CREATE TABLE IF NOT EXISTS tbl_busy_handler_test("
                            + "  ID INTEGER PRIMARY KEY AUTOINCREMENT"
                            + ", VALUE TEXT"
                        + ")";
                stmt.executeUpdate(sql);

                sql = "INSERT INTO tbl_busy_handler_test(VALUE) VALUES('insert by main thread')";
                for (int i = 0; i < 1000; ++i) {
                    System.out.printf("i = %d\n", i);
                    assertEquals(1, stmt.executeUpdate(sql));
                    Thread worker
                            = new Thread() {
                                @Override
                                public void run() {
                                    Connection conn2 = null;
                                    try {
                                        final Database db2 = newDatabase();                            
                                        conn2 = newConnection(db2);
                                        final Statement stmt2 = conn2.createStatement();
                                        final String sql = "SELECT * FROM tbl_busy_handler_test";
                                        final ResultSet rs = stmt2.executeQuery(sql);
                                        while (rs.next()) {
                                            System.out.printf("ID:[%d] VALUE:[%s]\n", rs.getInt(1), rs.getString(2));
                                        }
                                        rs.close();
                                        stmt2.close();

                                    } catch (Exception ex) {
                                        Logger.getLogger(BusyHandlerTest.class.getName()).severe(ex.toString());
                                    } finally {
                                        if (conn2 != null) {
                                            try {
                                                conn2.close();
                                            } catch (SQLException ex) {
                                                Logger.getLogger(BusyHandlerTest.class.getName()).log(Level.SEVERE, null, ex);
                                            }
                                        }
                                    }
                                }
                            };
                    worker.start();
                }
                stmt.close();
                conn.close();
            } catch (SQLException ex) {
                assertEquals(SQLite3Constants.SQLITE_BUSY, ex.getErrorCode());
                throw ex;
                
            } finally {
                newConnection(db).createStatement().executeQuery("DROP TABLE IF EXISTS tbl_busy_handler_test");
            }
        } finally {
            db.close();
            assertFalse(busyHandler.isRegistered());
        }
    }
}