package org.sqlite.event;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sqlite.Database;
import org.sqlite.jdbc.JdbcConnection;
import org.sqlite.text.Collator;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class CollationNeededHandlerTest {

    public CollationNeededHandlerTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private static final String DRIVER_CLASS = "org.sqlite.Driver";
    private static final String DATABASE = System.getProperty("user.dir") + "/test/unittest.db";

    private static Database newDatabase() throws ClassNotFoundException, SQLException {
        Class.forName(DRIVER_CLASS);
        return new Database(DATABASE, null);
    }
    
    private static Connection newConnection(Database db) throws ClassNotFoundException, SQLException {
        return new JdbcConnection(db, null);
    }
    
    @Test
    public void setCollationNeeded() throws ClassNotFoundException, SQLException {
        final Database db = newDatabase();
        final CollationNeededHandler handler = new CollationNeededHandler();
        assertFalse(handler.isRegistered());
        try {
            db.setCollationNeededHandler(handler);
            assertTrue(handler.isRegistered());

            final Collator myCol
                    = new Collator("myCol") {
                            public int compare(String arg0, String arg1) {
                                System.out.println("arg0 = [" + arg0 + "] / arg1 = [" + arg1 + "]");
                                if (arg0.length() < arg1.length()) {
                                    return -1;
                                } else if (arg0.length() > arg1.length()) {
                                    return 1;
                                }
                                return 0;
                            }
                        };
            assertFalse(myCol.isRegistered());
            handler.addCollator(myCol);
            
            final Connection conn = newConnection(db);
            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS tbl_collation_needed_test("
                        + "  ID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", VALUE TEXT COLLATE myCol"
                    + ")";
            stmt.executeUpdate(sql);
            assertTrue(myCol.isRegistered());

            stmt.close();
            conn.close();
            assertFalse(myCol.isRegistered());
            
        } finally {
            db.close();
            assertFalse(handler.isRegistered());
        }        
    }
}