/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.event;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sqlite.Database;
import org.sqlite.jdbc.JdbcConnection;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class UpdateHookTest {

    public UpdateHookTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private static final String DRIVER_CLASS = "org.sqlite.Driver";
    private static final String DATABASE = System.getProperty("user.dir") + "/test/unittest.db";

    private static Database newDatabase() throws ClassNotFoundException, SQLException {
        Class.forName(DRIVER_CLASS);
        return new Database(DATABASE, null);
    }
    
    private static Connection newConnection(Database db) throws ClassNotFoundException, SQLException {
        return new JdbcConnection(db, null);
    }
    
    @Test
    public void setUpdateHook() throws ClassNotFoundException, SQLException, IOException {
        final Database db = newDatabase();
        final UpdateHook hook
                = new UpdateHook() {
                        @Override
                        protected void xUpdate(int action, String dbName, String tableName, long rowId) {
                            System.out.printf("Called xUpdate(%d, '%s', '%s', %d)\n", action, dbName, tableName, rowId);
                        }
                    };
        assertFalse(hook.isRegistered());
        try {
            db.setUpdateHook(hook);
            assertTrue(hook.isRegistered());
            
            final Connection conn = newConnection(db);
            conn.setAutoCommit(false);
            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS tbl_update_hook_test("
                        + "  ID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", VALUE TEXT"
                    + ")";
            stmt.executeUpdate(sql);

            sql = "INSERT INTO tbl_update_hook_test(VALUE) VALUES('TEST')";
            assertEquals(1, stmt.executeUpdate(sql));
            stmt.close();
            
            conn.commit();
            conn.close();
            
        } finally {
            db.close();
            assertFalse(hook.isRegistered());
        }
    }
    
    @Test
    public void clearUpdateHook() throws ClassNotFoundException, SQLException, IOException {
        final Database db = newDatabase();
        final UpdateHook hook
                = new UpdateHook() {
                        @Override
                        protected void xUpdate(int action, String dbName, String tableName, long rowId) {
                            System.out.printf("Called xUpdate1(%d, '%s', '%s', %d)\n", action, dbName, tableName, rowId);
                        }
                    };
        assertFalse(hook.isRegistered());
        try {
            db.setUpdateHook(hook);
            assertTrue(hook.isRegistered());
            
            final Connection conn = newConnection(db);
            conn.setAutoCommit(false);
            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS tbl_update_hook_test("
                        + "  ID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", VALUE TEXT"
                    + ")";
            stmt.executeUpdate(sql);
            
            final UpdateHook hook2
                    = new UpdateHook() {
                            @Override
                            protected void xUpdate(int action, String dbName, String tableName, long rowId) {
                                System.out.printf("Called xUpdate2(%d, '%s', '%s', %d)\n", action, dbName, tableName, rowId);
                            }
                        };
            assertFalse(hook2.isRegistered());
            db.setUpdateHook(hook2);
            assertTrue(hook2.isRegistered());
            assertFalse(hook.isRegistered());

            sql = "INSERT INTO tbl_update_hook_test(VALUE) VALUES('TEST')";
            assertEquals(1, stmt.executeUpdate(sql));
            stmt.close();
            
            conn.commit();
            
            db.clearUpdateHook();
            assertFalse(hook2.isRegistered());
            
            conn.close();
            
        } finally {
            db.close();
            assertFalse(hook.isRegistered());
        }
    }

}