/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.awt;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.fop.messaging.MessageHandler;

public class AWTFontMetrics {
    public static final int FONT_SIZE = 1;
    public static final int FONT_FACTOR = 1000000;
    private int[] width = null;
    private int xHeight = 0;
    private Font f1 = null;
    private String family = "";
    private int style = 0;
    private float size = 0.0f;
    private FontMetrics fmt = null;
    Graphics2D graphics;
    private Map embedFontList = null;
    private Map fontCache = null;

    public AWTFontMetrics(Graphics2D graphics) {
        this.graphics = graphics;
    }

    public int getAscender(String family, int style, int size) {
        this.setFont(family, style, size);
        int realAscent = this.fmt.getAscent() - (this.fmt.getDescent() + this.fmt.getLeading());
        return 1000000 * realAscent;
    }

    public int getCapHeight(String family, int style, int size) {
        return this.getAscender(family, style, size);
    }

    public int getDescender(String family, int style, int size) {
        this.setFont(family, style, size);
        return -1000000 * this.fmt.getDescent();
    }

    public int getXHeight(String family, int style, int size) {
        this.setFont(family, style, size);
        return 1000000 * this.xHeight;
    }

    public int width(int i, String family, int style, int size) {
        this.setFont(family, style, size);
        char[] ac = new char[]{(char)i};
        double dWidth = this.fmt.getStringBounds(ac, 0, 1, (Graphics)this.graphics).getWidth() * 1000000.0;
        if (i <= 32) {
            dWidth *= 1.4;
        }
        return (int)dWidth;
    }

    public int[] getWidths(String family, int style, int size) {
        if (this.width == null) {
            this.width = new int[256];
        }
        this.setFont(family, style, size);
        int i = 0;
        while (i < 256) {
            this.width[i] = 1000000 * this.fmt.charWidth(i);
            ++i;
        }
        return this.width;
    }

    private boolean setFont(String family, int style, int size) {
        boolean changed = false;
        int s = (int)((float)size / 1000.0f);
        if (this.f1 == null) {
            this.f1 = this.createFont(family, style, s);
            this.fmt = this.graphics.getFontMetrics(this.f1);
            changed = true;
        } else if (this.style != style || !this.family.equals(family) || this.size != (float)s) {
            this.f1 = family.equals(this.family) ? this.f1.deriveFont(style, s) : this.createFont(family, style, s);
            this.fmt = this.graphics.getFontMetrics(this.f1);
            changed = true;
        }
        if (changed) {
            TextLayout layout = new TextLayout("m", this.f1, this.graphics.getFontRenderContext());
            Rectangle2D rect = layout.getBounds();
            this.xHeight = (int)rect.getHeight();
        }
        this.family = family;
        this.style = style;
        this.size = s;
        return changed;
    }

    public void setEmbedFont(String family, int style, URL fontURL) {
        if (this.embedFontList == null) {
            this.embedFontList = new HashMap();
        }
        this.embedFontList.put(String.valueOf(family) + style, fontURL);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Font createFont(String family, int style, int size) {
        block11: {
            fontURL = null;
            if (this.embedFontList != null) {
                fontURL = (URL)this.embedFontList.get(String.valueOf(family) + style);
            }
            if (fontURL == null) {
                return new Font(family, style, size);
            }
            if (this.fontCache == null) {
                this.fontCache = new HashMap<K, V>();
            }
            if ((cachedFont = (Font)this.fontCache.get(fontURL.toExternalForm())) != null) return cachedFont.deriveFont(style, size);
            fontStream = null;
            try {
                try {
                    MessageHandler.logln("Create embedded AWT font from stream " + fontURL.toExternalForm());
                    fontStream = fontURL.openStream();
                    cachedFont = Font.createFont(0, fontStream);
                }
                catch (Throwable th) {
                    MessageHandler.error("Failed to create embedded AWT font " + fontURL.toExternalForm() + ": " + th.toString());
                    cachedFont = new Font("Dialog", style, size);
                }
            }
            catch (Throwable var9_8) {
                var8_9 = null;
                if (fontStream == null) throw var9_8;
                try {
                    fontStream.close();
                    throw var9_8;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw var9_8;
            }
            {
                var8_10 = null;
                if (fontStream == null) break block11;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 213->221)] { 
lbl33:
            // 1 sources

            fontStream.close();
            break block11;
lbl35:
            // 1 sources

            catch (Exception ex) {
                // empty catch block
            }
        }
        this.fontCache.put(fontURL.toExternalForm(), cachedFont);
        return cachedFont.deriveFont(style, size);
    }

    public Font getFont(String family, int style, int size) {
        this.setFont(family, style, size);
        return this.f1;
    }
}

