/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.modules;

import java.util.LinkedList;
import javax.swing.Box;
import net.sf.sqs_xml.editor.base.modules.AbstractNodeEditor;
import net.sf.sqs_xml.editor.base.modules.resource.EditorResource;
import net.sf.sqs_xml.editor.base.source.DOMTreeSource;
import net.sf.sqs_xml.editor.base.swing.ModuleManager;
import net.sf.sqs_xml.editor.base.swing.SourceEditorMediator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContainerEditor
extends AbstractNodeEditor {
    LinkedList nodeEditors;

    public ContainerEditor(SourceEditorMediator mediator, DOMTreeSource source, Node node, EditorResource resource) {
        super(mediator, source, node, resource);
        NodeList list = node.getChildNodes();
        this.nodeEditors = new LinkedList();
        Box comp = Box.createVerticalBox();
        int i = 0;
        while (i < list.getLength()) {
            ModuleManager factory;
            EditorResource subResource;
            Node item = list.item(i);
            if (this.isEditable(item) && (subResource = (factory = mediator.getCurrentTreePane().getEditorResourceFactory()).getEditorResource(item)) != null) {
                try {
                    AbstractNodeEditor subcomp = factory.create(mediator, source, item);
                    this.nodeEditors.add(subcomp);
                    comp.add(subcomp);
                    this.addPreferredHeight(subcomp.getPreferredHeight());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        this.initSize();
        this.add(comp);
    }

    public int getHeight() {
        return this.prefHeight;
    }

    public boolean updateNodeValue() {
        boolean isUpdated = false;
        int i = 0;
        while (i < this.nodeEditors.size()) {
            if (this.isEditable(this.node.getChildNodes().item(i)) && ((AbstractNodeEditor)this.nodeEditors.get(i)).updateNodeValue()) {
                isUpdated = true;
            }
            ++i;
        }
        if (isUpdated) {
            super.updateNodeValue();
            return true;
        }
        return false;
    }

    public boolean isEditable(Node item) {
        return item.getNodeType() != 3;
    }
}

