/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.sqs.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.sqs_xml.editor.base.source.DOMTreeSource;
import net.sf.sqs_xml.editor.base.source.SourceManager;
import net.sf.sqs_xml.editor.base.swing.NodeTreePane;
import net.sf.sqs_xml.editor.base.swing.SourceEditorMediator;
import net.sf.sqs_xml.editor.base.swing.SourceEditorMenuBarMediator;
import net.sf.sqs_xml.editor.base.swing.SourceEditorSplitPane;
import net.sf.sqs_xml.editor.base.swing.SourceEditorTabbedPane;
import net.sf.sqs_xml.editor.base.swing.SourceEditorToolBar;
import net.sf.sqs_xml.editor.sqs.source.SQSSourceManager;
import net.sf.sqs_xml.editor.sqs.swing.SQSNodeTreePane;
import net.sf.sqs_xml.editor.sqs.swing.SQSSourceEditorMenuBarMediator;
import net.sf.sqs_xml.editor.sqs.swing.SQSSourceEditorToolBar;
import net.sf.sqs_xml.httpd.SourceEditorHttpd;
import net.sf.sqs_xml.swing.IconFactory;

public class SQSSourceEditorMediator
extends SourceEditorMediator {
    public static final String TITLE = "SQS Source Editor(2004/10/28)";
    public static final String BASEURI = SourceEditorHttpd.getSingleton().getBase();
    JPanel backgroundPanel = null;

    static {
        IconFactory.setBaseURI(SourceEditorHttpd.getSingleton().getBase());
    }

    public String getTitle() {
        return TITLE;
    }

    public JPanel getBackgroundPanel() {
        if (this.backgroundPanel == null) {
            this.backgroundPanel = new JPanel();
            this.backgroundPanel.setLayout(new BorderLayout());
            JLabel titleLabel = new JLabel("Shared Questionnaire System");
            titleLabel.setEnabled(false);
            Box titlePanel = Box.createHorizontalBox();
            titlePanel.add(titleLabel);
            titlePanel.add(new JLabel(IconFactory.create("wizard.gif")));
            this.backgroundPanel.add((Component)titlePanel, "East");
        }
        return this.backgroundPanel;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            new SQSSourceEditorMediator();
        } else if (args.length == 1) {
            URL url = null;
            try {
                url = new URL(args[0]);
                new SQSSourceEditorMediator(url);
            }
            catch (MalformedURLException ignore) {
                new SQSSourceEditorMediator(new File(args[0]));
            }
        }
    }

    public SQSSourceEditorMediator(URL url) throws Exception {
        super(url);
    }

    public SQSSourceEditorMediator(File file) throws Exception {
        super(file);
    }

    public SQSSourceEditorMediator() throws Exception {
    }

    public SourceManager createSourceManager() {
        return new SQSSourceManager();
    }

    public SourceEditorMenuBarMediator createSourceEditorMenuBarMediator() {
        return new SQSSourceEditorMenuBarMediator(this);
    }

    public SourceEditorToolBar createSourceEditorToolBar() {
        return new SQSSourceEditorToolBar(this);
    }

    public SourceEditorTabbedPane createSourceEditorTabbedPane(SourceEditorMediator mediator) {
        return new SourceEditorTabbedPane(mediator){

            public SourceEditorSplitPane createSourceEditorSplitPane(SourceEditorMediator mediator, DOMTreeSource source, int width) {
                return new SourceEditorSplitPane(this, mediator, source, width){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public NodeTreePane createSourceEditorTree(SourceEditorMediator mediator) {
                        return new SQSNodeTreePane(mediator, this.getSource(), this.getEditorPane());
                    }
                };
            }

            public Icon createTabIcon(DOMTreeSource source) {
                return IconFactory.create("sqs-tiny.gif", "SQS Source");
            }
        };
    }
}

