/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.logic;

import java.io.File;
import java.sql.Timestamp;
import java.util.List;
import net.sf.sqs_xml.reader.logic.BaseTaskSource;
import net.sf.sqs_xml.reader.logic.BaseTaskTarget;
import net.sf.sqs_xml.reader.logic.ReaderBaseTask;
import net.sf.sqs_xml.reader.logic.ReadingProcessView;
import net.sf.sqs_xml.reader.logic.Task;
import net.sf.sqs_xml.reader.logic.TaskSource;
import net.sf.sqs_xml.reader.logic.TaskTarget;
import net.sf.sqs_xml.reader.logic.ThreadSuspendingException;
import net.sf.sqs_xml.reader.model.ImageFiles;
import net.sf.sqs_xml.reader.model.ImageFilesImagefile;
import net.sf.sqs_xml.translator.logic.TranslatorException;

public abstract class FilteredReaderBaseTask
extends ReaderBaseTask {
    CheckImageFilesTaskTarget checkImageFilesTaskTarget = new CheckImageFilesTaskTarget();

    public FilteredReaderBaseTask(BaseTaskSource source, BaseTaskTarget target, ReadingProcessView view) {
        super(source, target, view);
    }

    public void checkImageFiles() throws ThreadSuspendingException, TranslatorException {
        new CheckImageFilesTask(new CheckImageFilesTaskSource(this.findImageFilesTaskTarget.fileList), this.checkImageFilesTaskTarget, this.view).run();
    }

    class CheckImageFilesTask
    extends Task {
        CheckImageFilesTask(CheckImageFilesTaskSource source, CheckImageFilesTaskTarget target, ReadingProcessView view) {
            super(source, target, view);
        }

        CheckImageFilesTaskSource getSource() {
            return (CheckImageFilesTaskSource)this.source;
        }

        CheckImageFilesTaskTarget getTarget() {
            return (CheckImageFilesTaskTarget)this.target;
        }

        void run() throws ThreadSuspendingException, TranslatorException {
            this.getTarget().setImageFiles(new ImageFiles());
            this.view.setProgressState(3, 1);
            int size = this.getSource().fileList.size();
            int i = 0;
            while (i < size) {
                FilteredReaderBaseTask.this.checkTaskStopRequest();
                this.view.setNumTargetFiles(i);
                this.view.setProgressState(3, i + 1, size);
                this.checkImageFile(i);
                ++i;
            }
            this.view.setNumTargetFiles(size);
            this.view.setProgressState(3, 2);
        }

        private void checkImageFile(int i) {
            File imageFile = (File)this.getSource().fileList.get(i);
            Timestamp targetMTime = new Timestamp(imageFile.lastModified());
            ImageFilesImagefile target = new ImageFilesImagefile();
            target.setFilename(imageFile.getAbsolutePath());
            target.setMtime(targetMTime);
            this.getTarget().getImageFiles().addImageFilesImagefile(target);
        }
    }

    class CheckImageFilesTaskSource
    extends TaskSource {
        List fileList;

        CheckImageFilesTaskSource(List fileList) {
            this.fileList = fileList;
        }
    }

    class CheckImageFilesTaskTarget
    extends TaskTarget {
        ImageFiles imageFiles;

        CheckImageFilesTaskTarget() {
        }

        ImageFiles getImageFiles() {
            return this.imageFiles;
        }

        void setImageFiles(ImageFiles imageFiles) {
            this.imageFiles = imageFiles;
        }
    }
}

