/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.logic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerException;
import net.sf.sqs_xml.image.RasterFactory;
import net.sf.sqs_xml.image.RasterSource;
import net.sf.sqs_xml.reader.logic.BaseTaskSource;
import net.sf.sqs_xml.reader.logic.BaseTaskTarget;
import net.sf.sqs_xml.reader.logic.CellValue;
import net.sf.sqs_xml.reader.logic.CellValueOption;
import net.sf.sqs_xml.reader.logic.FileFunctions;
import net.sf.sqs_xml.reader.logic.FilteredReaderBaseTask;
import net.sf.sqs_xml.reader.logic.MatrixBuilder;
import net.sf.sqs_xml.reader.logic.ProcessingInfoMapper;
import net.sf.sqs_xml.reader.logic.QuestionnaireSchema;
import net.sf.sqs_xml.reader.logic.ReaderImageProcessor;
import net.sf.sqs_xml.reader.logic.ReaderSource;
import net.sf.sqs_xml.reader.logic.ReaderSourceException;
import net.sf.sqs_xml.reader.logic.ReaderSourceTranslated;
import net.sf.sqs_xml.reader.logic.ReadingProcessView;
import net.sf.sqs_xml.reader.logic.Task;
import net.sf.sqs_xml.reader.logic.TaskSource;
import net.sf.sqs_xml.reader.logic.TaskTarget;
import net.sf.sqs_xml.reader.logic.ThreadSuspendingException;
import net.sf.sqs_xml.reader.model.FormElementsMarkarea;
import net.sf.sqs_xml.reader.model.FormElementsTextarea;
import net.sf.sqs_xml.reader.model.IFormElementsChoice;
import net.sf.sqs_xml.reader.model.ImageFiles;
import net.sf.sqs_xml.reader.model.ImageFilesImagefile;
import net.sf.sqs_xml.reader.model.Page;
import net.sf.sqs_xml.reader.model.ScanFrame;
import net.sf.sqs_xml.reader.model.TextareaImage;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.util.FileUtil;
import net.sf.sqs_xml.util.StringUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class ReaderCoreTask
extends FilteredReaderBaseTask {
    public static double MARK_RECOGNIZE_DENSITY = 0.25;
    public static double DOUBLE_MARK_RECOGNIZE_DENSITY = 0.15;
    public static boolean GUIDE_SQUARE_SHAPE_CHECKER_ENABLED = false;
    static final String FORMVALUE_NON_SELECTED = "";
    static final String FORMVALUE_SELECTED = "1";
    static final String FORMTYPE_SELECT = "select";
    static final String FORMTYPE_SELECT1 = "select1";
    static final String FORMTYPE_INPUT = "input";
    static final String FORMTYPE_TEXTAREA = "textarea";
    public static int BLACK_THRESHOLD = 190;
    ProcessScanFramesTaskTarget processScanFramesTaskTarget = new ProcessScanFramesTaskTarget();
    ProcessAreaTaskTarget processAreaTaskTarget = new ProcessAreaTaskTarget();
    ProcessValuesTaskTarget processValuesTaskTarget = new ProcessValuesTaskTarget();
    ProcessErrorImagesTaskTarget processErrorImagesTaskTarget = new ProcessErrorImagesTaskTarget();

    public ReaderCoreTask(BaseTaskSource source, BaseTaskTarget target, ReadingProcessView view) {
        super(source, target, view);
    }

    public void processErrorImages() throws ThreadSuspendingException {
        new ProcessErrorImagesTask(new ProcessErrorImagesTaskSource(this.getSource().srcdir, this.initQuestionnaireStructureTaskTarget.qSchema, this.checkImageFilesTaskTarget.imageFiles, this.processScanFramesTaskTarget.mapper, this.initQuestionnaireStructureTaskTarget.matrixBuilder), this.processErrorImagesTaskTarget, this.view).run();
    }

    private void processValues() throws ThreadSuspendingException, TransformerException {
        new ProcessValuesTask(new ProcessValuesTaskSource(this.checkImageFilesTaskTarget.imageFiles.getImageFilesImagefile().length, this.processScanFramesTaskTarget.mapper, this.initQuestionnaireStructureTaskTarget.qSchema, this.checkImageFilesTaskTarget.imageFiles, this.initQuestionnaireStructureTaskTarget.matrixBuilder), this.processValuesTaskTarget, this.view).run();
    }

    private void processArea() throws ThreadSuspendingException {
        new ProcessAreaTask(new ProcessAreaTaskSource(this.getSource().srcdir, this.initQuestionnaireStructureTaskTarget.qSchema, this.checkImageFilesTaskTarget.imageFiles, this.processScanFramesTaskTarget.mapper, this.initQuestionnaireStructureTaskTarget.qSchema.getMasterPoints(), this.initQuestionnaireStructureTaskTarget.matrixBuilder), this.processAreaTaskTarget, this.view).run();
    }

    private void processScanFrames() throws ThreadSuspendingException, TranslatorException {
        new ProcessScanFramesTask(new ProcessScanFramesTaskSource(this.getSource().srcdir, this.initQuestionnaireStructureTaskTarget.qSchema.getMasterPoints(), this.checkImageFilesTaskTarget.imageFiles), this.processScanFramesTaskTarget, this.view).run();
    }

    public void showResult() {
        int numFiles = this.checkImageFilesTaskTarget.imageFiles.getImageFilesImagefile().length;
        int numValidFiles = this.processScanFramesTaskTarget.mapper.getValidFileIndexSize();
        int numPages = this.initQuestionnaireStructureTaskTarget.qSchema.getNumberOfPages();
        int numSamples = numValidFiles / numPages;
        int errors = this.processScanFramesTaskTarget.mapper.getNumErrorPages();
        int warns = this.processScanFramesTaskTarget.mapper.getNumErrorMarkSets();
        this.view.showResult(errors, warns, numFiles, numValidFiles, numPages, numSamples);
    }

    public void processCoreTasks() throws ThreadSuspendingException, TranslatorException, TransformerException {
        this.processScanFrames();
        this.processArea();
        this.processValues();
    }

    class ProcessScanFramesTask
    extends Task {
        ProcessScanFramesTask(ProcessScanFramesTaskSource source, ProcessScanFramesTaskTarget target, ReadingProcessView view) {
            super(source, target, view);
        }

        ProcessScanFramesTaskSource getSource() {
            return (ProcessScanFramesTaskSource)this.source;
        }

        ProcessScanFramesTaskTarget getTarget() {
            return (ProcessScanFramesTaskTarget)this.target;
        }

        void run() throws ThreadSuspendingException, TranslatorException {
            this.view.setProgressState(4, 1);
            int errors = 0;
            int numImageFiles = this.getSource().imageFiles.sizeImageFilesImagefile();
            int i = 0;
            while (i < numImageFiles) {
                block6: {
                    ImageFilesImagefile target = this.getSource().imageFiles.getImageFilesImagefile(i);
                    try {
                        ReaderCoreTask.this.checkTaskStopRequest();
                        this.view.setProgressState(4, i + 1, numImageFiles);
                        Timestamp prevMTime = FileFunctions.getPrevMTime(target.getFilename());
                        if (prevMTime == null || target.getMtime().after(prevMTime)) {
                            this.view.logScanFrame(i + 1, target.getFilename());
                            this.processScanFrame(i, target);
                        }
                        this.getTarget().mapper.addRealValidFileIndex(i);
                    }
                    catch (ReaderSourceException ex) {
                        ex.printStackTrace();
                        ++errors;
                        break block6;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        ++errors;
                        break block6;
                    }
                    this.view.setProcessedFile(i + 1, numImageFiles);
                }
                ++i;
            }
            if (errors > 0) {
                this.view.setProgressState(4, 3);
                this.view.setNumGuideErrorFiles(errors, numImageFiles);
                this.view.throwPageError(errors);
            }
            this.view.setProcessedFile(numImageFiles, numImageFiles);
            this.view.setProgressState(4, 2);
        }

        private void processScanFrame(int fileIndex, ImageFilesImagefile target) throws ReaderSourceException, IOException, ThreadSuspendingException {
            ScanFrame scanFrame = new ScanFrame();
            target.setScanFrame(scanFrame);
            String filename = target.getFilename();
            ReaderSource source = new ReaderSource(RasterFactory.create(filename));
            Point2D[] scanFrameCorner = null;
            try {
                scanFrameCorner = source.createScanFrameCorner();
            }
            catch (ReaderSourceException ex) {
                FileFunctions.saveErrorImage(this.getSource().imagedir, ReaderCoreTask.this.errorImageDirPath, "PageError", fileIndex, target, source, Color.red);
                this.view.logPageError(ex, filename);
                this.getTarget().mapper.incrementNumErrorPages();
                throw new ReaderSourceException("InvalidPage:" + filename + ":" + ex.getMessage());
            }
            this.view.logGuide(scanFrameCorner);
            this.setScanFrameCorners(scanFrame, scanFrameCorner);
            if (GUIDE_SQUARE_SHAPE_CHECKER_ENABLED && !source.checkGuideSquareShape(this.getSource().masterConerPoints)) {
                this.view.showGuideError(filename);
                this.getTarget().mapper.incrementNumErrorPages();
                FileFunctions.saveErrorImage(this.getSource().imagedir, ReaderCoreTask.this.errorImageDirPath, "GuideError", fileIndex, target, source, Color.magenta);
            }
        }

        private void setScanFrameCorners(ScanFrame scanFrame, Point2D[] scanFrameCorner) {
            scanFrame.setX1((int)scanFrameCorner[0].getX());
            scanFrame.setY1((int)scanFrameCorner[0].getY());
            scanFrame.setX2((int)scanFrameCorner[1].getX());
            scanFrame.setY2((int)scanFrameCorner[1].getY());
            scanFrame.setX3((int)scanFrameCorner[2].getX());
            scanFrame.setY3((int)scanFrameCorner[2].getY());
            scanFrame.setX4((int)scanFrameCorner[3].getX());
            scanFrame.setY4((int)scanFrameCorner[3].getY());
        }
    }

    class ProcessScanFramesTaskSource
    extends TaskSource {
        File imagedir;
        ImageFiles imageFiles;
        Point2D[] masterConerPoints;

        ProcessScanFramesTaskSource(File imagedir, Point2D[] masterConerPoints, ImageFiles imageFiles) {
            this.imagedir = imagedir;
            this.masterConerPoints = masterConerPoints;
            this.imageFiles = imageFiles;
        }
    }

    class ProcessScanFramesTaskTarget
    extends TaskTarget {
        ProcessingInfoMapper mapper = new ProcessingInfoMapper();

        ProcessScanFramesTaskTarget() {
        }
    }

    class ProcessAreaTask
    extends Task {
        ProcessAreaTask(ProcessAreaTaskSource source, ProcessAreaTaskTarget target, ReadingProcessView view) {
            super(source, target, view);
        }

        ProcessAreaTaskSource getSource() {
            return (ProcessAreaTaskSource)this.source;
        }

        ProcessAreaTaskTarget getTarget() {
            return (ProcessAreaTaskTarget)this.target;
        }

        void run() throws ThreadSuspendingException {
            ImageFiles imageFiles = this.getSource().imageFiles;
            this.view.setProgressState(5, 1);
            this.view.initProgressBar(0, imageFiles.sizeImageFilesImagefile());
            this.processImageFiles(imageFiles);
        }

        private void processImageFiles(ImageFiles imageFiles) throws ThreadSuspendingException {
            int i = 0;
            while (i < imageFiles.sizeImageFilesImagefile()) {
                ImageFilesImagefile target;
                Timestamp prevMTime;
                ReaderCoreTask.this.checkTaskStopRequest();
                if (this.getSource().mapper.isValidFileIndex(i) && ((prevMTime = FileFunctions.getPrevMTime((target = imageFiles.getImageFilesImagefile(i)).getFilename())) == null || target.getMtime().after(prevMTime))) {
                    try {
                        this.view.setProgressBarValue(i + 1);
                        this.processArea(i, target);
                        this.view.setProgressState(5, 2);
                    }
                    catch (ReaderSourceException ex) {
                        this.view.error(ex);
                        this.view.setProgressState(5, 3);
                    }
                    catch (IOException ex) {
                        this.view.error(ex);
                        this.view.setProgressState(5, 3);
                    }
                }
                ++i;
            }
        }

        private void processArea(int fileIndex, ImageFilesImagefile target) throws IOException, ThreadSuspendingException, ReaderSourceException {
            String filename = target.getFilename();
            ReaderSource source = new ReaderSource(RasterFactory.create(filename));
            int validFileIndex = this.getSource().mapper.getValidFileIndex(fileIndex);
            int sampleID = 1 + validFileIndex / this.getSource().numPages;
            int pageNumber = 1 + validFileIndex % this.getSource().numPages;
            Page page = new Page();
            page.setSampleID(sampleID);
            page.setNumber(pageNumber);
            target.getScanFrame().setPage(page);
            if (pageNumber == 1) {
                this.getSource().matrixBuilder.addRowFileList(new LinkedList());
            }
            this.getSource().matrixBuilder.addRowFile(new File(target.getFilename()));
            this.view.logProcessArea(pageNumber, sampleID, target.getFilename());
            IFormElementsChoice[] formStates = this.processFormElements(target, source, sampleID, pageNumber);
            target.getScanFrame().getPage().setFormElements(formStates);
        }

        private IFormElementsChoice[] processFormElements(ImageFilesImagefile target, RasterSource source, int sampleID, int pageNumber) throws IOException, ThreadSuspendingException, ReaderSourceException {
            ReaderSourceTranslated tSource = new ReaderSourceTranslated(source.getRaster(), this.getSource().masterPoints, ReaderImageProcessor.getPointArray(target.getScanFrame()), BLACK_THRESHOLD);
            LinkedHashMap formMap = this.getSource().qSchema.getFormElements(pageNumber);
            LinkedHashMap rectMap = this.getSource().qSchema.getRectangle(pageNumber);
            IFormElementsChoice[] formStates = new IFormElementsChoice[((HashMap)formMap).keySet().size()];
            int i = 0;
            int formElementSize = formMap.size();
            int validFileIndexSize = this.getSource().mapper.getValidFileIndexSize();
            Iterator it = ((HashMap)formMap).keySet().iterator();
            while (it.hasNext()) {
                ReaderCoreTask.this.checkTaskStopRequest();
                String id = (String)it.next();
                int validFileIndex = pageNumber + (sampleID - 1) * this.getSource().qSchema.getNumberOfPages();
                this.view.setProgressState(5, i + 1, formElementSize, validFileIndex, validFileIndexSize);
                Rectangle rect = (Rectangle)((HashMap)rectMap).get(id);
                Element formElem = (Element)((HashMap)formMap).get(id);
                String localName = formElem.getLocalName();
                if (localName.equals(ReaderCoreTask.FORMTYPE_SELECT1) || localName.equals(ReaderCoreTask.FORMTYPE_SELECT)) {
                    formStates[i] = this.processFormElementMarkarea(sampleID, id, rect, formElem, tSource);
                } else if (localName.equals(ReaderCoreTask.FORMTYPE_TEXTAREA) || localName.equals(ReaderCoreTask.FORMTYPE_INPUT)) {
                    formStates[i] = this.processFormElementTextarea(sampleID - 1, id, rect, formElem, tSource, target.getFilename());
                    this.getSource().matrixBuilder.addAreaImage(sampleID - 1, id, new File(target.getFilename()));
                } else {
                    throw new ReaderSourceException("UNSUPPORTED ELEMENT:" + localName);
                }
                this.view.setProcessedElements(validFileIndex, validFileIndexSize);
                ++i;
            }
            return formStates;
        }

        private FormElementsMarkarea processFormElementMarkarea(int sampleID, String id, Rectangle rect, Element select1Element, ReaderSourceTranslated source) {
            FormElementsMarkarea ret = new FormElementsMarkarea();
            ret.setRef(id);
            double density = source.getDensity(rect);
            ret.setMarkDensity(density);
            this.view.logRectInfo(id, rect, source, MARK_RECOGNIZE_DENSITY < density, density);
            return ret;
        }

        private FormElementsTextarea processFormElementTextarea(int sampleID, String id, Rectangle rect, Element select1Element, ReaderSourceTranslated source, String filename) throws ThreadSuspendingException {
            File imageFile = FileFunctions.createTextareaImageFile(this.getSource().imagedir, ReaderCoreTask.this.textareaImageDirPath, sampleID, id, filename);
            this.getSource().matrixBuilder.putAreaFile(sampleID, id, imageFile);
            while (true) {
                try {
                    ReaderImageProcessor.createTextareaImage(rect, source, imageFile);
                }
                catch (IOException ex) {
                    FileFunctions.confirmRetryPageSaving(this.view, ex, imageFile);
                    continue;
                }
                break;
            }
            this.view.logRectInfo(id, rect, source, imageFile);
            FormElementsTextarea ret = new FormElementsTextarea();
            ret.setRef(id);
            TextareaImage image = new TextareaImage();
            image.setFilename(imageFile.getAbsolutePath());
            image.setMtime(new Timestamp(imageFile.lastModified()));
            ret.setTextareaImage(image);
            return ret;
        }
    }

    class ProcessAreaTaskSource
    extends TaskSource {
        File imagedir;
        QuestionnaireSchema qSchema;
        ImageFiles imageFiles;
        ProcessingInfoMapper mapper;
        int numPages;
        Point2D[] masterPoints;
        MatrixBuilder matrixBuilder;

        ProcessAreaTaskSource(File imagedir, QuestionnaireSchema qSchema, ImageFiles imageFiles, ProcessingInfoMapper mapper, Point2D[] masterPoints, MatrixBuilder matrixBuilder) {
            this.imagedir = imagedir;
            this.qSchema = qSchema;
            this.numPages = qSchema.getNumberOfPages();
            this.imageFiles = imageFiles;
            this.mapper = mapper;
            this.masterPoints = masterPoints;
            this.matrixBuilder = matrixBuilder;
        }
    }

    class ProcessAreaTaskTarget
    extends TaskTarget {
        ProcessAreaTaskTarget() {
        }
    }

    class ProcessValuesTask
    extends Task {
        ProcessValuesTask(ProcessValuesTaskSource source, ProcessValuesTaskTarget target, ReadingProcessView view) {
            super(source, target, view);
        }

        ProcessValuesTaskSource getSource() {
            return (ProcessValuesTaskSource)this.source;
        }

        ProcessValuesTaskTarget getTarget() {
            return (ProcessValuesTaskTarget)this.target;
        }

        void run() throws ThreadSuspendingException, NumberFormatException, TransformerException {
            int numFiles = this.getSource().numFiles;
            int numValidFiles = this.getSource().mapper.getValidFileIndexSize();
            int numPages = this.getSource().qSchema.getNumberOfPages();
            int numSamples = numValidFiles / numPages;
            this.getSource().matrixBuilder.setRowSize(numSamples);
            int numColumns = this.getSource().qSchema.getNumberOfColumns();
            this.view.setProgressState(6, 1);
            int rowIndex = 0;
            while (rowIndex < numSamples) {
                ReaderCoreTask.this.checkTaskStopRequest();
                this.view.setProgressState(6, rowIndex + 1, numSamples);
                this.view.setProcessedValues(rowIndex + 1, numSamples);
                this.getSource().matrixBuilder.setMatrix(rowIndex, this.processValuesParSample(numPages, numColumns, rowIndex));
                ++rowIndex;
            }
            this.view.setProgressState(6, 2);
        }

        private Object[] processValuesParSample(int numPages, int numColumns, int rowIndex) throws ThreadSuspendingException, TransformerException {
            Object[] sampleData = new Object[numColumns];
            Iterator it = this.getSource().qSchema.getQIDSet().iterator();
            int columnIndex = 0;
            while (columnIndex < numColumns) {
                ReaderCoreTask.this.checkTaskStopRequest();
                String qid = (String)it.next();
                List idList = this.getSource().qSchema.getIDList(qid);
                if (idList != null) {
                    columnIndex += this.processValuesParMarkareas(sampleData, numPages, rowIndex, columnIndex, qid, idList);
                    continue;
                }
                this.processValuesParTextarea(sampleData, rowIndex, columnIndex, qid);
                ++columnIndex;
            }
            return sampleData;
        }

        private void processValuesParTextarea(Object[] sampleData, int rowIndex, int columnIndex, String qid) throws TransformerException {
            ImageFilesImagefile imagefile = this.getSource().imageFiles.getImageFilesImagefile(this.getSource().mapper.getRealFileIndex(rowIndex * this.getSource().qSchema.getNumberOfPages()));
            Page page = imagefile.getScanFrame().getPage();
        }

        private CellValue processValue(String qid) throws TransformerException {
            String value;
            Element elem = this.getSource().qSchema.getElement(qid);
            int page = this.getSource().qSchema.getPage(qid);
            Element formElement = this.getSource().qSchema.getFormElement(elem);
            String type = formElement.getLocalName();
            NodeList nlValue = formElement.getElementsByTagNameNS("value", "http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
            NodeList fileElem = formElement.getElementsByTagNameNS("file", "http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
            String string = nlValue == null ? null : (value = nlValue.item(0) == null ? null : nlValue.item(0).getNodeValue());
            String filename = fileElem == null ? null : (fileElem.item(0) == null ? null : ((Element)fileElem.item(0)).getAttributeNodeNS("filename", "http://sqs.cmr.sfc.keio.ac.jp/2004/reader").getValue());
            value = value == null && filename != null ? filename : value;
            return new CellValue(page, qid, type, value);
        }

        private int processValuesParMarkareas(Object[] sampleData, int numPages, int rowIndex, int columnIndex, String qid, List idList) throws TransformerException {
            double max = 0.0;
            double secondMax = 0.0;
            int maxItemIndex = -1;
            LinkedList<CellValue> itemList = new LinkedList<CellValue>();
            CellValue cellValue = null;
            ImageFilesImagefile imagefile = null;
            int itemIndex = 0;
            while (itemIndex < idList.size()) {
                String id = (String)idList.get(itemIndex);
                cellValue = this.getSource().qSchema.createCellOptionValue(qid, id, itemIndex);
                int validFileIndex = numPages * rowIndex + cellValue.page - 1;
                int realFileIndex = this.getSource().mapper.getRealFileIndex(validFileIndex);
                imagefile = this.getSource().imageFiles.getImageFilesImagefile(realFileIndex);
                Page pageObject = imagefile.getScanFrame().getPage();
                try {
                    int page = pageObject.getNumber();
                    int idIndex = this.getSource().qSchema.getIDIndex(id);
                    double density = ((FormElementsMarkarea)pageObject.getFormElements(idIndex)).getMarkDensity();
                    if (MARK_RECOGNIZE_DENSITY < density) {
                        if (max <= density) {
                            secondMax = max;
                            max = density;
                            maxItemIndex = itemIndex;
                        } else if (secondMax <= density) {
                            secondMax = density;
                        }
                        itemList.add(cellValue);
                    }
                }
                catch (Exception ignore) {
                    ignore.printStackTrace();
                }
                ++itemIndex;
            }
            return this.processValuesParMarkareas(sampleData, rowIndex, columnIndex, qid, idList, max, secondMax, maxItemIndex, itemList, cellValue, imagefile);
        }

        private int processValuesParMarkareas(Object[] sampleData, int rowIndex, int columnIndex, String qid, List idList, double max, double secondMax, int maxItemIndex, List itemList, CellValue cellValue, ImageFilesImagefile imagefile) {
            if (cellValue.type.equals(ReaderCoreTask.FORMTYPE_SELECT1)) {
                if (1 < itemList.size() && max - secondMax < DOUBLE_MARK_RECOGNIZE_DENSITY) {
                    this.view.logInvalidMark(rowIndex + 1, imagefile.getFilename(), qid, itemList.size());
                    sampleData[columnIndex] = "ERROR:" + StringUtil.join(itemList, ",");
                    this.getSource().mapper.incrementNumErrorMarkSets();
                    this.getSource().mapper.addErrorArea(rowIndex, cellValue.page, qid);
                }
                if (maxItemIndex >= 0) {
                    sampleData[columnIndex] = ((String)idList.get(maxItemIndex)).substring(qid.length() + 2);
                }
                return 1;
            }
            if (cellValue.type.equals(ReaderCoreTask.FORMTYPE_SELECT)) {
                return this.processSelectValues(sampleData, columnIndex, idList, itemList);
            }
            throw new RuntimeException("invalidType:" + cellValue.type);
        }

        private int processSelectValues(Object[] sampleData, int columnIndex, List idList, List itemList) {
            int itemIndex = 0;
            while (itemIndex < idList.size()) {
                String selectId = (String)idList.get(itemIndex);
                sampleData[columnIndex + itemIndex] = ReaderCoreTask.FORMVALUE_NON_SELECTED;
                ++itemIndex;
            }
            int i = 0;
            while (i < itemList.size()) {
                CellValueOption cv = (CellValueOption)itemList.get(i);
                sampleData[columnIndex + cv.index] = ReaderCoreTask.FORMVALUE_SELECTED;
                ++i;
            }
            return idList.size();
        }
    }

    class ProcessValuesTaskSource
    extends TaskSource {
        int numFiles;
        ProcessingInfoMapper mapper;
        QuestionnaireSchema qSchema;
        ImageFiles imageFiles;
        MatrixBuilder matrixBuilder;

        ProcessValuesTaskSource(int numFiles, ProcessingInfoMapper mapper, QuestionnaireSchema qSchema, ImageFiles imageFiles, MatrixBuilder matrixBuilder) {
            this.numFiles = numFiles;
            this.mapper = mapper;
            this.qSchema = qSchema;
            this.imageFiles = imageFiles;
            this.matrixBuilder = matrixBuilder;
        }
    }

    class ProcessValuesTaskTarget
    extends TaskTarget {
        ProcessValuesTaskTarget() {
        }
    }

    class ProcessErrorImagesTask
    extends Task {
        ProcessErrorImagesTask(ProcessErrorImagesTaskSource source, ProcessErrorImagesTaskTarget target, ReadingProcessView view) {
            super(source, target, view);
        }

        ProcessErrorImagesTaskSource getSource() {
            return (ProcessErrorImagesTaskSource)this.source;
        }

        ProcessErrorImagesTaskTarget getTarget() {
            return (ProcessErrorImagesTaskTarget)this.target;
        }

        void run() throws ThreadSuspendingException {
            ImageFiles imageFiles = this.getSource().imageFiles;
            Set set = this.getSource().mapper.getErrorAreaEntrySet();
            if (set.size() > 0) {
                int errorFileIndex = 0;
                this.view.setWaitCursor();
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    ReaderCoreTask.this.checkTaskStopRequest();
                    this.view.setProgressState(7, errorFileIndex + 1, set.size());
                    this.processErrorImage(imageFiles, it);
                    ++errorFileIndex;
                }
            } else {
                return;
            }
            this.view.setDefaultCursor();
        }

        private void processErrorImage(ImageFiles imageFiles, Iterator it) throws ThreadSuspendingException {
            Map.Entry entry = (Map.Entry)it.next();
            int rowIndex = (Integer)entry.getKey();
            int realFileIndex = this.getSource().mapper.getRealFileIndex(rowIndex * this.getSource().qSchema.getNumberOfPages());
            ImageFilesImagefile target = imageFiles.getImageFilesImagefile()[realFileIndex];
            List list = (List)entry.getValue();
            this.saveErrorImages(ReaderCoreTask.this.errorImageDirPath, this.view, imageFiles, rowIndex, list, BLACK_THRESHOLD);
        }

        void saveErrorImages(String errorImageDirPath, ReadingProcessView view, ImageFiles imagefiles, int rowIndex, List list, int threshold) throws ThreadSuspendingException {
            File imagedir = this.getSource().imagedir;
            QuestionnaireSchema qSchema = this.getSource().qSchema;
            while (true) {
                ScanFrame prevScanFrame = null;
                ReaderSourceTranslated tSource = null;
                BufferedImage image = null;
                ImageFilesImagefile target = null;
                try {
                    File errorFile = null;
                    Graphics2D g = null;
                    int i = 0;
                    while (i < list.size()) {
                        Object[] arr = (Object[])list.get(i);
                        int page = (Integer)arr[0];
                        String qid = (String)arr[1];
                        target = imagefiles.getImageFilesImagefile(rowIndex * qSchema.getNumberOfPages() + page - 1);
                        ScanFrame scanFrame = target.getScanFrame();
                        if (prevScanFrame != scanFrame) {
                            if (image != null) {
                                this.saveErrorImage(errorFile, image);
                            }
                            prevScanFrame = scanFrame;
                            ReaderSource source = new ReaderSource(RasterFactory.create(target.getFilename()));
                            tSource = new ReaderSourceTranslated(source.getRaster(), (Point2D[])qSchema.getMasterPoints(), ReaderImageProcessor.getPointArray(target.getScanFrame()), threshold);
                            image = FileFunctions.createErrorImage(target, source, Color.green);
                            errorFile = FileFunctions.createErrorImageFile(imagedir, errorImageDirPath, "MarkError", rowIndex, target.getFilename());
                            this.getSource().matrixBuilder.addAreaImage(rowIndex, qid, errorFile);
                            g = (Graphics2D)image.getGraphics();
                            g.setColor(Color.red);
                        }
                        ReaderImageProcessor.drawErrorMarks(qSchema, g, page, qid, tSource);
                        ++i;
                    }
                    if (image == null) break;
                    this.saveErrorImage(errorFile, image);
                }
                catch (IOException ex) {
                    if (target != null) {
                        FileFunctions.confirmRetryPageSaving(view, ex, new File(target.getFilename()));
                        continue;
                    }
                    FileFunctions.confirmRetryPageSaving(view, ex, null);
                    continue;
                }
                break;
            }
        }

        void saveErrorImage(File path, BufferedImage image) throws IOException {
            FileUtil.writeImageFile(path, image);
        }
    }

    class ProcessErrorImagesTaskSource
    extends TaskSource {
        File imagedir;
        QuestionnaireSchema qSchema;
        ImageFiles imageFiles;
        ProcessingInfoMapper mapper;
        MatrixBuilder matrixBuilder;

        ProcessErrorImagesTaskSource(File imagedir, QuestionnaireSchema qSchema, ImageFiles imageFiles, ProcessingInfoMapper mapper, MatrixBuilder matrixBuilder) {
            this.imagedir = imagedir;
            this.qSchema = qSchema;
            this.imageFiles = imageFiles;
            this.mapper = mapper;
            this.matrixBuilder = matrixBuilder;
        }
    }

    class ProcessErrorImagesTaskTarget
    extends TaskTarget {
        ProcessErrorImagesTaskTarget() {
        }
    }
}

