/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.logic;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import net.sf.sqs_xml.image.RasterSource;
import net.sf.sqs_xml.reader.logic.QuestionnaireSchema;
import net.sf.sqs_xml.reader.logic.ReaderSourceTranslated;
import net.sf.sqs_xml.reader.model.ScanFrame;
import net.sf.sqs_xml.util.FileUtil;

public class ReaderImageProcessor {
    static AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.4f);

    static Point2D[] getPointArray(ScanFrame scanFrame) {
        return new Point2D[]{new Point2D.Double(scanFrame.getX1(), scanFrame.getY1()), new Point2D.Double(scanFrame.getX2(), scanFrame.getY2()), new Point2D.Double(scanFrame.getX3(), scanFrame.getY3()), new Point2D.Double(scanFrame.getX4(), scanFrame.getY4())};
    }

    static void createTextareaImage(Rectangle rect, ReaderSourceTranslated source, File imageFile) throws IOException {
        BufferedImage bufferedImage = RasterSource.createImage(source.cropRaster(rect, 2.0), false);
        FileUtil.writeImageFile(imageFile, bufferedImage);
    }

    static void drawErrorMarks(QuestionnaireSchema schema, Graphics2D g, int page, String qid, ReaderSourceTranslated tSource) {
        List list = schema.getIDList(qid);
        LinkedList itemList = new LinkedList();
        Point2D[] markRectCorners = new Point2D[4];
        int itemIndex = 0;
        while (itemIndex < list.size()) {
            String id = (String)list.get(itemIndex);
            LinkedHashMap rectMap = schema.getRectangle(page);
            Rectangle rect = (Rectangle)((HashMap)rectMap).get(id);
            tSource.translatePointArray(markRectCorners, rect);
            ReaderImageProcessor.drawMarkRect(g, markRectCorners);
            ++itemIndex;
        }
    }

    static void drawMarkRect(Graphics2D g, Point2D[] corner) {
        Composite defaultComposite = g.getComposite();
        g.setComposite(alphaComposite);
        int w = 2;
        int x0 = (int)corner[0].getX();
        int y0 = (int)corner[0].getY();
        int x1 = (int)corner[1].getX();
        int y1 = (int)corner[1].getY();
        int x2 = (int)corner[2].getX();
        int y2 = (int)corner[3].getY();
        int x3 = (int)corner[3].getX();
        int y3 = (int)corner[3].getY();
        x0 -= 2;
        y0 += 3;
        x1 += 4;
        y1 += 3;
        x2 -= 2;
        y2 -= 2;
        x3 += 4;
        y3 -= 2;
        int i = -1 * w;
        while (i <= w) {
            g.drawLine(x0 - i, y0 - i, x1 + i, y1 - i);
            g.drawLine(x0 - i, y0 - i, x2 - i, y2 + 1);
            g.drawLine(x1 + i, y1 - i, x3 + i, y3 + i);
            g.drawLine(x2 - i, y2 + i, x3 + i, y3 + i);
            ++i;
        }
        g.setComposite(defaultComposite);
    }

    static void drawScanFrameRect(BufferedImage image, Color color, ScanFrame scanFrame, int w, int h) {
        Point2D[] c = ReaderImageProcessor.getPointArray(scanFrame);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(color);
        Composite defaultComposite = g.getComposite();
        g.setComposite(alphaComposite);
        int[] nArray = new int[11];
        nArray[1] = w;
        nArray[2] = w;
        nArray[5] = (int)c[0].getX();
        nArray[6] = (int)c[2].getX();
        nArray[7] = (int)c[3].getX();
        nArray[8] = (int)c[1].getX();
        nArray[9] = (int)c[0].getX();
        int[] nArray2 = new int[11];
        nArray2[2] = h;
        nArray2[3] = h;
        nArray2[5] = (int)c[0].getY();
        nArray2[6] = (int)c[2].getY();
        nArray2[7] = (int)c[3].getY();
        nArray2[8] = (int)c[1].getY();
        nArray2[9] = (int)c[0].getY();
        g.fillPolygon(nArray, nArray2, 11);
        g.setComposite(defaultComposite);
        g.setComposite(defaultComposite);
    }
}

