/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.logic;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLEncoder;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.sqs_xml.httpd.MarkReaderHttpd;
import net.sf.sqs_xml.reader.logic.BaseTaskSource;
import net.sf.sqs_xml.reader.logic.BaseTaskTarget;
import net.sf.sqs_xml.reader.logic.FileFunctions;
import net.sf.sqs_xml.reader.logic.ReaderCoreTask;
import net.sf.sqs_xml.reader.logic.ReadingProcessView;
import net.sf.sqs_xml.reader.logic.ThreadSuspendingException;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.util.AlbertBrowserLauncher;
import net.sf.sqs_xml.util.FileUtil;
import net.sf.sqs_xml.util.JNLPBrowserLauncher;

class ReaderOutputterTask
extends ReaderCoreTask {
    static final String MS932_FILE_ENCODING = "MS932";
    static final String UTF8_FILE_ENCODING = "UTF-8";

    public ReaderOutputterTask(BaseTaskSource source, BaseTaskTarget target, ReadingProcessView view) {
        super(source, target, view);
    }

    public void save() throws TranslatorException, TransformerException, IOException, ParserConfigurationException, ThreadSuspendingException {
        String name = this.getSource().srcdir.getParent() + File.separator + this.getSource().srcdir.getName();
        File tgtdir = this.getSource().tgtdir;
        File allIndexFile = new File(tgtdir.getAbsolutePath() + File.separator + "all.html");
        File textareaIndexFile = new File(tgtdir.getAbsolutePath() + File.separator + "textarea.html");
        File markIndexFile = new File(tgtdir.getAbsolutePath() + File.separator + "mark.html");
        File indexHtml = new File(tgtdir.getAbsolutePath() + File.separator + "index.html");
        File csvfile = new File(tgtdir.getAbsolutePath() + File.separator + this.getSource().srcdir.getName() + "-csv.txt");
        if (this.processScanFramesTaskTarget.mapper.getNumErrorPages() == 0) {
            this.saveCSV(csvfile);
        }
        this.saveTextareaIndexHtml(textareaIndexFile, tgtdir);
        this.saveMarkIndexHtml(markIndexFile, tgtdir);
        this.saveAllHtml(allIndexFile, tgtdir);
        this.saveIndexHtml(tgtdir, indexHtml, allIndexFile, textareaIndexFile, markIndexFile, csvfile);
        this.showDocument(indexHtml);
    }

    private void saveIndexHtml(File tgtir, File indexHtml, File allIndexFile, File textareaIndexFile, File markIndexFile, File csvfile) throws IOException {
        String encoding = UTF8_FILE_ENCODING;
        PrintWriter out = FileUtil.createPrintWriter(indexHtml, encoding);
        File pdffile = (File)this.getSource().pdffileList.get(0);
        String pdfPath = FileFunctions.getRelativePath(this.getSource().tgtdir, pdffile);
        if (File.separator.endsWith("\\")) {
            pdfPath = pdfPath.replaceAll("\\\\", "/");
        }
        out.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
        out.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"ja\" xml:lang=\"ja\">");
        out.println("<head>");
        out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + encoding + "\" />");
        out.print("<title>");
        out.print(this.getSource().srcdir.getAbsolutePath());
        out.println("</title>");
        out.println("</head>");
        out.println("<body>");
        out.println("<h2><a href=\"" + this.getSource().srcdir.toURI().toURL() + "\">\u51e6\u7406\u5bfe\u8c61\u30d5\u30a9\u30eb\u30c0:" + this.getSource().srcdir.getAbsolutePath() + "</a></h2>");
        out.println("<ul>");
        out.println("<li><a href=\"../" + pdfPath + "\">\u5370\u5237\u539f\u7a3fPDF\u30d5\u30a1\u30a4\u30eb: " + pdfPath + "</a></li>");
        out.println("</ul>");
        out.println("<h2><a href=\"" + indexHtml.toURI().toURL() + "\">\u51e6\u7406\u7d50\u679c\u30d5\u30a9\u30eb\u30c0:" + indexHtml.getAbsolutePath() + "</a></h2>");
        out.println("<ul>");
        out.println("<li>\u7d50\u679c\u4e00\u89a7\uff1a<ul>");
        out.println("<li>\u5185\u5bb9\u4e00\u89a7\uff1a<ul>");
        out.println("<li><a href=\"" + csvfile.getName() + "\">CSV\u5f62\u5f0f: " + csvfile.getName() + "</a></li>");
        out.println("<li><a href=\"" + markIndexFile.getName() + "\">HTML\u5f62\u5f0f: " + markIndexFile.getName() + "</a></li>");
        out.println("</ul></li>");
        out.println("<li>\u753b\u50cf\u4e00\u89a7<ul>");
        out.println("<li><a href=\"" + allIndexFile.getName() + "\">\u30de\u30fc\u30af\u6b04+\u81ea\u7531\u8a18\u8ff0\u6b04\u753b\u50cf\u306e\u4e00\u89a7: " + allIndexFile.getName() + "</a></li>");
        out.println("<li><a href=\"" + textareaIndexFile.getName() + "\">\u81ea\u7531\u8a18\u8ff0\u6b04\u753b\u50cf\u306e\u4e00\u89a7: " + textareaIndexFile.getName() + "</a></li></ul></li>");
        out.println("</ul></li>");
        out.println("<li>\u81ea\u7531\u8a18\u8ff0\u6b04\u753b\u50cf\u306e\u30c6\u30ad\u30b9\u30c8\u8d77\u3053\u3057\uff1a(MarkReader\u304c\u8d77\u52d5\u3057\u3066\u3044\u306a\u3044\u3068\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093)<ul>");
        out.println("<li><a href=\"http://127.0.0.1:6961/servlet/ViewMatrix?dir=" + URLEncoder.encode(this.getSource().tgtdir.getAbsolutePath(), UTF8_FILE_ENCODING) + "&amp;src=all.html\">\u30de\u30fc\u30af\u6b04+\u81ea\u7531\u8a18\u8ff0\u6b04\u753b\u50cf</a></li>");
        out.println("<li><a href=\"http://127.0.0.1:6961/servlet/ViewMatrix?dir=" + URLEncoder.encode(this.getSource().tgtdir.getAbsolutePath(), UTF8_FILE_ENCODING) + "\">\u81ea\u7531\u8a18\u8ff0\u6b04\u753b\u50cf</a></li>");
        out.println("</ul></li>");
        out.println("</ul>");
        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    private void showDocument(File indexHtml) throws IOException {
        URL url = MarkReaderHttpd.getSingleton().getURL(indexHtml);
        try {
            BasicService basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            if (basicService.isWebBrowserSupported()) {
                new JNLPBrowserLauncher(basicService).showDocument(url);
            } else {
                new AlbertBrowserLauncher().showDocument(url);
            }
        }
        catch (UnavailableServiceException ignore) {
            new AlbertBrowserLauncher().showDocument(url);
        }
    }

    private void saveAllHtml(File allIndexFile, File resultDir) throws TransformerException, ThreadSuspendingException {
        while (true) {
            try {
                this.initQuestionnaireStructureTaskTarget.matrixBuilder.saveHTML(allIndexFile, UTF8_FILE_ENCODING, this.getSource().srcdir, resultDir, 0);
            }
            catch (IOException ex) {
                FileFunctions.confirmRetryPageSaving(this.view, ex, allIndexFile);
                continue;
            }
            break;
        }
    }

    private void saveTextareaIndexHtml(File textareaIndexFile, File resultDir) throws TransformerException, ThreadSuspendingException {
        while (true) {
            try {
                this.initQuestionnaireStructureTaskTarget.matrixBuilder.saveHTML(textareaIndexFile, UTF8_FILE_ENCODING, this.getSource().srcdir, resultDir, 1);
            }
            catch (IOException ex) {
                FileFunctions.confirmRetryPageSaving(this.view, ex, textareaIndexFile);
                continue;
            }
            break;
        }
    }

    private void saveMarkIndexHtml(File markIndexFile, File resultDir) throws TransformerException, ThreadSuspendingException {
        while (true) {
            try {
                this.initQuestionnaireStructureTaskTarget.matrixBuilder.saveHTML(markIndexFile, UTF8_FILE_ENCODING, this.getSource().srcdir, resultDir, 2);
            }
            catch (IOException ex) {
                FileFunctions.confirmRetryPageSaving(this.view, ex, markIndexFile);
                continue;
            }
            break;
        }
    }

    private void saveCSV(File tgtfile) throws TransformerException, ThreadSuspendingException {
        while (true) {
            try {
                while (tgtfile == null) {
                }
                this.initQuestionnaireStructureTaskTarget.matrixBuilder.saveCSV(tgtfile, MS932_FILE_ENCODING);
            }
            catch (IOException ex) {
                FileFunctions.confirmRetryPageSaving(this.view, ex, tgtfile);
                continue;
            }
            break;
        }
    }
}

