/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.logic;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import net.sf.sqs_xml.reader.logic.QuestionnaireSchema;
import net.sf.sqs_xml.reader.logic.ReaderLogMessage;
import net.sf.sqs_xml.reader.logic.ReaderSourceTranslated;
import net.sf.sqs_xml.reader.swing.ProgressLoggerConsoleFrame;
import net.sf.sqs_xml.swing.LoggerConsoleFrame;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import org.apache.avalon.framework.logger.Logger;

public class ReadingProcessView {
    Logger logger;
    JProgressBar progressBar;

    ReadingProcessView(Logger logger) {
        this.logger = logger;
        this.progressBar = ((LoggerConsoleFrame)logger).getProgressBar();
    }

    void setImagedir(File imagedir) {
        ReaderLogMessage.logImageDir(this.logger, imagedir);
        if (this.logger instanceof ProgressLoggerConsoleFrame) {
            ((ProgressLoggerConsoleFrame)this.logger).setBorderTitle(imagedir.getAbsolutePath());
        }
    }

    void setPDFFile(File pdffile) {
        ReaderLogMessage.logPDFFile(this.logger, pdffile);
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(JProgressBar progressbar) {
        this.progressBar = progressbar;
    }

    void error(Exception ex) {
        this.logger.error(ex.getLocalizedMessage());
    }

    void errorDialog(Exception ex, boolean throwerror) throws Exception {
        this.logger.error(ex.getLocalizedMessage());
        JOptionPane.showMessageDialog((Component)this.logger, ex.getMessage(), "\u30a8\u30e9\u30fc", 0);
        if (throwerror) {
            throw ex;
        }
    }

    void setProgressState(int step) {
        this.setProgressState(step, 1);
        this.progressBar.setStringPainted(true);
        if (step == 1) {
            this.progressBar.setString("(Step 1) initializing...");
        } else if (step == 2) {
            this.progressBar.setString("(Step 2) Find ImageFiles");
        }
    }

    void setProgressState(int step, int i, int size) {
        if (step != 7) {
            this.setProgressState(step, 1);
            this.progressBar.setStringPainted(true);
            this.progressBar.setValue(i);
            this.progressBar.setMaximum(size);
        }
        if (step == 3) {
            this.progressBar.setString("(Step 3) Process ImageFiles: " + i + " / " + size + " files");
        } else if (step == 4) {
            this.progressBar.setString("(Step 4) Process ScanFrames: " + i + " / " + size + " files");
        } else if (step == 6) {
            this.progressBar.setString("(Step 6) Process Values: " + i + " / " + size + " samples");
        } else if (step == 7) {
            this.progressBar.setString("(ERROR) Process Error Images: " + i + " / " + size + " file(s)");
        }
    }

    void setProgressState(int step, int i, int formElementSize, int validFileIndex, int validFileIndexSize) {
        this.setProgressState(step, 1);
        this.progressBar.setStringPainted(true);
        this.progressBar.setValue(validFileIndex);
        this.progressBar.setMaximum(validFileIndexSize);
        if (step == 5) {
            this.progressBar.setString("(Step 5) Process Elements: " + i + " / " + formElementSize + " in File: " + validFileIndex + " / " + validFileIndexSize);
        }
    }

    void setProgressBarValue(int i) {
        this.progressBar.setValue(i);
    }

    void logScanFrame(int i, String filename) {
        ReaderLogMessage.logScanFrame(this.logger, i, filename);
    }

    void logPageError(final Exception ex, final String filename) {
        ReaderLogMessage.logPageError(this.logger, ex, filename);
        if (this.logger instanceof Component) {
            new Thread(){

                public void run() {
                    JOptionPane.showMessageDialog((Component)ReadingProcessView.this.logger, new Object[]{ex.getMessage(), filename}, "\u30a8\u30e9\u30fc", 0);
                }
            }.start();
        }
    }

    void logGuide(Point2D[] scanFrameCorner) {
        ReaderLogMessage.logGuide(this.logger, scanFrameCorner);
    }

    void throwIncorrectPDFException(File pdffile) throws TranslatorException {
        throw new TranslatorException(new String[]{"PDF\u30d5\u30a1\u30a4\u30eb\u306e\u5185\u5bb9\u304c\u6b63\u3057\u304f\u8a8d\u8b58\u3067\u304d\u307e\u305b\u3093\uff0e", "\u539f\u7a3f\u3068\u3057\u3066\u5229\u7528\u3057\u305fPDF\u30d5\u30a1\u30a4\u30eb\u3092\u30d5\u30a9\u30eb\u30c0\u306b\u30b3\u30d4\u30fc\u3057\u3066\u304f\u3060\u3055\u3044\uff0e", pdffile.getAbsolutePath()});
    }

    void throwNoPDFException() throws TranslatorException {
        throw new TranslatorException(new String[]{"\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a9\u30eb\u30c0\u306e\u4e2d\u306bPDF\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\uff0e", "\u539f\u7a3f\u3068\u3057\u3066\u5229\u7528\u3057\u305fPDF\u30d5\u30a1\u30a4\u30eb\u3092\u5165\u308c\u3066\u304f\u3060\u3055\u3044\uff0e"});
    }

    void throwManyPDFException() throws TranslatorException {
        throw new TranslatorException(new String[]{"\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a9\u30eb\u30c0\u306e\u4e2d\u306bPDF\u30d5\u30a1\u30a4\u30eb\u304c\u8907\u6570\u3042\u308a\u307e\u3059\uff0e", "\u6b63\u3057\u3044\u30d5\u30a9\u30eb\u30c0\u3092\u6307\u5b9a\u3059\u308b\u304b\uff0c\u4e0d\u8981\u306aPDF\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\uff0e"});
    }

    void showGuideError(String filename) {
        ReaderLogMessage.logGuideError(this.logger, filename);
        if (this.logger instanceof Component) {
            JOptionPane.showMessageDialog((Component)this.logger, new Object[]{"\u4e0a\u4e0b\u306e\u25a0\u30de\u30fc\u30af\u5217\u304c\u6b6a\u3093\u3067\u3044\u308b\u305f\u3081\uff0c\u6b63\u3057\u304f\u8aad\u3081\u307e\u305b\u3093", filename}, "\u30a8\u30e9\u30fc", 0);
        }
    }

    void setProcessedFile(int i, int numImageFiles) {
        ((ProgressLoggerConsoleFrame)this.logger).setProcessedFile(i, numImageFiles);
    }

    void setNumGuideErrorFiles(int error, int numImageFiles) {
        ((ProgressLoggerConsoleFrame)this.logger).setGuideError(error, numImageFiles, numImageFiles);
    }

    void setProgressState(int index, int mode) {
        ((ProgressLoggerConsoleFrame)this.logger).setProgressState(index, mode);
    }

    void initProgressBar(int numFiles, int numPages) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMaximum(numFiles);
    }

    void setFiles(int numFiles) {
        ((ProgressLoggerConsoleFrame)this.logger).setNumFiles(numFiles);
    }

    void setPageSetError(int numFiles, int numPages) {
        ((ProgressLoggerConsoleFrame)this.logger).setPageNumberError(numFiles, numPages);
    }

    void setNumTargetFiles(int numTargetFiles) {
        ((ProgressLoggerConsoleFrame)this.logger).setTargetFileCount(numTargetFiles);
    }

    void logProcessArea(int pageNumber, int sampleID, String targetFilePath) {
        ReaderLogMessage.logFile(this.logger, pageNumber, sampleID, targetFilePath);
    }

    void setProcessedElements(int validFileIndex, int validFileIndexSize) {
        ((ProgressLoggerConsoleFrame)this.logger).setProcessedElements(validFileIndex, validFileIndexSize);
    }

    void setProcessedValues(int rowIndex, int numSamples) {
        ((ProgressLoggerConsoleFrame)this.logger).setProcessedValues(rowIndex, numSamples);
    }

    void logRectInfo(String id, Rectangle rect, ReaderSourceTranslated source, boolean isMarked, double density) {
        ReaderLogMessage.logRectInfo(this.logger, id, rect, source);
        ReaderLogMessage.logMark(this.logger, isMarked, density);
    }

    void logRectInfo(String id, Rectangle rect, ReaderSourceTranslated source, File imageFile) {
        ReaderLogMessage.logRectInfo(this.logger, id, rect, source);
        ReaderLogMessage.logCropImage(this.logger, imageFile.getAbsolutePath());
    }

    void logInvalidMark(int rowIndex, final String filename, String qid, int size) {
        ReaderLogMessage.logInvalidMark(this.logger, rowIndex, filename, qid, size);
        if (this.logger instanceof Component) {
            new Thread(){

                public void run() {
                    JOptionPane.showMessageDialog((Component)ReadingProcessView.this.logger, new Object[]{"\u629e\u4e00\u9078\u629e\u578b\u8a2d\u554f\u3067\u8907\u6570\u306e\u30de\u30fc\u30af\u304c\u3055\u308c\u3066\u3044\u307e\u3059\uff0e", "(\u30de\u30fc\u30af\u30df\u30b9\u3067\u306f\u306a\u304f\uff0c\u30da\u30fc\u30b8\u9806\u5e8f\u9593\u9055\u3044\u306e\u53ef\u80fd\u6027\u3082\u3042\u308a\u307e\u3059\u306e\u3067\uff0c", " \u5143\u30d5\u30a1\u30a4\u30eb\u753b\u50cf\u306e\u5185\u5bb9\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044)", filename}, "\u30a8\u30e9\u30fc", 2);
                }
            }.start();
        }
    }

    void setWaitCursor() {
        this.progressBar.setValue(0);
        ((Component)this.logger).setCursor(Cursor.getPredefinedCursor(3));
    }

    void setDefaultCursor() {
        ((Component)this.logger).setCursor(Cursor.getPredefinedCursor(0));
    }

    void setPDFFileInfo(File pdffile, QuestionnaireSchema qSchema) {
        if (this.logger instanceof ProgressLoggerConsoleFrame) {
            ((ProgressLoggerConsoleFrame)this.logger).setPDFFile(pdffile, qSchema.getNumberOfPages(), qSchema.getNumberOfColumns());
        }
    }

    void throwFileNumberError(int numFiles, int numPages) throws TranslatorException {
        throw new TranslatorException(new String[]{"\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u6570\u306b\u904e\u4e0d\u8db3\u304c\u3042\u308a\u307e\u3059\uff0e\u4fee\u6b63\u3057\u3066\u304b\u3089\u518d\u5b9f\u884c\u3057\u3066\u304f\u3060\u3055\u3044\uff0e", "\u7dcf\u30d5\u30a1\u30a4\u30eb\u6570: " + numFiles + " (\u6709\u52b9\u30b5\u30f3\u30d7\u30eb\u6570\uff1a" + numFiles / numPages + ")", "\u4e00\u4eba\u5206\u306e\u30da\u30fc\u30b8\u6570: " + numPages + " \u30da\u30fc\u30b8", "  (" + (numPages - numFiles % numPages) + "\u500b\u306e\u30d5\u30a1\u30a4\u30eb\u4e0d\u8db3?)"});
    }

    void throwPageError(int errors) throws TranslatorException {
        throw new TranslatorException("\u4e0a\u4e0b\u306e\u300c\u25a0\u300d\u306e\u5217\u3092\u6b63\u3057\u304f\u8a8d\u8b58\u3067\u304d\u306a\u3044\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u304c " + errors + "\u500b\u3042\u308a\u307e\u3059\uff0e\u4fee\u6b63\u3057\u3066\u304b\u3089\u518d\u5b9f\u884c\u3057\u3066\u304f\u3060\u3055\u3044\uff0e");
    }

    void showResult(int errors, int warns, int numFiles, int numValidFiles, int numPages, int numSamples) {
        if (this.progressBar != null) {
            String status = null;
            if (errors == 0 && warns == 0 && numValidFiles > 0) {
                status = "\u7d42\u4e86";
                this.progressBar.setString(String.valueOf(status) + ": found " + numFiles + " files : processed " + numValidFiles + " files = " + numSamples + " samples x " + numPages + " page(s)");
            } else if (errors == -1) {
                status = "\u30a8\u30e9\u30fc";
                this.progressBar.setString("");
            } else {
                if (errors > 0) {
                    status = "\u30a8\u30e9\u30fc\u7d42\u4e86\uff1a" + errors + "\u500b\u306e\u30a8\u30e9\u30fc";
                } else if (warns > 0) {
                    status = "\u8b66\u544a\u7d42\u4e86\uff1a" + warns + "\u500b\u306e\u8b66\u544a";
                }
                this.progressBar.setString(String.valueOf(status) + ": found " + numFiles + " files : processed " + numValidFiles + " files ... " + numSamples + " samples x " + numPages + " page(s)");
            }
        }
    }

    int showFileSaveErrorDialog(IOException ex, File file) {
        return JOptionPane.showConfirmDialog((Component)this.logger, new String[]{"\u30d5\u30a1\u30a4\u30eb\u304c\u4fdd\u5b58\u3067\u304d\u307e\u305b\u3093\uff0e", ex.getLocalizedMessage(), file.getAbsolutePath(), "....\u4fdd\u5b58\u3092\u3084\u308a\u76f4\u3057\u307e\u3059\u304b?"}, "File Error", 0);
    }

    public void setSucceed() {
        ((LoggerConsoleFrame)this.logger).setSucceed();
    }
}

