/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

public class ColorSpace {
    private boolean hasICCProfile;
    private byte[] iccProfile;
    private int numComponents;
    public static final int DEVICE_UNKNOWN = -1;
    public static final int DEVICE_GRAY = 1;
    public static final int DEVICE_RGB = 2;
    public static final int DEVICE_CMYK = 3;
    protected int currentColorSpace = -1;

    public ColorSpace(int theColorSpace) {
        this.currentColorSpace = theColorSpace;
        this.hasICCProfile = false;
        this.numComponents = this.calculateNumComponents();
    }

    private int calculateNumComponents() {
        if (this.currentColorSpace == 1) {
            return 1;
        }
        if (this.currentColorSpace == 2) {
            return 3;
        }
        if (this.currentColorSpace == 3) {
            return 4;
        }
        return 0;
    }

    public void setColorSpace(int theColorSpace) {
        this.currentColorSpace = theColorSpace;
        this.numComponents = this.calculateNumComponents();
    }

    public boolean hasICCProfile() {
        return this.hasICCProfile;
    }

    public byte[] getICCProfile() {
        if (this.hasICCProfile) {
            return this.iccProfile;
        }
        return new byte[0];
    }

    public void setICCProfile(byte[] iccProfile) {
        this.iccProfile = iccProfile;
        this.hasICCProfile = true;
    }

    public int getColorSpace() {
        return this.currentColorSpace;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public String getColorSpacePDFString() {
        if (this.currentColorSpace == 2) {
            return "DeviceRGB";
        }
        if (this.currentColorSpace == 3) {
            return "DeviceCMYK";
        }
        if (this.currentColorSpace == 1) {
            return "DeviceGray";
        }
        return "DeviceRGB";
    }
}

