/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.net.URL;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.analyser.ImageReader;
import org.apache.fop.image.analyser.ImageReaderFactory;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFFilter;

public abstract class AbstractFopImage
implements FopImage {
    protected boolean m_invertImage = false;
    protected int m_width = 0;
    protected int m_height = 0;
    protected URL m_href = null;
    protected ImageReader m_imageReader = null;
    protected ColorSpace m_colorSpace = null;
    protected int m_bitsPerPixel = 0;
    protected byte[] m_bitmaps = null;
    protected int m_bitmapsSize = 0;
    protected boolean m_isTransparent = false;
    protected PDFColor m_transparentColor = null;
    protected PDFFilter m_compressionType = null;

    public AbstractFopImage(URL href) throws FopImageException {
        this.m_href = href;
        try {
            this.m_imageReader = ImageReaderFactory.Make(this.m_href.toExternalForm(), this.m_href.openStream());
        }
        catch (Exception e) {
            throw new FopImageException(e.getMessage());
        }
        this.m_width = this.m_imageReader.getWidth();
        this.m_height = this.m_imageReader.getHeight();
    }

    public AbstractFopImage(URL href, ImageReader imgReader) throws FopImageException {
        this.m_href = href;
        this.m_imageReader = imgReader;
        this.m_width = this.m_imageReader.getWidth();
        this.m_height = this.m_imageReader.getHeight();
    }

    protected abstract void loadImage() throws FopImageException;

    public boolean invertImage() {
        return this.m_invertImage;
    }

    public String getURL() {
        return this.m_href.toString();
    }

    public int getWidth() throws FopImageException {
        AbstractFopImage abstractFopImage = this;
        synchronized (abstractFopImage) {
            if (this.m_width == 0) {
                this.loadImage();
            }
        }
        return this.m_width;
    }

    public int getHeight() throws FopImageException {
        AbstractFopImage abstractFopImage = this;
        synchronized (abstractFopImage) {
            if (this.m_height == 0) {
                this.loadImage();
            }
        }
        return this.m_height;
    }

    public ColorSpace getColorSpace() throws FopImageException {
        AbstractFopImage abstractFopImage = this;
        synchronized (abstractFopImage) {
            if (this.m_colorSpace == null) {
                this.loadImage();
            }
        }
        return this.m_colorSpace;
    }

    public int getBitsPerPixel() throws FopImageException {
        AbstractFopImage abstractFopImage = this;
        synchronized (abstractFopImage) {
            if (this.m_bitsPerPixel == 0) {
                this.loadImage();
            }
        }
        return this.m_bitsPerPixel;
    }

    public boolean isTransparent() throws FopImageException {
        return this.m_isTransparent;
    }

    public PDFColor getTransparentColor() throws FopImageException {
        return this.m_transparentColor;
    }

    public byte[] getBitmaps() throws FopImageException {
        AbstractFopImage abstractFopImage = this;
        synchronized (abstractFopImage) {
            if (this.m_bitmaps == null) {
                this.loadImage();
            }
        }
        return this.m_bitmaps;
    }

    public int getBitmapsSize() throws FopImageException {
        AbstractFopImage abstractFopImage = this;
        synchronized (abstractFopImage) {
            if (this.m_bitmapsSize == 0) {
                this.loadImage();
            }
        }
        return this.m_bitmapsSize;
    }

    public byte[] getRessourceBytes() throws FopImageException {
        return null;
    }

    public int getRessourceBytesSize() throws FopImageException {
        return 0;
    }

    public PDFFilter getPDFFilter() throws FopImageException {
        AbstractFopImage abstractFopImage = this;
        synchronized (abstractFopImage) {
            if (this.m_bitsPerPixel == 0) {
                this.loadImage();
            }
        }
        return this.m_compressionType;
    }

    public void close() {
        AbstractFopImage abstractFopImage = this;
        synchronized (abstractFopImage) {
            this.m_bitmaps = null;
            this.m_bitmapsSize = 0;
        }
    }
}

