/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.fop.image.analyser.AbstractImageReader;

public class PNGReader
extends AbstractImageReader {
    protected static final int PNG_SIG_LENGTH = 24;
    protected byte[] header;

    public boolean verifySignature(String uri, BufferedInputStream fis) throws IOException {
        boolean supported;
        this.imageStream = fis;
        this.setDefaultHeader();
        boolean bl = supported = this.header[0] == -119 && this.header[1] == 80 && this.header[2] == 78 && this.header[3] == 71 && this.header[4] == 13 && this.header[5] == 10 && this.header[6] == 26 && this.header[7] == 10;
        if (supported) {
            this.setDimension();
            return true;
        }
        return false;
    }

    public String getMimeType() {
        return "image/png";
    }

    protected void setDimension() {
        int byte1 = this.header[16] & 0xFF;
        int byte2 = this.header[17] & 0xFF;
        int byte3 = this.header[18] & 0xFF;
        int byte4 = this.header[19] & 0xFF;
        long l = byte1 << 24 | byte2 << 16 | byte3 << 8 | byte4;
        this.width = (int)l;
        byte1 = this.header[20] & 0xFF;
        byte2 = this.header[21] & 0xFF;
        byte3 = this.header[22] & 0xFF;
        byte4 = this.header[23] & 0xFF;
        l = byte1 << 24 | byte2 << 16 | byte3 << 8 | byte4;
        this.height = (int)l;
    }

    protected void setDefaultHeader() throws IOException {
        this.header = new byte[24];
        try {
            this.imageStream.mark(25);
            this.imageStream.read(this.header);
            this.imageStream.reset();
        }
        catch (IOException ex) {
            try {
                this.imageStream.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
    }
}

