/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.fop.apps.FOPException;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.svg.PDFGraphics2D;

public class PDFDocumentGraphics2D
extends PDFGraphics2D {
    OutputStream stream;
    PDFStream pdfStream;
    int width;
    int height;
    FontInfo fontInfo = null;

    public PDFDocumentGraphics2D(boolean textAsShapes, OutputStream stream, int width, int height) throws FOPException {
        super(textAsShapes);
        if (!textAsShapes) {
            this.fontInfo = new FontInfo();
            FontSetup.setup(this.fontInfo);
            try {
                this.fontState = new FontState(this.fontInfo, "Helvetica", "normal", "normal", 12, 0);
            }
            catch (FOPException fOPException) {
                // empty catch block
            }
        }
        this.standalone = true;
        this.stream = stream;
        this.pdfDoc = new PDFDocument();
        this.pdfDoc.setProducer("FOP SVG Renderer");
        this.pdfStream = this.pdfDoc.makeStream();
        this.width = width;
        this.height = height;
        this.currentFontName = "";
        this.currentFontSize = 0;
        this.currentYPosition = 0;
        this.currentXPosition = 0;
        this.currentStream.write("1 0 0 -1 0 " + height + " cm\n");
    }

    public FontState getFontState() {
        return this.fontState;
    }

    public PDFDocument getPDFDocument() {
        return this.pdfDoc;
    }

    public void setSVGDimension(float w, float h) {
        this.currentStream.write(PDFNumber.doubleOut((float)this.width / w) + " 0 0 " + PDFNumber.doubleOut((float)this.height / h) + " 0 0 cm\n");
    }

    public void setBackgroundColor(Color col) {
        Color c = col;
        this.currentColour = new PDFColor(c.getRed(), c.getGreen(), c.getBlue());
        this.currentStream.write("q\n");
        this.currentStream.write(this.currentColour.getColorSpaceOut(true));
        this.currentStream.write("0 0 " + this.width + " " + this.height + " re\n");
        this.currentStream.write("f\n");
        this.currentStream.write("Q\n");
    }

    public void finish() throws IOException {
        this.pdfStream.add(this.getString());
        PDFResources pdfResources = this.pdfDoc.getResources();
        PDFPage currentPage = this.pdfDoc.makePage(pdfResources, this.pdfStream, this.width, this.height, null);
        if (this.currentAnnotList != null) {
            currentPage.setAnnotList(this.currentAnnotList);
        }
        if (this.fontInfo != null) {
            FontSetup.addToResources(this.pdfDoc, this.fontInfo);
        }
        this.pdfDoc.outputHeader(this.stream);
        this.pdfDoc.output(this.stream);
        this.pdfDoc.outputTrailer(this.stream);
    }

    public void setGraphicContext(GraphicContext c) {
        this.gc = c;
    }

    public PDFDocumentGraphics2D(PDFDocumentGraphics2D g) {
        super(g);
    }

    public Graphics create() {
        return new PDFDocumentGraphics2D(this);
    }

    public void drawString(String s, float x, float y) {
        if (this.textAsShapes) {
            Font font = super.getFont();
            FontRenderContext frc = super.getFontRenderContext();
            GlyphVector gv = font.createGlyphVector(frc, s);
            Shape glyphOutline = gv.getOutline(x, y);
            super.fill(glyphOutline);
        } else {
            super.drawString(s, x, y);
        }
    }
}

