/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeUpdateHandler;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.SVGCSSEngine;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGFitToViewBox;

public abstract class AbstractGraphicsNodeBridge
extends AbstractSVGBridge
implements SVGContext,
BridgeUpdateHandler,
GraphicsNodeBridge,
ErrorConstants {
    protected Element e;
    protected GraphicsNode node;
    protected BridgeContext ctx;

    protected AbstractGraphicsNodeBridge() {
    }

    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e) {
        if (!SVGUtilities.matchUserAgent(e, ctx.getUserAgent())) {
            return null;
        }
        GraphicsNode node = this.instantiateGraphicsNode();
        String s = e.getAttributeNS(null, "transform");
        if (s.length() != 0) {
            node.setTransform(SVGUtilities.convertTransform(e, "transform", s));
        }
        node.setVisible(CSSUtilities.convertVisibility(e));
        return node;
    }

    protected abstract GraphicsNode instantiateGraphicsNode();

    public void buildGraphicsNode(BridgeContext ctx, Element e, GraphicsNode node) {
        node.setComposite(CSSUtilities.convertOpacity(e));
        node.setFilter(CSSUtilities.convertFilter(e, node, ctx));
        node.setMask(CSSUtilities.convertMask(e, node, ctx));
        node.setClip(CSSUtilities.convertClipPath(e, node, ctx));
        node.setPointerEventType(CSSUtilities.convertPointerEvents(e));
        if (ctx.isDynamic()) {
            this.initializeDynamicSupport(ctx, e, node);
        }
        SVGUtilities.bridgeChildren(ctx, e);
    }

    public boolean getDisplay(Element e) {
        return CSSUtilities.convertDisplay(e);
    }

    protected void initializeDynamicSupport(BridgeContext ctx, Element e, GraphicsNode node) {
        this.e = e;
        this.node = node;
        this.ctx = ctx;
        ctx.bind(e, node);
        ((SVGOMElement)e).setSVGContext(this);
    }

    public void handleDOMAttrModifiedEvent(MutationEvent evt) {
        String attrName = evt.getAttrName();
        if (attrName.equals("transform")) {
            String s = evt.getNewValue();
            AffineTransform at = GraphicsNode.IDENTITY;
            if (s.length() != 0) {
                at = SVGUtilities.convertTransform(this.e, "transform", s);
            }
            this.node.setTransform(at);
            this.handleGeometryChanged();
        }
    }

    protected void handleGeometryChanged() {
        this.node.setFilter(CSSUtilities.convertFilter(this.e, this.node, this.ctx));
        this.node.setMask(CSSUtilities.convertMask(this.e, this.node, this.ctx));
        this.node.setClip(CSSUtilities.convertClipPath(this.e, this.node, this.ctx));
    }

    public void handleDOMNodeInsertedEvent(MutationEvent evt) {
    }

    public void handleDOMNodeRemovedEvent(MutationEvent evt) {
        CompositeGraphicsNode gn = this.node.getParent();
        gn.remove(this.node);
        AbstractGraphicsNodeBridge.disposeTree(this.e);
    }

    public void handleDOMCharacterDataModified(MutationEvent evt) {
    }

    public void dispose() {
        SVGOMElement elt = (SVGOMElement)this.e;
        elt.setSVGContext(null);
        this.ctx.unbind(this.e);
    }

    static void disposeTree(Node node) {
        SVGOMElement elt;
        BridgeUpdateHandler h;
        if (node instanceof SVGOMElement && (h = (BridgeUpdateHandler)((Object)(elt = (SVGOMElement)node).getSVGContext())) != null) {
            h.dispose();
        }
        Node n = node.getFirstChild();
        while (n != null) {
            AbstractGraphicsNodeBridge.disposeTree(n);
            n = n.getNextSibling();
        }
    }

    public void handleCSSEngineEvent(CSSEngineEvent evt) {
        try {
            int[] properties = evt.getProperties();
            int i = 0;
            while (i < properties.length) {
                this.handleCSSPropertyChanged(properties[i]);
                ++i;
            }
        }
        catch (Exception ex) {
            this.ctx.getUserAgent().displayError(ex);
        }
    }

    protected void handleCSSPropertyChanged(int property) {
        switch (property) {
            case 56: {
                this.node.setVisible(CSSUtilities.convertVisibility(this.e));
                break;
            }
            case 38: {
                this.node.setComposite(CSSUtilities.convertOpacity(this.e));
                break;
            }
            case 18: {
                this.node.setFilter(CSSUtilities.convertFilter(this.e, this.node, this.ctx));
                break;
            }
            case 37: {
                this.node.setMask(CSSUtilities.convertMask(this.e, this.node, this.ctx));
                break;
            }
            case 3: {
                this.node.setClip(CSSUtilities.convertClipPath(this.e, this.node, this.ctx));
                break;
            }
            case 40: {
                this.node.setPointerEventType(CSSUtilities.convertPointerEvents(this.e));
            }
        }
    }

    public float getPixelUnitToMillimeter() {
        return this.ctx.getUserAgent().getPixelUnitToMillimeter();
    }

    public float getPixelToMM() {
        return this.getPixelUnitToMillimeter();
    }

    public Rectangle2D getBBox() {
        return this.node.getPrimitiveBounds();
    }

    public AffineTransform getCTM() {
        GraphicsNode gn = this.node;
        AffineTransform ctm = new AffineTransform();
        Element elt = this.e;
        while (elt != null) {
            AffineTransform at = gn.getTransform();
            if (at != null) {
                ctm.preConcatenate(at);
            }
            elt = SVGCSSEngine.getParentCSSStylableElement(elt);
            gn = gn.getParent();
            if (elt instanceof SVGFitToViewBox) break;
        }
        return ctm;
    }

    public AffineTransform getGlobalTransform() {
        return this.node.getGlobalTransform();
    }

    public float getViewportWidth() {
        return this.ctx.getBlockWidth(this.e);
    }

    public float getViewportHeight() {
        return this.ctx.getBlockHeight(this.e);
    }

    public float getFontSize() {
        return CSSUtilities.getComputedStyle(this.e, 22).getFloatValue();
    }
}

