/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.batik.script.rhino.RhinoInterpreter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

class EventTargetWrapper
extends NativeJavaObject {
    private RhinoInterpreter interpreter;
    private NativeJavaMethod methodadd;
    private NativeJavaMethod methodremove;
    private HashMap listenerMap;
    private static final String ADD_NAME = "addEventListener";
    private static final String REMOVE_NAME = "removeEventListener";
    private static final Class[] ARGS_TYPE;
    private static final String NAME = "name";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$mozilla$javascript$Function;
    static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;
    static /* synthetic */ Class class$org$w3c$dom$events$EventListener;

    EventTargetWrapper(Scriptable scope, EventTarget object, RhinoInterpreter interp) {
        super(scope, (Object)object, (Class)null);
        this.interpreter = interp;
        try {
            this.methodadd = new RhinoNativeJavaMethod(object.getClass().getMethod(ADD_NAME, ARGS_TYPE), ADD_NAME);
            this.methodremove = new RhinoNativeJavaMethod(object.getClass().getMethod(REMOVE_NAME, ARGS_TYPE), REMOVE_NAME);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
    }

    public Object get(String name, Scriptable start) {
        Object method = null;
        method = name.equals(ADD_NAME) ? this.methodadd : (name.equals(REMOVE_NAME) ? this.methodremove : super.get(name, start));
        return method;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ADD_NAME = ADD_NAME;
        REMOVE_NAME = REMOVE_NAME;
        ARGS_TYPE = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$w3c$dom$events$EventListener == null ? (class$org$w3c$dom$events$EventListener = EventTargetWrapper.class$("org.w3c.dom.events.EventListener")) : class$org$w3c$dom$events$EventListener, Boolean.TYPE};
        NAME = NAME;
    }

    class RhinoNativeJavaMethod
    extends NativeJavaMethod {
        RhinoNativeJavaMethod(Method method, String name) {
            super(method, name);
        }

        public Object call(Context ctx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
            if (args[1] instanceof Function) {
                if (this.get(EventTargetWrapper.NAME, (Scriptable)this).equals(EventTargetWrapper.ADD_NAME)) {
                    FunctionEventListener evtListener = new FunctionEventListener((Function)args[1]);
                    if (EventTargetWrapper.this.listenerMap == null) {
                        EventTargetWrapper.this.listenerMap = new HashMap(2);
                    }
                    EventTargetWrapper.this.listenerMap.put(args[1], evtListener);
                    Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = EventTargetWrapper.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function, Boolean.TYPE};
                    int i = 0;
                    while (i < args.length) {
                        args[i] = NativeJavaObject.coerceType((Class)paramTypes[i], (Object)args[i]);
                        ++i;
                    }
                    ((EventTarget)EventTargetWrapper.this.unwrap()).addEventListener((String)args[0], evtListener, (Boolean)args[2]);
                    return Undefined.instance;
                }
                if (EventTargetWrapper.this.listenerMap != null) {
                    Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = EventTargetWrapper.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function, Boolean.TYPE};
                    int i = 0;
                    while (i < args.length) {
                        args[i] = NativeJavaObject.coerceType((Class)paramTypes[i], (Object)args[i]);
                        ++i;
                    }
                    ((EventTarget)EventTargetWrapper.this.unwrap()).removeEventListener((String)args[0], (EventListener)EventTargetWrapper.this.listenerMap.remove(args[1]), (Boolean)args[2]);
                }
                return Undefined.instance;
            }
            if (args[1] instanceof NativeObject) {
                if (this.get(EventTargetWrapper.NAME, (Scriptable)this).equals(EventTargetWrapper.ADD_NAME)) {
                    HandleEventListener evtListener = new HandleEventListener((Scriptable)args[1]);
                    if (EventTargetWrapper.this.listenerMap == null) {
                        EventTargetWrapper.this.listenerMap = new HashMap(2);
                    }
                    EventTargetWrapper.this.listenerMap.put(args[1], evtListener);
                    Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = EventTargetWrapper.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, Boolean.TYPE};
                    int i = 0;
                    while (i < args.length) {
                        args[i] = NativeJavaObject.coerceType((Class)paramTypes[i], (Object)args[i]);
                        ++i;
                    }
                    ((EventTarget)EventTargetWrapper.this.unwrap()).addEventListener((String)args[0], evtListener, (Boolean)args[2]);
                    return Undefined.instance;
                }
                if (EventTargetWrapper.this.listenerMap != null) {
                    Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = EventTargetWrapper.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, Boolean.TYPE};
                    int i = 0;
                    while (i < args.length) {
                        args[i] = NativeJavaObject.coerceType((Class)paramTypes[i], (Object)args[i]);
                        ++i;
                    }
                    ((EventTarget)EventTargetWrapper.this.unwrap()).removeEventListener((String)args[0], (EventListener)EventTargetWrapper.this.listenerMap.remove(args[1]), (Boolean)args[2]);
                }
                return Undefined.instance;
            }
            return super.call(ctx, scope, thisObj, args);
        }
    }

    class HandleEventListener
    implements EventListener {
        private static final String HANDLE_EVENT = "handleEvent";
        private Scriptable scriptable;
        private Object[] array = new Object[1];

        HandleEventListener(Scriptable s) {
            this.scriptable = s;
        }

        public void handleEvent(Event evt) {
            try {
                this.array[0] = evt;
                ScriptableObject.callMethod((Scriptable)this.scriptable, (String)HANDLE_EVENT, (Object[])this.array);
            }
            catch (JavaScriptException e) {
                throw new WrappedException((Throwable)e);
            }
        }

        static {
            HANDLE_EVENT = HANDLE_EVENT;
        }
    }

    class FunctionEventListener
    implements EventListener {
        private Function function;

        FunctionEventListener(Function f) {
            this.function = f;
        }

        public void handleEvent(Event evt) {
            try {
                EventTargetWrapper.this.interpreter.callHandler(this.function, evt);
            }
            catch (JavaScriptException e) {
                throw new WrappedException((Throwable)e);
            }
        }
    }
}

