/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.DefaultScriptSecurity;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.ExternalResourceSecurity;
import org.apache.batik.bridge.RelaxedExternalResourceSecurity;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.AWTEventDispatcher;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.JGVTComponent;
import org.apache.batik.swing.svg.GVTTreeBuilder;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.JSVGComponent;
import org.apache.batik.swing.svg.LinkActivationEvent;
import org.apache.batik.swing.svg.LinkActivationListener;
import org.apache.batik.swing.svg.Messages;
import org.apache.batik.swing.svg.SVGDocumentLoader;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.apache.batik.swing.svg.SVGLoadEventDispatcher;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherEvent;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherListener;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.RunnableQueue;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class JSVGComponent
extends JGVTComponent {
    public static final int AUTODETECT = 0;
    public static final int ALWAYS_DYNAMIC = 1;
    public static final int ALWAYS_STATIC = 2;
    protected SVGDocumentLoader documentLoader;
    protected SVGDocumentLoader nextDocumentLoader;
    protected DocumentLoader loader;
    protected GVTTreeBuilder gvtTreeBuilder;
    protected GVTTreeBuilder nextGVTTreeBuilder;
    protected SVGLoadEventDispatcher svgLoadEventDispatcher;
    protected UpdateManager updateManager;
    protected UpdateManager nextUpdateManager;
    protected SVGDocument svgDocument;
    protected List svgDocumentLoaderListeners = new LinkedList();
    protected List gvtTreeBuilderListeners = new LinkedList();
    protected List svgLoadEventDispatcherListeners = new LinkedList();
    protected List linkActivationListeners = new LinkedList();
    protected List updateManagerListeners = new LinkedList();
    protected UserAgent userAgent;
    protected SVGUserAgent svgUserAgent;
    protected BridgeContext bridgeContext;
    protected String fragmentIdentifier;
    protected boolean isDynamicDocument;
    protected int documentState;
    protected static final Set FEATURES;
    private static final int SPLIT_THRESHOLD = 128;

    public JSVGComponent() {
        this(null, false, false);
    }

    public JSVGComponent(SVGUserAgent ua, boolean eventsEnabled, boolean selectableText) {
        super(eventsEnabled, selectableText);
        this.svgUserAgent = ua;
        this.userAgent = new BridgeUserAgentWrapper(this.createUserAgent());
        this.addSVGDocumentLoaderListener((SVGListener)this.listener);
        this.addGVTTreeBuilderListener((SVGListener)this.listener);
        this.addSVGLoadEventDispatcherListener((SVGListener)this.listener);
    }

    public boolean isDynamic() {
        return this.isDynamicDocument;
    }

    public void setDocumentState(int state) {
        this.documentState = state;
    }

    public UpdateManager getUpdateManager() {
        if (this.svgLoadEventDispatcher != null) {
            return this.svgLoadEventDispatcher.getUpdateManager();
        }
        if (this.nextUpdateManager != null) {
            return this.nextUpdateManager;
        }
        return this.updateManager;
    }

    public void resumeProcessing() {
        if (this.updateManager != null) {
            this.updateManager.resume();
        }
    }

    public void suspendProcessing() {
        if (this.updateManager != null) {
            this.updateManager.suspend();
        }
    }

    public void stopProcessing() {
        this.nextDocumentLoader = null;
        this.nextGVTTreeBuilder = null;
        if (this.documentLoader != null) {
            this.documentLoader.interrupt();
        } else if (this.gvtTreeBuilder != null) {
            this.gvtTreeBuilder.interrupt();
        } else if (this.svgLoadEventDispatcher != null) {
            this.svgLoadEventDispatcher.interrupt();
        } else if (this.nextUpdateManager != null) {
            this.nextUpdateManager.interrupt();
            this.nextUpdateManager = null;
        } else if (this.updateManager != null) {
            this.updateManager.interrupt();
        } else {
            super.stopProcessing();
        }
    }

    public void loadSVGDocument(String url) {
        this.stopProcessing();
        String oldURI = null;
        if (this.svgDocument != null) {
            oldURI = this.svgDocument.getURL();
        }
        ParsedURL newURI = null;
        newURI = new ParsedURL(oldURI, url);
        url = newURI.toString();
        this.fragmentIdentifier = newURI.getRef();
        this.loader = new DocumentLoader(this.userAgent);
        this.nextDocumentLoader = new SVGDocumentLoader(url, this.loader);
        this.nextDocumentLoader.setPriority(1);
        Iterator it = this.svgDocumentLoaderListeners.iterator();
        while (it.hasNext()) {
            this.nextDocumentLoader.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)it.next());
        }
        if (this.documentLoader == null && this.gvtTreeBuilder == null && this.gvtTreeRenderer == null && this.svgLoadEventDispatcher == null && this.updateManager == null) {
            this.startDocumentLoader();
        }
    }

    private void startDocumentLoader() {
        this.documentLoader = this.nextDocumentLoader;
        this.nextDocumentLoader = null;
        this.documentLoader.start();
    }

    public void setSVGDocument(SVGDocument doc) {
        this.stopProcessing();
        if (!(doc.getImplementation() instanceof SVGDOMImplementation)) {
            throw new IllegalArgumentException("Invalid DOM implementation.");
        }
        switch (this.documentState) {
            case 2: {
                this.isDynamicDocument = false;
                break;
            }
            case 1: {
                this.isDynamicDocument = true;
                break;
            }
            case 0: {
                this.isDynamicDocument = UpdateManager.isDynamicDocument(doc);
            }
        }
        this.svgDocument = doc;
        Element root = doc.getDocumentElement();
        String znp = root.getAttributeNS(null, "zoomAndPan");
        boolean bl = this.disableInteractions = !znp.equals("magnify");
        if (this.bridgeContext != null) {
            this.bridgeContext.dispose();
        }
        this.bridgeContext = this.createBridgeContext();
        this.nextGVTTreeBuilder = new GVTTreeBuilder(doc, this.bridgeContext);
        this.nextGVTTreeBuilder.setPriority(1);
        Iterator it = this.gvtTreeBuilderListeners.iterator();
        while (it.hasNext()) {
            this.nextGVTTreeBuilder.addGVTTreeBuilderListener((GVTTreeBuilderListener)it.next());
        }
        this.releaseRenderingReferences();
        this.initializeEventHandling();
        if (this.gvtTreeBuilder == null && this.documentLoader == null && this.gvtTreeRenderer == null && this.svgLoadEventDispatcher == null && this.updateManager == null) {
            this.startGVTTreeBuilder();
        }
    }

    private void startGVTTreeBuilder() {
        this.gvtTreeBuilder = this.nextGVTTreeBuilder;
        this.nextGVTTreeBuilder = null;
        this.gvtTreeBuilder.start();
    }

    public SVGDocument getSVGDocument() {
        return this.svgDocument;
    }

    public Dimension2D getSVGDocumentSize() {
        return this.bridgeContext.getDocumentSize();
    }

    public String getFragmentIdentifier() {
        return this.fragmentIdentifier;
    }

    public void setFragmentIdentifier(String fi) {
        this.fragmentIdentifier = fi;
        this.computeRenderingTransform();
    }

    public void flushImageCache() {
        ImageTagRegistry reg = ImageTagRegistry.getRegistry();
        reg.flushCache();
    }

    protected BridgeContext createBridgeContext() {
        if (this.loader == null) {
            this.loader = new DocumentLoader(this.userAgent);
        }
        BridgeContext result = new BridgeContext(this.userAgent, this.loader);
        result.setDynamic(true);
        return result;
    }

    protected void startSVGLoadEventDispatcher(GraphicsNode root) {
        UpdateManager um = new UpdateManager(this.bridgeContext, root, this.svgDocument);
        this.svgLoadEventDispatcher = new SVGLoadEventDispatcher(root, this.svgDocument, this.bridgeContext, um);
        Iterator it = this.svgLoadEventDispatcherListeners.iterator();
        while (it.hasNext()) {
            this.svgLoadEventDispatcher.addSVGLoadEventDispatcherListener((SVGLoadEventDispatcherListener)it.next());
        }
        this.svgLoadEventDispatcher.start();
    }

    protected ImageRenderer createImageRenderer() {
        if (this.isDynamicDocument) {
            return this.rendererFactory.createDynamicImageRenderer();
        }
        return this.rendererFactory.createStaticImageRenderer();
    }

    protected void computeRenderingTransform() {
        try {
            if (this.svgDocument != null) {
                SVGSVGElement elt = this.svgDocument.getRootElement();
                Dimension d = this.getSize();
                this.setRenderingTransform(ViewBox.getViewTransform(this.fragmentIdentifier, elt, d.width, d.height));
                this.initialTransform = this.renderingTransform;
            }
        }
        catch (BridgeException e) {
            this.userAgent.displayError(e);
        }
    }

    protected void updateRenderingTransform() {
        if (this.initialTransform == this.renderingTransform) {
            this.computeRenderingTransform();
        }
    }

    protected void renderGVTTree() {
        AffineTransform inv;
        if (!this.isDynamicDocument || this.updateManager == null || !this.updateManager.isRunning()) {
            super.renderGVTTree();
            return;
        }
        final Dimension d = this.getSize();
        if (this.gvtRoot == null || d.width <= 0 || d.height <= 0) {
            return;
        }
        try {
            inv = this.renderingTransform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new InternalError(e.getMessage());
        }
        final Shape s = inv.createTransformedShape(new Rectangle(0, 0, d.width, d.height));
        this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

            public void run() {
                JSVGComponent.this.paintingTransform = null;
                JSVGComponent.this.updateManager.updateRendering(JSVGComponent.this.renderingTransform, JSVGComponent.this.doubleBufferedRendering, s, d.width, d.height);
            }
        });
    }

    protected void handleException(Exception e) {
        this.userAgent.displayError(e);
    }

    public void addSVGDocumentLoaderListener(SVGDocumentLoaderListener l) {
        this.svgDocumentLoaderListeners.add(l);
    }

    public void removeSVGDocumentLoaderListener(SVGDocumentLoaderListener l) {
        this.svgDocumentLoaderListeners.remove(l);
    }

    public void addGVTTreeBuilderListener(GVTTreeBuilderListener l) {
        this.gvtTreeBuilderListeners.add(l);
    }

    public void removeGVTTreeBuilderListener(GVTTreeBuilderListener l) {
        this.gvtTreeBuilderListeners.remove(l);
    }

    public void addSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener l) {
        this.svgLoadEventDispatcherListeners.add(l);
    }

    public void removeSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener l) {
        this.svgLoadEventDispatcherListeners.remove(l);
    }

    public void addLinkActivationListener(LinkActivationListener l) {
        this.linkActivationListeners.add(l);
    }

    public void removeLinkActivationListener(LinkActivationListener l) {
        this.linkActivationListeners.remove(l);
    }

    public void addUpdateManagerListener(UpdateManagerListener l) {
        this.updateManagerListeners.add(l);
    }

    public void removeUpdateManagerListener(UpdateManagerListener l) {
        this.updateManagerListeners.remove(l);
    }

    public void showAlert(String message) {
        JOptionPane.showMessageDialog(this, Messages.formatMessage("script.alert", new Object[]{message}));
    }

    public String showPrompt(String message) {
        return JOptionPane.showInputDialog(this, (Object)Messages.formatMessage("script.prompt", new Object[]{message}));
    }

    public String showPrompt(String message, String defaultValue) {
        return (String)JOptionPane.showInputDialog(this, Messages.formatMessage("script.prompt", new Object[]{message}), null, -1, null, null, defaultValue);
    }

    public boolean showConfirm(String message) {
        return JOptionPane.showConfirmDialog(this, Messages.formatMessage("script.confirm", new Object[]{message}), "Confirm", 0) == 0;
    }

    protected JGVTComponent.Listener createListener() {
        return new SVGListener();
    }

    protected UserAgent createUserAgent() {
        return new BridgeUserAgent();
    }

    protected List mergeRectangles(List rects, int x1, int y1, int x2, int y2) {
        if (rects.size() <= 1) {
            return rects;
        }
        int w = x2 - x1;
        int h = y2 - y1;
        if (w < 128 && h < 128) {
            ArrayList<Rectangle> result = new ArrayList<Rectangle>();
            Iterator it = rects.iterator();
            Rectangle rect = (Rectangle)it.next();
            while (it.hasNext()) {
                Rectangle r = (Rectangle)it.next();
                rect.add(r);
            }
            result.add(rect);
            return result;
        }
        if (w < 128) {
            List<Rectangle> h1 = new ArrayList();
            List<Rectangle> h2 = new ArrayList<Rectangle>();
            int dy = h / 2;
            int av = y1 + dy;
            Iterator it = rects.iterator();
            while (it.hasNext()) {
                Rectangle r = (Rectangle)it.next();
                if (r.y < av) {
                    if (r.y + r.height > av) {
                        h2.add(new Rectangle(r.x, av, r.width, r.height + r.y - av));
                        r = new Rectangle(r.x, r.y, r.width, av - r.y);
                    }
                    h1.add(r);
                    continue;
                }
                h2.add(r);
            }
            h1 = this.mergeRectangles(h1, x1, y1, x2, av - 1);
            h2 = this.mergeRectangles(h2, x1, av, x2, y2);
            h1.addAll(h2);
            return h1;
        }
        if (h < 128) {
            List<Rectangle> w1 = new ArrayList();
            List<Rectangle> w2 = new ArrayList<Rectangle>();
            int dx = w / 2;
            int av = x1 + dx;
            Iterator it = rects.iterator();
            while (it.hasNext()) {
                Rectangle r = (Rectangle)it.next();
                if (r.x < av) {
                    if (r.x + r.width > av) {
                        w2.add(new Rectangle(av, r.y, r.width + r.x - av, r.height));
                        r = new Rectangle(r.x, r.y, av - r.x, r.height);
                    }
                    w1.add(r);
                    continue;
                }
                w2.add(r);
            }
            w1 = this.mergeRectangles(w1, x1, y1, av - 1, y2);
            w2 = this.mergeRectangles(w2, av, y1, x2, y2);
            w1.addAll(w2);
            return w1;
        }
        List<Rectangle> wh1 = new ArrayList();
        List<Rectangle> wh2 = new ArrayList();
        List<Rectangle> wh3 = new ArrayList<Rectangle>();
        List<Rectangle> wh4 = new ArrayList<Rectangle>();
        int dx = w / 2;
        int dy = h / 2;
        int wav = x1 + dx;
        int hav = y1 + dy;
        Iterator it = rects.iterator();
        while (it.hasNext()) {
            Rectangle r = (Rectangle)it.next();
            if (r.x < wav) {
                if (r.y < hav) {
                    boolean c2;
                    boolean c1 = r.x + r.width > wav;
                    boolean bl = c2 = r.y + r.height > hav;
                    if (c1 && c2) {
                        wh2.add(new Rectangle(wav, r.y, r.width + r.x - wav, hav - r.y));
                        wh3.add(new Rectangle(r.x, hav, wav - r.x, r.height + r.y - hav));
                        wh4.add(new Rectangle(wav, hav, r.width + r.x - wav, r.height + r.y - hav));
                        r = new Rectangle(r.x, r.y, wav - r.x, hav - r.y);
                    } else if (c1) {
                        wh2.add(new Rectangle(wav, r.y, r.width + r.x - wav, r.height));
                        r = new Rectangle(r.x, r.y, wav - r.x, r.height);
                    } else if (c2) {
                        wh3.add(new Rectangle(r.x, hav, r.width, r.height + r.y - hav));
                        r = new Rectangle(r.x, r.y, r.width, hav - r.y);
                    }
                    wh1.add(r);
                    continue;
                }
                if (r.x + r.width > wav) {
                    wh4.add(new Rectangle(wav, r.y, r.width + r.x - wav, r.height));
                    r = new Rectangle(r.x, r.y, wav - r.x, r.height);
                }
                wh3.add(r);
                continue;
            }
            if (r.y < hav) {
                if (r.y + r.height > hav) {
                    wh4.add(new Rectangle(r.x, hav, r.width, r.height + r.y - hav));
                    r = new Rectangle(r.x, r.y, r.width, hav - r.y);
                }
                wh2.add(r);
                continue;
            }
            wh4.add(r);
        }
        wh1 = this.mergeRectangles(wh1, x1, y1, wav - 1, hav - 1);
        wh2 = this.mergeRectangles(wh2, wav, y1, x2, y2);
        wh3 = this.mergeRectangles(wh3, x1, hav, wav - 1, y2);
        wh4 = this.mergeRectangles(wh4, wav, hav, x2, y2);
        wh1.addAll(wh2);
        wh1.addAll(wh3);
        wh1.addAll(wh4);
        return wh1;
    }

    static /* synthetic */ boolean access$1503(JSVGComponent x0, boolean x1) {
        x0.suspendInteractions = x1;
        return x0.suspendInteractions;
    }

    static /* synthetic */ boolean access$1601(JSVGComponent x0) {
        return x0.doubleBufferedRendering;
    }

    static /* synthetic */ BufferedImage access$1703(JSVGComponent x0, BufferedImage x1) {
        x0.image = x1;
        return x0.image;
    }

    static /* synthetic */ BufferedImage access$1803(JSVGComponent x0, BufferedImage x1) {
        x0.image = x1;
        return x0.image;
    }

    static /* synthetic */ boolean access$1901(JSVGComponent x0) {
        return x0.doubleBufferedRendering;
    }

    static /* synthetic */ boolean access$2003(JSVGComponent x0, boolean x1) {
        x0.suspendInteractions = x1;
        return x0.suspendInteractions;
    }

    static /* synthetic */ AWTEventDispatcher access$2101(JSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2201(JSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2301(JSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2401(JSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2501(JSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2601(JSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2701(JSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2801(JSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2901(JSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$3001(JSVGComponent x0) {
        return x0.eventDispatcher;
    }

    static {
        AUTODETECT = 0;
        ALWAYS_DYNAMIC = 1;
        ALWAYS_STATIC = 2;
        FEATURES = new HashSet();
        FEATURES.add("org.w3c.svg");
        FEATURES.add("org.w3c.svg.lang");
        FEATURES.add("org.w3c.svg.static");
        SPLIT_THRESHOLD = 128;
    }

    protected class BridgeUserAgent
    implements UserAgent {
        protected Map extensions = new HashMap();

        protected BridgeUserAgent() {
        }

        public Dimension2D getViewportSize() {
            return JSVGComponent.this.getSize();
        }

        public EventDispatcher getEventDispatcher() {
            return JSVGComponent.this.eventDispatcher;
        }

        public void displayError(String message) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.displayError(message);
            }
        }

        public void displayError(Exception ex) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.displayError(ex);
            }
        }

        public void displayMessage(String message) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.displayMessage(message);
            }
        }

        public void showAlert(String message) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.showAlert(message);
                return;
            }
            JSVGComponent.this.showAlert(message);
        }

        public String showPrompt(String message) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.showPrompt(message);
            }
            return JSVGComponent.this.showPrompt(message);
        }

        public String showPrompt(String message, String defaultValue) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.showPrompt(message, defaultValue);
            }
            return JSVGComponent.this.showPrompt(message, defaultValue);
        }

        public boolean showConfirm(String message) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.showConfirm(message);
            }
            return JSVGComponent.this.showConfirm(message);
        }

        public float getPixelUnitToMillimeter() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getPixelUnitToMillimeter();
            }
            return 0.26458332f;
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public float getMediumFontSize() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getMediumFontSize();
            }
            return 228.59999f / (72.0f * this.getPixelUnitToMillimeter());
        }

        public float getLighterFontWeight(float f) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getLighterFontWeight(f);
            }
            int weight = (int)((f + 50.0f) / 100.0f) * 100;
            switch (weight) {
                case 100: {
                    return 100.0f;
                }
                case 200: {
                    return 100.0f;
                }
                case 300: {
                    return 200.0f;
                }
                case 400: {
                    return 300.0f;
                }
                case 500: {
                    return 400.0f;
                }
                case 600: {
                    return 400.0f;
                }
                case 700: {
                    return 400.0f;
                }
                case 800: {
                    return 400.0f;
                }
                case 900: {
                    return 400.0f;
                }
            }
            throw new IllegalArgumentException("Bad Font Weight: " + f);
        }

        public float getBolderFontWeight(float f) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getBolderFontWeight(f);
            }
            int weight = (int)((f + 50.0f) / 100.0f) * 100;
            switch (weight) {
                case 100: {
                    return 600.0f;
                }
                case 200: {
                    return 600.0f;
                }
                case 300: {
                    return 600.0f;
                }
                case 400: {
                    return 600.0f;
                }
                case 500: {
                    return 600.0f;
                }
                case 600: {
                    return 700.0f;
                }
                case 700: {
                    return 800.0f;
                }
                case 800: {
                    return 900.0f;
                }
                case 900: {
                    return 900.0f;
                }
            }
            throw new IllegalArgumentException("Bad Font Weight: " + f);
        }

        public String getLanguages() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getLanguages();
            }
            return "en";
        }

        public String getUserStyleSheetURI() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getUserStyleSheetURI();
            }
            return null;
        }

        public void openLink(SVGAElement elt) {
            ParsedURL oldURI;
            String show = XLinkSupport.getXLinkShow(elt);
            String href = XLinkSupport.getXLinkHref(elt);
            if (show.equals("new")) {
                this.fireLinkActivatedEvent(elt, href);
                if (JSVGComponent.this.svgUserAgent != null) {
                    String oldURI2 = JSVGComponent.this.svgDocument.getURL();
                    ParsedURL newURI = null;
                    if (elt.getOwnerDocument() != JSVGComponent.this.svgDocument) {
                        SVGDocument doc = (SVGDocument)elt.getOwnerDocument();
                        href = new ParsedURL(doc.getURL(), href).toString();
                    }
                    newURI = new ParsedURL(oldURI2, href);
                    href = newURI.toString();
                    JSVGComponent.this.svgUserAgent.openLink(href, true);
                } else {
                    JSVGComponent.this.loadSVGDocument(href);
                }
                return;
            }
            ParsedURL newURI = new ParsedURL(((SVGDocument)elt.getOwnerDocument()).getURL(), href);
            href = newURI.toString();
            if (JSVGComponent.this.svgDocument != null && newURI.sameFile(oldURI = new ParsedURL(JSVGComponent.this.svgDocument.getURL()))) {
                String s = newURI.getRef();
                if (!(JSVGComponent.this.fragmentIdentifier == s || s != null && s.equals(JSVGComponent.this.fragmentIdentifier))) {
                    JSVGComponent.this.fragmentIdentifier = s;
                    JSVGComponent.this.computeRenderingTransform();
                }
                this.fireLinkActivatedEvent(elt, href);
                return;
            }
            this.fireLinkActivatedEvent(elt, href);
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.openLink(href, false);
            } else {
                JSVGComponent.this.loadSVGDocument(href);
            }
        }

        protected void fireLinkActivatedEvent(SVGAElement elt, String href) {
            Object[] ll = JSVGComponent.this.linkActivationListeners.toArray();
            if (ll.length > 0) {
                LinkActivationEvent ev = new LinkActivationEvent(JSVGComponent.this, elt, href);
                int i = 0;
                while (i < ll.length) {
                    LinkActivationListener l = (LinkActivationListener)ll[i];
                    l.linkActivated(ev);
                    ++i;
                }
            }
        }

        public void setSVGCursor(Cursor cursor) {
            JSVGComponent.this.setCursor(cursor);
        }

        public String getXMLParserClassName() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getXMLParserClassName();
            }
            return XMLResourceDescriptor.getXMLParserClassName();
        }

        public boolean isXMLParserValidating() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.isXMLParserValidating();
            }
            return false;
        }

        public AffineTransform getTransform() {
            return JSVGComponent.this.renderingTransform;
        }

        public String getMedia() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getMedia();
            }
            return "screen";
        }

        public String getAlternateStyleSheet() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getAlternateStyleSheet();
            }
            return null;
        }

        public Point getClientAreaLocationOnScreen() {
            return JSVGComponent.this.getLocationOnScreen();
        }

        public boolean hasFeature(String s) {
            return FEATURES.contains(s);
        }

        public boolean supportExtension(String s) {
            boolean ret = false;
            if (JSVGComponent.this.svgUserAgent != null && JSVGComponent.this.svgUserAgent.supportExtension(s)) {
                return true;
            }
            return this.extensions.containsKey(s);
        }

        public void registerExtension(BridgeExtension ext) {
            Iterator i = ext.getImplementedExtensions();
            while (i.hasNext()) {
                this.extensions.put(i.next(), ext);
            }
        }

        public void handleElement(Element elt, Object data) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.handleElement(elt, data);
            }
        }

        public ScriptSecurity getScriptSecurity(String scriptType, ParsedURL scriptURL, ParsedURL docURL) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getScriptSecurity(scriptType, scriptURL, docURL);
            }
            return new DefaultScriptSecurity(scriptType, scriptURL, docURL);
        }

        public void checkLoadScript(String scriptType, ParsedURL scriptURL, ParsedURL docURL) throws SecurityException {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.checkLoadScript(scriptType, scriptURL, docURL);
            } else {
                ScriptSecurity s = this.getScriptSecurity(scriptType, scriptURL, docURL);
                if (s != null) {
                    s.checkLoadScript();
                }
            }
        }

        public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL resourceURL, ParsedURL docURL) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getExternalResourceSecurity(resourceURL, docURL);
            }
            return new RelaxedExternalResourceSecurity(resourceURL, docURL);
        }

        public void checkLoadExternalResource(ParsedURL resourceURL, ParsedURL docURL) throws SecurityException {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.checkLoadExternalResource(resourceURL, docURL);
            } else {
                ExternalResourceSecurity s = this.getExternalResourceSecurity(resourceURL, docURL);
                if (s != null) {
                    s.checkLoadExternalResource();
                }
            }
        }
    }

    protected static class BridgeUserAgentWrapper
    implements UserAgent {
        protected UserAgent userAgent;

        public BridgeUserAgentWrapper(UserAgent ua) {
            this.userAgent = ua;
        }

        public EventDispatcher getEventDispatcher() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getEventDispatcher();
            }
            class Query
            implements Runnable {
                EventDispatcher result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getEventDispatcher();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public Dimension2D getViewportSize() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getViewportSize();
            }
            class Query
            implements Runnable {
                Dimension2D result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getViewportSize();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public void displayError(Exception ex) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.displayError(ex);
            } else {
                EventQueue.invokeLater(new Runnable(this, ex){
                    private final /* synthetic */ Exception val$ex;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = this$0;
                        this.val$ex = val$ex;
                    }

                    public void run() {
                        this.this$0.userAgent.displayError(this.val$ex);
                    }
                });
            }
        }

        public void displayMessage(String message) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.displayMessage(message);
            } else {
                EventQueue.invokeLater(new Runnable(this, message){
                    private final /* synthetic */ String val$message;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = this$0;
                        this.val$message = val$message;
                    }

                    public void run() {
                        this.this$0.userAgent.displayMessage(this.val$message);
                    }
                });
            }
        }

        public void showAlert(String message) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.showAlert(message);
            } else {
                this.invokeAndWait(new Runnable(this, message){
                    private final /* synthetic */ String val$message;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = this$0;
                        this.val$message = val$message;
                    }

                    public void run() {
                        this.this$0.userAgent.showAlert(this.val$message);
                    }
                });
            }
        }

        public String showPrompt(String message) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.showPrompt(message);
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, String val$message) {
                    this.this$0 = this$0;
                    this.val$message = val$message;
                }

                public void run() {
                    this.result = this.this$0.userAgent.showPrompt(this.val$message);
                }
            }
            Query q = new Query(this, message);
            this.invokeAndWait(q);
            return q.result;
        }

        public String showPrompt(String message, String defaultValue) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.showPrompt(message, defaultValue);
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ String val$defaultValue;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, String val$message, String val$defaultValue) {
                    this.this$0 = this$0;
                    this.val$message = val$message;
                    this.val$defaultValue = val$defaultValue;
                }

                public void run() {
                    this.result = this.this$0.userAgent.showPrompt(this.val$message, this.val$defaultValue);
                }
            }
            Query q = new Query(this, message, defaultValue);
            this.invokeAndWait(q);
            return q.result;
        }

        public boolean showConfirm(String message) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.showConfirm(message);
            }
            class Query
            implements Runnable {
                boolean result;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, String val$message) {
                    this.this$0 = this$0;
                    this.val$message = val$message;
                }

                public void run() {
                    this.result = this.this$0.userAgent.showConfirm(this.val$message);
                }
            }
            Query q = new Query(this, message);
            this.invokeAndWait(q);
            return q.result;
        }

        public float getPixelUnitToMillimeter() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getPixelUnitToMillimeter();
            }
            class Query
            implements Runnable {
                float result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getPixelUnitToMillimeter();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public float getMediumFontSize() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getMediumFontSize();
            }
            class Query
            implements Runnable {
                float result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getMediumFontSize();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public float getLighterFontWeight(float f) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getLighterFontWeight(f);
            }
            float ff = f;
            class Query
            implements Runnable {
                float result;
                private final /* synthetic */ float val$ff;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, float val$ff) {
                    this.this$0 = this$0;
                    this.val$ff = val$ff;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getLighterFontWeight(this.val$ff);
                }
            }
            Query q = new Query(this, ff);
            this.invokeAndWait(q);
            return q.result;
        }

        public float getBolderFontWeight(float f) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getBolderFontWeight(f);
            }
            float ff = f;
            class Query
            implements Runnable {
                float result;
                private final /* synthetic */ float val$ff;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, float val$ff) {
                    this.this$0 = this$0;
                    this.val$ff = val$ff;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getBolderFontWeight(this.val$ff);
                }
            }
            Query q = new Query(this, ff);
            this.invokeAndWait(q);
            return q.result;
        }

        public String getLanguages() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getLanguages();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getLanguages();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public String getUserStyleSheetURI() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getUserStyleSheetURI();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getUserStyleSheetURI();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public void openLink(SVGAElement elt) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.openLink(elt);
            } else {
                EventQueue.invokeLater(new Runnable(this, elt){
                    private final /* synthetic */ SVGAElement val$elt;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = this$0;
                        this.val$elt = val$elt;
                    }

                    public void run() {
                        this.this$0.userAgent.openLink(this.val$elt);
                    }
                });
            }
        }

        public void setSVGCursor(Cursor cursor) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.setSVGCursor(cursor);
            } else {
                EventQueue.invokeLater(new Runnable(this, cursor){
                    private final /* synthetic */ Cursor val$cursor;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = this$0;
                        this.val$cursor = val$cursor;
                    }

                    public void run() {
                        this.this$0.userAgent.setSVGCursor(this.val$cursor);
                    }
                });
            }
        }

        public String getXMLParserClassName() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getXMLParserClassName();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getXMLParserClassName();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public boolean isXMLParserValidating() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.isXMLParserValidating();
            }
            class Query
            implements Runnable {
                boolean result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.isXMLParserValidating();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public AffineTransform getTransform() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getTransform();
            }
            class Query
            implements Runnable {
                AffineTransform result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getTransform();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public String getMedia() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getMedia();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getMedia();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public String getAlternateStyleSheet() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getAlternateStyleSheet();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getAlternateStyleSheet();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public Point getClientAreaLocationOnScreen() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getClientAreaLocationOnScreen();
            }
            class Query
            implements Runnable {
                Point result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getClientAreaLocationOnScreen();
                }
            }
            Query q = new Query(this);
            this.invokeAndWait(q);
            return q.result;
        }

        public boolean hasFeature(String s) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.hasFeature(s);
            }
            class Query
            implements Runnable {
                boolean result;
                private final /* synthetic */ String val$s;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, String val$s) {
                    this.this$0 = this$0;
                    this.val$s = val$s;
                }

                public void run() {
                    this.result = this.this$0.userAgent.hasFeature(this.val$s);
                }
            }
            Query q = new Query(this, s);
            this.invokeAndWait(q);
            return q.result;
        }

        public boolean supportExtension(String s) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.supportExtension(s);
            }
            class Query
            implements Runnable {
                boolean result;
                private final /* synthetic */ String val$s;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, String val$s) {
                    this.this$0 = this$0;
                    this.val$s = val$s;
                }

                public void run() {
                    this.result = this.this$0.userAgent.supportExtension(this.val$s);
                }
            }
            Query q = new Query(this, s);
            this.invokeAndWait(q);
            return q.result;
        }

        public void registerExtension(BridgeExtension ext) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.registerExtension(ext);
            } else {
                EventQueue.invokeLater(new Runnable(this, ext){
                    private final /* synthetic */ BridgeExtension val$ext;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = this$0;
                        this.val$ext = val$ext;
                    }

                    public void run() {
                        this.this$0.userAgent.registerExtension(this.val$ext);
                    }
                });
            }
        }

        public void handleElement(Element elt, Object data) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.handleElement(elt, data);
            } else {
                EventQueue.invokeLater(new Runnable(this, elt, data){
                    private final /* synthetic */ Element val$elt;
                    private final /* synthetic */ Object val$data;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = this$0;
                        this.val$elt = val$elt;
                        this.val$data = val$data;
                    }

                    public void run() {
                        this.this$0.userAgent.handleElement(this.val$elt, this.val$data);
                    }
                });
            }
        }

        public ScriptSecurity getScriptSecurity(String scriptType, ParsedURL scriptPURL, ParsedURL docPURL) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getScriptSecurity(scriptType, scriptPURL, docPURL);
            }
            String st = scriptType;
            ParsedURL sPURL = scriptPURL;
            ParsedURL dPURL = docPURL;
            class Query
            implements Runnable {
                ScriptSecurity result;
                private final /* synthetic */ String val$st;
                private final /* synthetic */ ParsedURL val$sPURL;
                private final /* synthetic */ ParsedURL val$dPURL;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, String val$st, ParsedURL val$sPURL, ParsedURL val$dPURL) {
                    this.this$0 = this$0;
                    this.val$st = val$st;
                    this.val$sPURL = val$sPURL;
                    this.val$dPURL = val$dPURL;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getScriptSecurity(this.val$st, this.val$sPURL, this.val$dPURL);
                }
            }
            Query q = new Query(this, st, sPURL, dPURL);
            this.invokeAndWait(q);
            return q.result;
        }

        public void checkLoadScript(String scriptType, ParsedURL scriptPURL, ParsedURL docPURL) throws SecurityException {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.checkLoadScript(scriptType, scriptPURL, docPURL);
            } else {
                String st = scriptType;
                ParsedURL sPURL = scriptPURL;
                ParsedURL dPURL = docPURL;
                class Query
                implements Runnable {
                    SecurityException se;
                    private final /* synthetic */ String val$st;
                    private final /* synthetic */ ParsedURL val$sPURL;
                    private final /* synthetic */ ParsedURL val$dPURL;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;

                    Query(BridgeUserAgentWrapper this$0, String val$st, ParsedURL val$sPURL, ParsedURL val$dPURL) {
                        this.this$0 = this$0;
                        this.val$st = val$st;
                        this.val$sPURL = val$sPURL;
                        this.val$dPURL = val$dPURL;
                        this.se = null;
                    }

                    public void run() {
                        try {
                            this.this$0.userAgent.checkLoadScript(this.val$st, this.val$sPURL, this.val$dPURL);
                        }
                        catch (SecurityException se) {
                            this.se = se;
                        }
                    }
                }
                Query q = new Query(this, st, sPURL, dPURL);
                this.invokeAndWait(q);
                if (q.se != null) {
                    q.se.fillInStackTrace();
                    throw q.se;
                }
            }
        }

        public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL resourcePURL, ParsedURL docPURL) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getExternalResourceSecurity(resourcePURL, docPURL);
            }
            ParsedURL rPURL = resourcePURL;
            ParsedURL dPURL = docPURL;
            class Query
            implements Runnable {
                ExternalResourceSecurity result;
                private final /* synthetic */ ParsedURL val$rPURL;
                private final /* synthetic */ ParsedURL val$dPURL;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper this$0, ParsedURL val$rPURL, ParsedURL val$dPURL) {
                    this.this$0 = this$0;
                    this.val$rPURL = val$rPURL;
                    this.val$dPURL = val$dPURL;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getExternalResourceSecurity(this.val$rPURL, this.val$dPURL);
                }
            }
            Query q = new Query(this, rPURL, dPURL);
            this.invokeAndWait(q);
            return q.result;
        }

        public void checkLoadExternalResource(ParsedURL resourceURL, ParsedURL docURL) throws SecurityException {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.checkLoadExternalResource(resourceURL, docURL);
            } else {
                ParsedURL rPURL = resourceURL;
                ParsedURL dPURL = docURL;
                class Query
                implements Runnable {
                    SecurityException se;
                    private final /* synthetic */ ParsedURL val$rPURL;
                    private final /* synthetic */ ParsedURL val$dPURL;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;

                    Query(BridgeUserAgentWrapper this$0, ParsedURL val$rPURL, ParsedURL val$dPURL) {
                        this.this$0 = this$0;
                        this.val$rPURL = val$rPURL;
                        this.val$dPURL = val$dPURL;
                    }

                    public void run() {
                        try {
                            this.this$0.userAgent.checkLoadExternalResource(this.val$rPURL, this.val$dPURL);
                        }
                        catch (SecurityException se) {
                            this.se = se;
                        }
                    }
                }
                Query q = new Query(this, rPURL, dPURL);
                this.invokeAndWait(q);
                if (q.se != null) {
                    q.se.fillInStackTrace();
                    throw q.se;
                }
            }
        }

        protected void invokeAndWait(Runnable r) {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class SVGListener
    extends JGVTComponent.Listener
    implements SVGDocumentLoaderListener,
    GVTTreeBuilderListener,
    SVGLoadEventDispatcherListener,
    UpdateManagerListener {
        protected SVGListener() {
        }

        public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
        }

        public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.documentLoader = null;
            JSVGComponent.this.setSVGDocument(e.getSVGDocument());
        }

        public void documentLoadingCancelled(SVGDocumentLoaderEvent e) {
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.documentLoader = null;
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
        }

        public void documentLoadingFailed(SVGDocumentLoaderEvent e) {
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.documentLoader = null;
            JSVGComponent.this.userAgent.displayError(((SVGDocumentLoader)e.getSource()).getException());
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
        }

        public void gvtBuildStarted(GVTTreeBuilderEvent e) {
            JSVGComponent.this.computeRenderingTransform();
        }

        public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            JSVGComponent.this.loader = null;
            JSVGComponent.this.gvtTreeBuilder = null;
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            if (JSVGComponent.this.isDynamicDocument && JSVGComponent.this.eventsEnabled) {
                JSVGComponent.this.startSVGLoadEventDispatcher(e.getGVTRoot());
            } else {
                JSVGComponent.super.setGraphicsNode(e.getGVTRoot(), false);
            }
            Dimension2D dim = JSVGComponent.this.bridgeContext.getDocumentSize();
            JSVGComponent.this.setPreferredSize(new Dimension((int)dim.getWidth(), (int)dim.getHeight()));
            JSVGComponent.this.invalidate();
        }

        public void gvtBuildCancelled(GVTTreeBuilderEvent e) {
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            JSVGComponent.this.loader = null;
            JSVGComponent.this.gvtTreeBuilder = null;
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.image = null;
            JSVGComponent.this.repaint();
        }

        public void gvtBuildFailed(GVTTreeBuilderEvent e) {
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            JSVGComponent.this.loader = null;
            JSVGComponent.this.gvtTreeBuilder = null;
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            GraphicsNode gn = e.getGVTRoot();
            Dimension2D dim = JSVGComponent.this.bridgeContext.getDocumentSize();
            if (gn == null || dim == null) {
                JSVGComponent.this.image = null;
                JSVGComponent.this.repaint();
            } else {
                JSVGComponent.super.setGraphicsNode(gn, false);
                JSVGComponent.this.setPreferredSize(new Dimension((int)dim.getWidth(), (int)dim.getHeight()));
                JSVGComponent.this.invalidate();
            }
            JSVGComponent.this.userAgent.displayError(((GVTTreeBuilder)e.getSource()).getException());
        }

        public void svgLoadEventDispatchStarted(SVGLoadEventDispatcherEvent e) {
        }

        public void svgLoadEventDispatchCompleted(SVGLoadEventDispatcherEvent e) {
            JSVGComponent.this.nextUpdateManager = JSVGComponent.this.svgLoadEventDispatcher.getUpdateManager();
            JSVGComponent.this.svgLoadEventDispatcher = null;
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.nextUpdateManager.interrupt();
                JSVGComponent.this.nextUpdateManager = null;
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.nextUpdateManager.interrupt();
                JSVGComponent.this.nextUpdateManager = null;
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.super.setGraphicsNode(e.getGVTRoot(), false);
        }

        public void svgLoadEventDispatchCancelled(SVGLoadEventDispatcherEvent e) {
            JSVGComponent.this.nextUpdateManager = JSVGComponent.this.svgLoadEventDispatcher.getUpdateManager();
            JSVGComponent.this.svgLoadEventDispatcher = null;
            JSVGComponent.this.nextUpdateManager.interrupt();
            JSVGComponent.this.nextUpdateManager = null;
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        public void svgLoadEventDispatchFailed(SVGLoadEventDispatcherEvent e) {
            JSVGComponent.this.nextUpdateManager = JSVGComponent.this.svgLoadEventDispatcher.getUpdateManager();
            JSVGComponent.this.svgLoadEventDispatcher = null;
            JSVGComponent.this.nextUpdateManager.interrupt();
            JSVGComponent.this.nextUpdateManager = null;
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            GraphicsNode gn = e.getGVTRoot();
            Dimension2D dim = JSVGComponent.this.bridgeContext.getDocumentSize();
            if (gn == null || dim == null) {
                JSVGComponent.this.image = null;
                JSVGComponent.this.repaint();
            } else {
                JSVGComponent.super.setGraphicsNode(gn, false);
            }
            JSVGComponent.this.userAgent.displayError(((SVGLoadEventDispatcher)e.getSource()).getException());
        }

        public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
            super.gvtRenderingCompleted(e);
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            if (JSVGComponent.this.nextUpdateManager != null) {
                JSVGComponent.this.updateManager = JSVGComponent.this.nextUpdateManager;
                JSVGComponent.this.nextUpdateManager = null;
                JSVGComponent.this.updateManager.addUpdateManagerListener(this);
                JSVGComponent.this.updateManager.manageUpdates(JSVGComponent.this.renderer);
            }
        }

        public void gvtRenderingCancelled(GVTTreeRendererEvent e) {
            super.gvtRenderingCancelled(e);
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        public void gvtRenderingFailed(GVTTreeRendererEvent e) {
            super.gvtRenderingFailed(e);
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        public void managerStarted(UpdateManagerEvent e) {
            EventQueue.invokeLater(new Runnable(this, e){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    JSVGComponent.access$1503(SVGListener.access$1400(this.this$1), false);
                    Object[] dll = SVGListener.access$1400((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (dll.length > 0) {
                        int i = 0;
                        while (i < dll.length) {
                            ((UpdateManagerListener)dll[i]).managerStarted(this.val$e);
                            ++i;
                        }
                    }
                }
            });
        }

        public void managerSuspended(UpdateManagerEvent e) {
            EventQueue.invokeLater(new Runnable(this, e){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    Object[] dll = SVGListener.access$1400((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (dll.length > 0) {
                        int i = 0;
                        while (i < dll.length) {
                            ((UpdateManagerListener)dll[i]).managerSuspended(this.val$e);
                            ++i;
                        }
                    }
                }
            });
        }

        public void managerResumed(UpdateManagerEvent e) {
            EventQueue.invokeLater(new Runnable(this, e){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    Object[] dll = SVGListener.access$1400((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (dll.length > 0) {
                        int i = 0;
                        while (i < dll.length) {
                            ((UpdateManagerListener)dll[i]).managerResumed(this.val$e);
                            ++i;
                        }
                    }
                }
            });
        }

        public void managerStopped(UpdateManagerEvent e) {
            EventQueue.invokeLater(new Runnable(this, e){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    SVGListener.access$1400((SVGListener)this.this$1).updateManager = null;
                    Object[] dll = SVGListener.access$1400((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (dll.length > 0) {
                        int i = 0;
                        while (i < dll.length) {
                            ((UpdateManagerListener)dll[i]).managerStopped(this.val$e);
                            ++i;
                        }
                    }
                    if (SVGListener.access$1400((SVGListener)this.this$1).nextGVTTreeBuilder != null) {
                        JSVGComponent.access$400(SVGListener.access$1400(this.this$1));
                        return;
                    }
                    if (SVGListener.access$1400((SVGListener)this.this$1).nextDocumentLoader != null) {
                        JSVGComponent.access$300(SVGListener.access$1400(this.this$1));
                        return;
                    }
                }
            });
        }

        public void updateStarted(UpdateManagerEvent e) {
            EventQueue.invokeLater(new Runnable(this, e){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    Object[] dll;
                    if (!JSVGComponent.access$1601(SVGListener.access$1400(this.this$1))) {
                        JSVGComponent.access$1703(SVGListener.access$1400(this.this$1), this.val$e.getImage());
                    }
                    if ((dll = SVGListener.access$1400((SVGListener)this.this$1).updateManagerListeners.toArray()).length > 0) {
                        int i = 0;
                        while (i < dll.length) {
                            ((UpdateManagerListener)dll[i]).updateStarted(this.val$e);
                            ++i;
                        }
                    }
                }
            });
        }

        public void updateCompleted(UpdateManagerEvent e) {
            try {
                EventQueue.invokeAndWait(new Runnable(this, e){
                    private final /* synthetic */ UpdateManagerEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        JSVGComponent.access$1803(SVGListener.access$1400(this.this$1), this.val$e.getImage());
                        List l = this.val$e.getDirtyAreas();
                        if (l != null) {
                            Dimension dim = SVGListener.access$1400(this.this$1).getSize();
                            List ml = SVGListener.access$1400(this.this$1).mergeRectangles(l, 0, 0, dim.width - 1, dim.height - 1);
                            if (ml.size() < l.size()) {
                                l = ml;
                            }
                            Iterator<E> i = l.iterator();
                            while (i.hasNext()) {
                                Rectangle r = (Rectangle)i.next();
                                if (JSVGComponent.access$1901(SVGListener.access$1400(this.this$1))) {
                                    SVGListener.access$1400(this.this$1).repaint(r);
                                    continue;
                                }
                                SVGListener.access$1400(this.this$1).paintImmediately(r);
                            }
                        }
                        JSVGComponent.access$2003(SVGListener.access$1400(this.this$1), false);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            EventQueue.invokeLater(new Runnable(this, e){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    Object[] dll = SVGListener.access$1400((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (dll.length > 0) {
                        int i = 0;
                        while (i < dll.length) {
                            ((UpdateManagerListener)dll[i]).updateCompleted(this.val$e);
                            ++i;
                        }
                    }
                }
            });
        }

        public void updateFailed(UpdateManagerEvent e) {
            EventQueue.invokeLater(new Runnable(this, e){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    Object[] dll = SVGListener.access$1400((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (dll.length > 0) {
                        int i = 0;
                        while (i < dll.length) {
                            ((UpdateManagerListener)dll[i]).updateFailed(this.val$e);
                            ++i;
                        }
                    }
                }
            });
        }

        protected void dispatchKeyTyped(KeyEvent e) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchKeyTyped(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, e){
                    private final /* synthetic */ KeyEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        JSVGComponent.access$2101(SVGListener.access$1400(this.this$1)).keyTyped(this.val$e);
                    }
                });
            }
        }

        protected void dispatchKeyPressed(KeyEvent e) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchKeyPressed(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, e){
                    private final /* synthetic */ KeyEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        JSVGComponent.access$2201(SVGListener.access$1400(this.this$1)).keyPressed(this.val$e);
                    }
                });
            }
        }

        protected void dispatchKeyReleased(KeyEvent e) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchKeyReleased(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, e){
                    private final /* synthetic */ KeyEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        JSVGComponent.access$2301(SVGListener.access$1400(this.this$1)).keyReleased(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMouseClicked(MouseEvent e) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchMouseClicked(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, e){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        JSVGComponent.access$2401(SVGListener.access$1400(this.this$1)).mouseClicked(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMousePressed(MouseEvent e) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchMousePressed(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, e){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        JSVGComponent.access$2501(SVGListener.access$1400(this.this$1)).mousePressed(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMouseReleased(MouseEvent e) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchMouseReleased(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, e){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        JSVGComponent.access$2601(SVGListener.access$1400(this.this$1)).mouseReleased(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMouseEntered(MouseEvent e) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchMouseEntered(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, e){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        JSVGComponent.access$2701(SVGListener.access$1400(this.this$1)).mouseEntered(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMouseExited(MouseEvent e) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchMouseExited(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, e){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        JSVGComponent.access$2801(SVGListener.access$1400(this.this$1)).mouseExited(this.val$e);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dispatchMouseDragged(MouseEvent e) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchMouseDragged(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                class MouseDraggedRunnable
                implements Runnable {
                    MouseEvent event;
                    private final /* synthetic */ SVGListener this$1;

                    MouseDraggedRunnable(SVGListener this$1, MouseEvent evt) {
                        this.this$1 = this$1;
                        this.event = evt;
                    }

                    public void run() {
                        JSVGComponent.access$2901(SVGListener.access$1400(this.this$1)).mouseDragged(this.event);
                    }
                }
                RunnableQueue rq = JSVGComponent.this.updateManager.getUpdateRunnableQueue();
                Object object = rq.getIteratorLock();
                synchronized (object) {
                    Iterator it = rq.iterator();
                    while (it.hasNext()) {
                        Object next = it.next();
                        if (!(next instanceof MouseDraggedRunnable)) continue;
                        MouseDraggedRunnable mdr = (MouseDraggedRunnable)next;
                        MouseEvent mev = mdr.event;
                        if (mev.getModifiers() == e.getModifiers()) {
                            mdr.event = e;
                        }
                        return;
                    }
                }
                rq.invokeLater(new MouseDraggedRunnable(this, e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dispatchMouseMoved(MouseEvent e) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchMouseMoved(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                class MouseMovedRunnable
                implements Runnable {
                    MouseEvent event;
                    private final /* synthetic */ SVGListener this$1;

                    MouseMovedRunnable(SVGListener this$1, MouseEvent evt) {
                        this.this$1 = this$1;
                        this.event = evt;
                    }

                    public void run() {
                        JSVGComponent.access$3001(SVGListener.access$1400(this.this$1)).mouseMoved(this.event);
                    }
                }
                RunnableQueue rq = JSVGComponent.this.updateManager.getUpdateRunnableQueue();
                int i = 0;
                Object object = rq.getIteratorLock();
                synchronized (object) {
                    Iterator it = rq.iterator();
                    while (it.hasNext()) {
                        Object next = it.next();
                        if (next instanceof MouseMovedRunnable) {
                            MouseMovedRunnable mmr = (MouseMovedRunnable)next;
                            MouseEvent mev = mmr.event;
                            if (mev.getModifiers() == e.getModifiers()) {
                                mmr.event = e;
                            }
                            return;
                        }
                        ++i;
                    }
                }
                rq.invokeLater(new MouseMovedRunnable(this, e));
            }
        }

        static /* synthetic */ JSVGComponent access$1400(SVGListener x0) {
            return x0.JSVGComponent.this;
        }
    }
}

