/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.jaxp.SAXParserImpl;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SAXParserFactoryImpl
extends SAXParserFactory {
    private Hashtable features;

    public SAXParser newSAXParser() throws ParserConfigurationException {
        SAXParserImpl sAXParserImpl;
        try {
            sAXParserImpl = new SAXParserImpl(this, this.features);
        }
        catch (SAXException sAXException) {
            throw new ParserConfigurationException(sAXException.getMessage());
        }
        return sAXParserImpl;
    }

    private final SAXParserImpl newSAXParserImpl() throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        SAXParserImpl sAXParserImpl;
        try {
            sAXParserImpl = new SAXParserImpl(this, this.features);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw sAXNotSupportedException;
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw sAXNotRecognizedException;
        }
        catch (SAXException sAXException) {
            throw new ParserConfigurationException(sAXException.getMessage());
        }
        return sAXParserImpl;
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (this.features == null) {
            this.features = new Hashtable();
        }
        this.features.put(string, new Boolean(bl));
        try {
            this.newSAXParserImpl();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            this.features.remove(string);
            throw sAXNotSupportedException;
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            this.features.remove(string);
            throw sAXNotRecognizedException;
        }
    }

    public boolean getFeature(String string) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        return this.newSAXParserImpl().getXMLReader().getFeature(string);
    }
}

