/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import java.util.Hashtable;
import org.apache.xerces.utils.QName;
import org.apache.xerces.validators.common.CMAny;
import org.apache.xerces.validators.common.CMBinOp;
import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.CMLeaf;
import org.apache.xerces.validators.common.CMNode;
import org.apache.xerces.validators.common.CMStateSet;
import org.apache.xerces.validators.common.CMUniOp;
import org.apache.xerces.validators.common.ContentLeafNameTypeVector;
import org.apache.xerces.validators.common.ElementWildcard;
import org.apache.xerces.validators.common.InsertableElementsInfo;
import org.apache.xerces.validators.common.XMLContentModel;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.SubstitutionGroupComparator;

public class DFAContentModel
implements XMLContentModel {
    private static final int EPSILON = -2;
    private static final int EOC = -3;
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private static long time = 0L;
    private SubstitutionGroupComparator comparator = null;
    private QName[] fElemMap = null;
    private int[] fElemMapType = null;
    private int fElemMapSize = 0;
    private boolean fDTD;
    private boolean fMixed;
    private int fEOCIndex = 0;
    private int fEOCPos = 0;
    private int fEpsilonIndex = 0;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private CMLeaf[] fLeafList = null;
    private int[] fLeafListType = null;
    private ContentLeafNameTypeVector fLeafNameTypeVector = null;
    private int[][] fTransTable = null;
    private int fTransTableSize = 0;
    private boolean fEmptyContentIsValid = false;
    private QName fQName = new QName();
    private byte[][] fConflictTable;

    public int validateContent(QName[] qNameArray, int n, int n2) throws CMException {
        if (n2 == 0) {
            return this.fEmptyContentIsValid ? -1 : 0;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            QName qName = qNameArray[n + n5];
            if (!this.fMixed || qName.localpart != -1) {
                int n6 = 0;
                while (n6 < this.fElemMapSize) {
                    int n7;
                    if (this.fDTD ? this.fElemMap[n6].rawname == qName.rawname && (n4 = this.fTransTable[n3][n6]) != -1 : ((n7 = this.fElemMapType[n6] & 0xF) == 0 ? this.fElemMap[n6].uri == qName.uri && this.fElemMap[n6].localpart == qName.localpart && (n4 = this.fTransTable[n3][n6]) != -1 : (n7 == 6 ? (n4 = this.fTransTable[n3][n6]) != -1 : (n7 == 8 ? qName.uri == this.fElemMap[n6].uri && (n4 = this.fTransTable[n3][n6]) != -1 : n7 == 7 && this.fElemMap[n6].uri != qName.uri && (n4 = this.fTransTable[n3][n6]) != -1)))) break;
                    ++n6;
                }
                if (n4 == -1) {
                    return n5;
                }
                if (n6 == this.fElemMapSize) {
                    return n5;
                }
                n3 = n4;
                n4 = 0;
            }
            ++n5;
        }
        if (!this.fFinalStateFlags[n3]) {
            return n2;
        }
        return -1;
    }

    private final boolean isEqual(QName qName, QName qName2) {
        return qName.localpart == qName2.localpart && qName.uri == qName2.uri;
    }

    public int validateContentSpecial(QName[] qNameArray, int n, int n2) throws Exception {
        if (this.comparator == null) {
            return this.validateContent(qNameArray, n, n2);
        }
        if (n2 == 0) {
            return this.fEmptyContentIsValid ? -1 : 0;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            QName qName = qNameArray[n + n5];
            int n6 = 0;
            while (n6 < this.fElemMapSize) {
                int n7 = this.fElemMapType[n6] & 0xF;
                if (n7 == 0 ? this.comparator.isEquivalentTo(qName, this.fElemMap[n6]) && (n4 = this.fTransTable[n3][n6]) != -1 : (n7 == 6 ? (n4 = this.fTransTable[n3][n6]) != -1 : (n7 == 8 ? qName.uri == this.fElemMap[n6].uri && (n4 = this.fTransTable[n3][n6]) != -1 : n7 == 7 && this.fElemMap[n6].uri != qName.uri && (n4 = this.fTransTable[n3][n6]) != -1))) break;
                ++n6;
            }
            if (n4 == -1) {
                return n5;
            }
            if (n6 == this.fElemMapSize) {
                return n5;
            }
            n3 = n4;
            n4 = 0;
            ++n5;
        }
        if (!this.fFinalStateFlags[n3]) {
            return n2;
        }
        return -1;
    }

    public boolean isFinalState(int n) {
        if (n < 0) {
            return false;
        }
        return this.fFinalStateFlags[n];
    }

    public int oneTransition(QName qName, int[] nArray, int n) throws Exception {
        int n2 = nArray[n];
        if (n2 < 0) {
            return -1;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.fElemMapSize) {
            int n5 = this.fElemMapType[n4] & 0xF;
            if (n5 == 0 ? this.isEqual(qName, this.fElemMap[n4]) && (n3 = this.fTransTable[n2][n4]) != -1 : (n5 == 6 ? (n3 = this.fTransTable[n2][n4]) != -1 : (n5 == 8 ? qName.uri == this.fElemMap[n4].uri && (n3 = this.fTransTable[n2][n4]) != -1 : n5 == 7 && this.fElemMap[n4].uri != qName.uri && (n3 = this.fTransTable[n2][n4]) != -1))) break;
            ++n4;
        }
        if (n4 == this.fElemMapSize && this.comparator != null) {
            n4 = 0;
            while (n4 < this.fElemMapSize) {
                if (this.fElemMapType[n4] == 0 && this.comparator.isEquivalentTo(qName, this.fElemMap[n4]) && (n3 = this.fTransTable[n2][n4]) != -1) break;
                ++n4;
            }
        }
        if (n4 == this.fElemMapSize) {
            nArray[n] = -1;
            return -1;
        }
        nArray[n] = n3;
        return n4;
    }

    public void setSubstitutionGroupComparator(SubstitutionGroupComparator substitutionGroupComparator) {
        this.comparator = substitutionGroupComparator;
    }

    public int whatCanGoHere(boolean bl, InsertableElementsInfo insertableElementsInfo) throws CMException {
        int n = 0;
        int n2 = 0;
        while (n2 < insertableElementsInfo.insertAt) {
            QName qName = insertableElementsInfo.curChildren[n2];
            int n3 = 0;
            while (n3 < this.fElemMapSize) {
                if (this.fElemMap[n3].uri == qName.uri && this.fElemMap[n3].localpart == qName.localpart) break;
                ++n3;
            }
            if (n3 == this.fElemMapSize) {
                return n2;
            }
            if ((n = this.fTransTable[n][n3]) == -1) {
                return n2;
            }
            ++n2;
        }
        n2 = n;
        insertableElementsInfo.canHoldPCData = this.fMixed;
        insertableElementsInfo.isValidEOC = this.fFinalStateFlags[n2];
        insertableElementsInfo.resultsCount = this.fElemMapSize;
        if (insertableElementsInfo.results == null || insertableElementsInfo.results.length < insertableElementsInfo.resultsCount) {
            insertableElementsInfo.results = new boolean[insertableElementsInfo.resultsCount];
        }
        if (insertableElementsInfo.possibleChildren == null || insertableElementsInfo.possibleChildren.length < insertableElementsInfo.resultsCount) {
            insertableElementsInfo.possibleChildren = new QName[insertableElementsInfo.resultsCount];
            int n4 = 0;
            while (n4 < insertableElementsInfo.possibleChildren.length) {
                insertableElementsInfo.possibleChildren[n4] = new QName();
                ++n4;
            }
        }
        int n5 = 0;
        while (n5 < this.fElemMapSize) {
            insertableElementsInfo.possibleChildren[n5].setValues(this.fElemMap[n5]);
            insertableElementsInfo.results[n5] = this.fTransTable[n2][n5] != -1;
            ++n5;
        }
        if (bl) {
            n5 = 0;
            while (n5 < insertableElementsInfo.resultsCount) {
                if (insertableElementsInfo.results[n5]) {
                    insertableElementsInfo.curChildren[insertableElementsInfo.insertAt] = insertableElementsInfo.possibleChildren[n5];
                    if (this.validateContent(insertableElementsInfo.curChildren, 0, insertableElementsInfo.childCount) != -1) {
                        insertableElementsInfo.results[n5] = false;
                    }
                }
                ++n5;
            }
        }
        return -1;
    }

    public ContentLeafNameTypeVector getContentLeafNameTypeVector() {
        return this.fLeafNameTypeVector;
    }

    public void checkUniqueParticleAttribution(SchemaGrammar schemaGrammar) throws Exception {
        int n;
        int n2 = 0;
        while (n2 < this.fElemMapSize) {
            this.fElemMap[n2].uri = schemaGrammar.getContentSpecOrgUri(this.fElemMap[n2].uri);
            ++n2;
        }
        this.fConflictTable = new byte[this.fElemMapSize][this.fElemMapSize];
        n2 = 0;
        while (n2 < this.fElemMapSize) {
            n = n2 + 1;
            while (n < this.fElemMapSize) {
                this.fConflictTable[n2][n] = -1;
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.fTransTable.length && this.fTransTable[n2] != null) {
            n = 0;
            while (n < this.fElemMapSize) {
                int n3 = n + 1;
                while (n3 < this.fElemMapSize) {
                    if (this.fTransTable[n2][n] != -1 && this.fTransTable[n2][n3] != -1 && this.fConflictTable[n][n3] == -1) {
                        this.fConflictTable[n][n3] = ElementWildcard.conflict(this.fElemMapType[n], this.fElemMap[n].localpart, this.fElemMap[n].uri, this.fElemMapType[n3], this.fElemMap[n3].localpart, this.fElemMap[n3].uri, this.comparator) ? (byte)1 : 0;
                    }
                    ++n3;
                }
                ++n;
            }
            ++n2;
        }
        this.fConflictTable = null;
    }

    private final void buildDFA(CMNode cMNode) throws CMException {
        int n;
        Object object;
        int n2;
        this.fQName.setValues(-1, this.fEOCIndex, this.fEOCIndex);
        CMLeaf cMLeaf = new CMLeaf(this.fQName);
        this.fHeadNode = new CMBinOp(5, cMNode, cMLeaf);
        this.fEOCPos = this.fLeafCount;
        cMLeaf.setPosition(this.fLeafCount++);
        this.fLeafList = new CMLeaf[this.fLeafCount];
        this.fLeafListType = new int[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode, 0);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        int n3 = 0;
        while (n3 < this.fLeafCount) {
            this.fFollowList[n3] = new CMStateSet(this.fLeafCount);
            ++n3;
        }
        this.calcFollowList(this.fHeadNode);
        this.fElemMap = new QName[this.fLeafCount];
        this.fElemMapType = new int[this.fLeafCount];
        this.fElemMapSize = 0;
        n3 = 0;
        while (n3 < this.fLeafCount) {
            this.fElemMap[n3] = new QName();
            if ((this.fLeafListType[n3] & 0xF) != 0 && this.fLeafNameTypeVector == null) {
                this.fLeafNameTypeVector = new ContentLeafNameTypeVector();
            }
            QName qName = this.fLeafList[n3].getElement();
            n2 = 0;
            while (n2 < this.fElemMapSize) {
                if (this.fDTD ? this.fElemMap[n2].rawname == qName.rawname : this.fElemMapType[n2] == this.fLeafListType[n3] && this.fElemMap[n2].uri == qName.uri && this.fElemMap[n2].localpart == qName.localpart) break;
                ++n2;
            }
            if (n2 == this.fElemMapSize) {
                this.fElemMap[this.fElemMapSize].setValues(qName);
                this.fElemMapType[this.fElemMapSize] = this.fLeafListType[n3];
                ++this.fElemMapSize;
            }
            ++n3;
        }
        if (this.fLeafNameTypeVector != null) {
            this.fLeafNameTypeVector.setValues(this.fElemMap, this.fElemMapType, this.fElemMapSize);
        }
        int[] nArray = new int[this.fLeafCount + this.fElemMapSize];
        int n4 = 0;
        n2 = 0;
        while (n2 < this.fElemMapSize) {
            int n5 = 0;
            while (n5 < this.fLeafCount) {
                object = this.fLeafList[n5].getElement();
                n = this.fLeafListType[n5];
                QName qName = this.fElemMap[n2];
                if (this.fDTD) {
                    if (((QName)object).rawname == qName.rawname) {
                        nArray[n4++] = n5;
                    }
                } else if (this.fElemMapType[n2] == this.fLeafListType[n5] && ((QName)object).uri == qName.uri && ((QName)object).localpart == qName.localpart) {
                    nArray[n4++] = n5;
                }
                ++n5;
            }
            nArray[n4++] = -1;
            ++n2;
        }
        n2 = this.fLeafCount * 4;
        CMStateSet[] cMStateSetArray = new CMStateSet[n2];
        this.fFinalStateFlags = new boolean[n2];
        this.fTransTable = new int[n2][];
        object = this.fHeadNode.firstPos();
        n = 0;
        int n6 = 0;
        this.fTransTable[n6] = this.makeDefStateList();
        cMStateSetArray[n6] = object;
        ++n6;
        Hashtable<CMStateSet, Integer> hashtable = new Hashtable<CMStateSet, Integer>();
        while (n < n6) {
            object = cMStateSetArray[n];
            int[] nArray2 = this.fTransTable[n];
            this.fFinalStateFlags[n] = ((CMStateSet)object).getBit(this.fEOCPos);
            ++n;
            CMStateSet cMStateSet = null;
            int n7 = 0;
            int n8 = 0;
            while (n8 < this.fElemMapSize) {
                if (cMStateSet == null) {
                    cMStateSet = new CMStateSet(this.fLeafCount);
                } else {
                    cMStateSet.zeroBits();
                }
                int n9 = nArray[n7++];
                while (n9 != -1) {
                    if (((CMStateSet)object).getBit(n9)) {
                        cMStateSet.union(this.fFollowList[n9]);
                    }
                    n9 = nArray[n7++];
                }
                if (!cMStateSet.isEmpty()) {
                    int n10;
                    Integer n11 = (Integer)hashtable.get(cMStateSet);
                    int n12 = n10 = n11 == null ? n6 : n11;
                    if (n10 == n6) {
                        cMStateSetArray[n6] = cMStateSet;
                        this.fTransTable[n6] = this.makeDefStateList();
                        hashtable.put(cMStateSet, new Integer(n6));
                        ++n6;
                        cMStateSet = null;
                    }
                    nArray2[n8] = n10;
                    if (n6 == n2) {
                        int n13 = (int)((double)n2 * 1.5);
                        CMStateSet[] cMStateSetArray2 = new CMStateSet[n13];
                        boolean[] blArray = new boolean[n13];
                        int[][] nArray3 = new int[n13][];
                        int n14 = 0;
                        while (n14 < n2) {
                            cMStateSetArray2[n14] = cMStateSetArray[n14];
                            blArray[n14] = this.fFinalStateFlags[n14];
                            nArray3[n14] = this.fTransTable[n14];
                            ++n14;
                        }
                        n2 = n13;
                        cMStateSetArray = cMStateSetArray2;
                        this.fFinalStateFlags = blArray;
                        this.fTransTable = nArray3;
                    }
                }
                ++n8;
            }
        }
        this.fEmptyContentIsValid = ((CMBinOp)this.fHeadNode).getLeft().isNullable();
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
    }

    private final void calcFollowList(CMNode cMNode) throws CMException {
        if (cMNode.type() == 4) {
            this.calcFollowList(((CMBinOp)cMNode).getLeft());
            this.calcFollowList(((CMBinOp)cMNode).getRight());
        } else if (cMNode.type() == 5) {
            this.calcFollowList(((CMBinOp)cMNode).getLeft());
            this.calcFollowList(((CMBinOp)cMNode).getRight());
            CMStateSet cMStateSet = ((CMBinOp)cMNode).getLeft().lastPos();
            CMStateSet cMStateSet2 = ((CMBinOp)cMNode).getRight().firstPos();
            int n = 0;
            while (n < this.fLeafCount) {
                if (cMStateSet.getBit(n)) {
                    this.fFollowList[n].union(cMStateSet2);
                }
                ++n;
            }
        } else if (cMNode.type() == 2 || cMNode.type() == 3) {
            this.calcFollowList(((CMUniOp)cMNode).getChild());
            CMStateSet cMStateSet = cMNode.firstPos();
            CMStateSet cMStateSet3 = cMNode.lastPos();
            int n = 0;
            while (n < this.fLeafCount) {
                if (cMStateSet3.getBit(n)) {
                    this.fFollowList[n].union(cMStateSet);
                }
                ++n;
            }
        } else if (cMNode.type() == 1) {
            this.calcFollowList(((CMUniOp)cMNode).getChild());
        }
    }

    private final void dumpTree(CMNode cMNode, int n) throws CMException {
        int n2 = 0;
        while (n2 < n) {
            System.out.print("   ");
            ++n2;
        }
        n2 = cMNode.type();
        switch (n2 & 0xF) {
            case 4: 
            case 5: {
                if (n2 == 4) {
                    System.out.print("Choice Node ");
                } else {
                    System.out.print("Seq Node ");
                }
                if (cMNode.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                this.dumpTree(((CMBinOp)cMNode).getLeft(), n + 1);
                this.dumpTree(((CMBinOp)cMNode).getRight(), n + 1);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                System.out.print("Rep Node ");
                if (cMNode.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                this.dumpTree(((CMUniOp)cMNode).getChild(), n + 1);
                break;
            }
            case 0: {
                System.out.print("Leaf: (pos=" + ((CMLeaf)cMNode).getPosition() + "), " + ((CMLeaf)cMNode).getElement() + "(elemIndex=" + ((CMLeaf)cMNode).getElement() + ") ");
                if (cMNode.isNullable()) {
                    System.out.print(" Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                if (n2 == 6) {
                    System.out.print("Any Node: ");
                } else if (n2 == 22) {
                    System.out.print("Any lax Node: ");
                } else if (n2 == 38) {
                    System.out.print("Any skip Node: ");
                } else if (n2 == 7) {
                    System.out.print("Any other Node: ");
                } else if (n2 == 23) {
                    System.out.print("Any other lax Node: ");
                } else if (n2 == 39) {
                    System.out.print("Any other skip Node: ");
                } else if (n2 == 8) {
                    System.out.print("Any namespace Node: ");
                } else if (n2 == 24) {
                    System.out.print("Any namespace lax Node: ");
                } else if (n2 == 40) {
                    System.out.print("Any namespace skip Node: ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                break;
            }
            default: {
                throw new CMException(10);
            }
        }
    }

    private final int[] makeDefStateList() {
        int[] nArray = new int[this.fElemMapSize];
        int n = 0;
        while (n < this.fElemMapSize) {
            nArray[n] = -1;
            ++n;
        }
        return nArray;
    }

    private final int postTreeBuildInit(CMNode cMNode, int n) throws CMException {
        cMNode.setMaxStates(this.fLeafCount);
        if ((cMNode.type() & 0xF) == 6 || (cMNode.type() & 0xF) == 8 || (cMNode.type() & 0xF) == 7) {
            QName qName = new QName(-1, -1, -1, ((CMAny)cMNode).getURI());
            this.fLeafList[n] = new CMLeaf(qName, ((CMAny)cMNode).getPosition());
            this.fLeafListType[n] = cMNode.type();
            ++n;
        } else if (cMNode.type() == 4 || cMNode.type() == 5) {
            n = this.postTreeBuildInit(((CMBinOp)cMNode).getLeft(), n);
            n = this.postTreeBuildInit(((CMBinOp)cMNode).getRight(), n);
        } else if (cMNode.type() == 2 || cMNode.type() == 3 || cMNode.type() == 1) {
            n = this.postTreeBuildInit(((CMUniOp)cMNode).getChild(), n);
        } else if (cMNode.type() == 0) {
            QName qName = ((CMLeaf)cMNode).getElement();
            if (qName.localpart != this.fEpsilonIndex) {
                this.fLeafList[n] = (CMLeaf)cMNode;
                this.fLeafListType[n] = 0;
                ++n;
            }
        } else {
            throw new CMException(10);
        }
        return n;
    }

    public DFAContentModel(CMNode cMNode, int n) throws CMException {
        this(cMNode, n, false, false);
    }

    public DFAContentModel(CMNode cMNode, int n, boolean bl, boolean bl2) throws CMException {
        this.fLeafCount = n;
        this.fEpsilonIndex = -2;
        this.fEOCIndex = -3;
        this.fDTD = bl;
        this.fMixed = bl2;
        time -= System.currentTimeMillis();
        this.buildDFA(cMNode);
        time += System.currentTimeMillis();
    }
}

