/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.swing;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.sqs_xml.editor.base.source.DOMTreeSource;
import net.sf.sqs_xml.editor.base.swing.NodeTreePane;
import net.sf.sqs_xml.editor.base.swing.SourceEditorMediator;

public abstract class SourceEditorSplitPane
extends JSplitPane {
    SourceEditorMediator mediator;
    DOMTreeSource source;
    NodeTreePane treePane;
    JComponent editorPane;
    JScrollPane editorScrollPane;

    public SourceEditorSplitPane(SourceEditorMediator mediator, DOMTreeSource source, int width) {
        this.mediator = mediator;
        this.source = source;
        this.editorPane = this.createEditorPane();
        this.treePane = this.createSourceEditorTree(mediator);
        final JScrollPane treeScrollPane = new JScrollPane(this.treePane);
        this.editorScrollPane = new JScrollPane(this.editorPane);
        this.setOrientation(1);
        this.setOneTouchExpandable(true);
        this.setDividerLocation((int)((double)width * 0.4));
        this.setLeftComponent(treeScrollPane);
        this.setRightComponent(this.editorScrollPane);
        ChangeListener viewportChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                treeScrollPane.getViewport().updateUI();
            }
        };
        treeScrollPane.getViewport().addChangeListener(viewportChangeListener);
        this.editorScrollPane.getViewport().addChangeListener(viewportChangeListener);
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent ev) {
                ((SourceEditorSplitPane)SourceEditorSplitPane.this).getMediator().menuBarMediator.updateMenu();
            }
        });
    }

    private SourceEditorMediator getMediator() {
        return this.mediator;
    }

    private JComponent createEditorPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        return panel;
    }

    public DOMTreeSource getSource() {
        return this.source;
    }

    public JScrollPane getEditorScrollPane() {
        return this.editorScrollPane;
    }

    public JComponent getEditorPane() {
        return this.editorPane;
    }

    public NodeTreePane getTreePane() {
        return this.treePane;
    }

    public abstract NodeTreePane createSourceEditorTree(SourceEditorMediator var1);
}

