/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.swing;

import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import javax.swing.Icon;
import net.sf.sqs_xml.editor.base.source.DOMTreeSource;
import net.sf.sqs_xml.editor.base.swing.SourceEditorMediator;
import net.sf.sqs_xml.editor.base.swing.SourceEditorSplitPane;
import net.sf.sqs_xml.swing.FileDropAcceptableTabbedPanel;

public abstract class SourceEditorTabbedPane
extends FileDropAcceptableTabbedPanel {
    SourceEditorMediator mediator;

    public SourceEditorTabbedPane(SourceEditorMediator mediator) {
        this.mediator = mediator;
        this.setToolTipText("\u3053\u3053\u306b\u300c.sqs\u30d5\u30a1\u30a4\u30eb\u300d\u3092\u30c9\u30e9\u30c3\u30b0&\u30c9\u30ed\u30c3\u30d7\u3059\u308b\u3068\uff0c\u305d\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u3059");
    }

    public void removeTabAt(int index) {
        super.removeTabAt(index);
    }

    public void drop(DropTargetDropEvent ev) {
        super.drop(ev);
        File file = this.getFile();
        try {
            this.mediator.menuBarMediator.open(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DOMTreeSource getCurrentEditingSource() {
        return (DOMTreeSource)this.mediator.getSourceManager().get(this.getSelectedIndex());
    }

    public void updateCurrentTitle() {
        DOMTreeSource source = this.getCurrentEditingSource();
        if (this.getSelectedIndex() >= 0) {
            this.setTitleAt(this.getSelectedIndex(), source.getTitle());
        }
        if (source.getFile() != null) {
            this.setToolTipTextAt(this.getComponentCount() - 1, source.getFile().getAbsolutePath());
        } else {
            this.setToolTipTextAt(this.getComponentCount() - 1, source.getURL().toString());
        }
        this.mediator.menuBarMediator.updateMenu();
    }

    public abstract Icon createTabIcon(DOMTreeSource var1);

    public void addComponent(DOMTreeSource source) {
        SourceEditorSplitPane body = this.createEditorSplitPane(source);
        this.add(source.getTitle(), body);
        this.setIconAt(this.getComponentCount() - 1, this.createTabIcon(source));
        this.setSelectedComponent(body);
        this.updateCurrentTitle();
    }

    public void setComponent(int index, DOMTreeSource source) {
        SourceEditorSplitPane body = this.createEditorSplitPane(source);
        this.setComponentAt(index, body);
        this.setTitleAt(index, source.getTitle());
        this.setIconAt(index, this.createTabIcon(source));
        if (source.getFile() != null) {
            this.setToolTipTextAt(index, source.getFile().getAbsolutePath());
        }
        this.setSelectedComponent(body);
    }

    private SourceEditorSplitPane createEditorSplitPane(DOMTreeSource source) {
        return this.createSourceEditorSplitPane(this.mediator, source, this.getWidth());
    }

    public SourceEditorSplitPane getCurrentSplitPane() {
        return (SourceEditorSplitPane)this.getComponentAt(this.getSelectedIndex());
    }

    public abstract SourceEditorSplitPane createSourceEditorSplitPane(SourceEditorMediator var1, DOMTreeSource var2, int var3);
}

