/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.httpd;

import java.io.File;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import net.sf.sqs_xml.httpd.FileContentServlet;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.servlet.ServletHandler;

public class MicroHttpd {
    int port;
    HttpServer server;
    private static final String LOOPBACK_ADDRESS = "127.0.0.1";
    static Map mimeMap = new HashMap();

    static {
        mimeMap.put("html", "text/html; charset=UTF-8");
        mimeMap.put("txt", "text/plain; charset=MS932");
        mimeMap.put("tif", "image/tiff");
        mimeMap.put("jpeg", "image/jpeg");
        mimeMap.put("png", "image/png");
    }

    public MicroHttpd(int port) {
        try {
            this.port = port;
            this.server = new HttpServer();
            this.addListeners(LOOPBACK_ADDRESS, this.port);
            this.addContexts();
            this.server.start();
        }
        catch (Exception e) {
            System.err.println("[ERROR] Another Process may be running.");
            e.printStackTrace();
            this.showServerStartupErrorMessageDialog(port);
            System.exit(-1);
        }
    }

    public void showServerStartupErrorMessageDialog(int port) {
        JOptionPane.showMessageDialog(null, new Object[]{"[FATAL ERROR] \u8d77\u52d5\u3067\u304d\u307e\u305b\u3093\uff0e", "\u539f\u56e0\uff1a\u5225\u306e\u30d7\u30ed\u30bb\u30b9\u304c\u8d77\u52d5\u3057\u3066\u3044\u307e\u3059(port " + port + "\u304c\u5360\u6709\u3055\u308c\u3066\u3044\u307e\u3059)"}, "FATAL ERROR", 0);
    }

    public void addListeners(String host, int port) throws UnknownHostException {
        SocketListener listener = new SocketListener();
        listener.setHost(host);
        listener.setPort(port);
        this.server.addListener((HttpListener)listener);
    }

    public void addContexts() {
        this.addJarContext();
        this.addFileContexts();
    }

    public void addFileContexts() {
        HttpContext fileContext = new HttpContext();
        fileContext.setContextPath("/File");
        ServletHandler fileServletHandler = new ServletHandler();
        fileServletHandler.addServlet("FileContentServlet", "/*", "net.sf.sqs_xml.httpd.FileContentServlet");
        fileContext.addHandler((HttpHandler)fileServletHandler);
        fileContext.setMimeMap(mimeMap);
        this.server.addContext(fileContext);
    }

    public void addJarContext() {
        HttpContext rootContext = new HttpContext();
        rootContext.setContextPath("/");
        ServletHandler servletHandler = new ServletHandler();
        servletHandler.addServlet("JarContentServlet", "/*", "net.sf.sqs_xml.httpd.JarContentServlet");
        rootContext.addHandler((HttpHandler)servletHandler);
        this.server.addContext(rootContext);
    }

    public String getBase() {
        return "http://127.0.0.1:" + this.port + "/";
    }

    public synchronized URL getURL(File file) {
        return FileContentServlet.getAltURL(this.getBase(), file);
    }
}

