/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.httpd;

import java.io.File;
import net.sf.sqs_xml.httpd.MicroHttpd;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class URLFilter
extends XMLFilterImpl {
    MicroHttpd httpd;
    String basePath;

    public URLFilter(MicroHttpd httpd, String basePath) {
        this.httpd = httpd;
        this.basePath = basePath;
    }

    public void startElement(String namespaceUri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        if (localName.equals("a")) {
            this.handleAnchor(attributes, attributesImpl);
        } else if (localName.equals("img")) {
            this.handleImage(attributes, attributesImpl);
        }
        super.startElement(namespaceUri, localName, qualifiedName, attributesImpl);
    }

    void handleImage(Attributes attributes, AttributesImpl attributesImpl) {
        String srcValue = attributes.getValue("src");
        attributesImpl.setValue(attributes.getIndex("src"), this.getConvertedValue(srcValue));
    }

    void handleAnchor(Attributes attributes, AttributesImpl attributesImpl) {
        String hrefValue;
        if (attributes.getIndex("href") >= 0 && !(hrefValue = attributes.getValue("href")).startsWith("http:") && !hrefValue.startsWith("file:")) {
            attributesImpl.setValue(attributes.getIndex("href"), this.getConvertedValue(hrefValue));
        }
    }

    public String getConvertedValue(String value) {
        return this.httpd.getURL(new File(String.valueOf(this.basePath) + File.separator + value)).toString();
    }
}

